<?php
class CComprobanteSolucionFactible extends CComprobante {
	function __construct() {
	}

	function __destruct() {
	}

	function cancelar($hConfWS, $sUuid, $sCorreo) {
		$iEstado = 1;
		$sMensaje = 'Error interno del sistema.';
		$hResponse = new stdClass();

		try {
            $hOptions = array();
			if($hConfWS->opc_proxy == '1') {
				$hOptions['proxy_host'] = $hConfWS->num_proxyhost;
				$hOptions['proxy_port'] = $hConfWS->num_port;
			}
			//$this->GrabaLog(sprintf('URL [ %s ]', $hConfWS->nom_url));
			$hConfWS->arc_empresacert = str_replace('-----BEGIN CERTIFICATE-----', '', $hConfWS->arc_empresacert);
			$hConfWS->arc_empresacert = str_replace('-----END CERTIFICATE-----', '', $hConfWS->arc_empresacert);
			$hConfWS->arc_empresakey = str_replace('-----BEGIN RSA PRIVATE KEY-----
', '', $hConfWS->arc_empresakey);
			$hConfWS->arc_empresakey = str_replace('
-----END RSA PRIVATE KEY-----', '', $hConfWS->arc_empresakey);
            
            $this->GrabaLog(sprintf("usuario........ [ %s ]", $hConfWS->nom_usuario));
            $this->GrabaLog(sprintf("password....... [ %s ]", $hConfWS->nom_password));
            $this->GrabaLog(sprintf("uuid........... [ %s ]", $sUuid));
            $this->GrabaLog(sprintf("rfcEmisor...... [ %s ]", $hConfWS->rfc_emisor));
            $this->GrabaLog(sprintf("emailNotifica.. [ %s ]", $sCorreo));
            $this->GrabaLog(sprintf("csdCer......... [ %s ]", $hConfWS->arc_empresacert));
            $this->GrabaLog(sprintf("csdKey......... [ %s ]", $hConfWS->arc_empresakey));
            $this->GrabaLog(sprintf("csdPassword.... [ %s ]", $hConfWS->cve_password));
            
			$cliente = new SoapClient($hConfWS->nom_url, $hOptions);
			//$this->GrabaLog('ENVIANDO SOLICITUD');
			$time_start = round(microtime(true) * 1000);
			$response = $cliente->cancelarAsincrono(array(
                "usuario"=>$hConfWS->nom_usuario, 
                "password"=>$hConfWS->nom_password, 
                "uuid"=>$sUuid, 
                "rfcEmisor"=>$hConfWS->rfc_emisor,
                "emailNotifica"=>$sCorreo,
                "csdCer"=>base64_decode($hConfWS->arc_empresacert), 
                "csdKey"=>base64_decode($hConfWS->arc_empresakey), 
                "csdPassword"=>$hConfWS->cve_password,
                "properties"=>null
                ));
			$time_end = round(microtime(true) * 1000);
			$time = $time_end - $time_start;
			$this->GrabaLog("DATOS OBTENIDOS DE PAC");
			$this->GrabaLog(sprintf("PAC STATUS......... [ %s ]", $response->return->status));
			$this->GrabaLog(sprintf("PAC MENSAJE........ [ %s ]", $response->return->mensaje));
			if($response->return->status != 200) {
				$sMensaje = $response->return->mensaje;
			}
			else {
				$iEstado = 0;
				$sMensaje = 'OK';
                $hResponse->respuestaPac = $response->return->mensaje;
			}
            
		}
		catch(exception $ex) {
			$iEstado = 2;
			$sMensaje = $ex->getMessage();
			$this->GrabaLog(sprintf("ERROR EN CANCELAR [ %s ]", $sMensaje. " UUID ".$sUuid));
		}
		//$this->GrabaLog(sprintf("CONEXION WS CANCELACION [ %s ]", $sMensaje));
		//if($iEstado == 2)
			//$sMensaje = 'Error interno del sistema.';
		$hResponse->estado = $iEstado;
		$hResponse->mensaje = $sMensaje;
		return $hResponse;
	}

	function timbrar($hConfWS, $sXml) {
		//$this->GrabaLog(sprintf("METODO TIMBRADO.. [ %s ]", $sXml));	
		$sCadenaOriginal = '';
		$iEstado = 1;
		$sMensaje = 'Error interno del sistema.';
		$sSello = '';
		$hResponse = new stdClass();
		$hProcesa = NULL;
		try {
			$sXml = $this->complementaXML($sXml, $hConfWS->arc_xmldomiciliofiscal, $hConfWS->fec_xml, $hConfWS->nom_certificado);			
			
			$hProcesa = $this->procesaXmlComprobante($sXml);
			if($hProcesa->estado != 0) {
				$sMensaje = $hProcesa->mensaje;
			}
			else {
				if(($sCadenaOriginal = $this->generaCadenaOriginal($sXml)) == NULL)
				{
					$sMensaje = 'Error al generar cadena original.';					
					}
				else {
					//$hConfWS->arc_empresakey = str_replace('-----BEGIN RSA PRIVATE KEY-----', '', $hConfWS->arc_empresakey);
					//$hConfWS->arc_empresakey = str_replace('-----END RSA PRIVATE KEY-----', '', $hConfWS->arc_empresakey);
					if(($sSello = $this->generaSello($hConfWS->arc_empresakey, $sCadenaOriginal)) == NULL) {
						
						$sMensaje = $hConfWS->arc_empresakey .' Error al generar sello.';
						//$sMensaje = 'Error al generar sello.';
					}
					else {
						$sXml = $this->agregarCertificadoYSello($sXml, $hConfWS->arc_empresacert, $sSello);
						$hDatosPac = $this->timbrarXML($hConfWS, $sXml);
						if($hDatosPac->estado != 0)
							$sMensaje = $hDatosPac->mensaje;
						else {
							$iEstado = 0;
							$sMensaje = 'OK';
							$hDatosPac->total = intval(floatval($hProcesa->comprobante->total) * 100);
							$hDatosPac->subtotal = intval(floatval($hProcesa->comprobante->subTotal) * 100);
							$hDatosPac->descuento = intval(floatval($hProcesa->comprobante->descuento) * 100) + intval(floatval($hProcesa->comprobante->Impuestos->Retenciones->Retencion->importe) * 100);
							$hResponse->datosPac = $hDatosPac;
						}
					}
				}
			}
		}
		catch(exception $ex) {
			$iEstado = 2;
			$sMensaje = $ex->getMessage();
			$this->GrabaLog(sprintf("ERROR EN TIMBRADO....... [ %s ]", $sMensaje." XML ".$sXml));
		}
		//$this->GrabaLog(sprintf("TIMBRADO....... [ %s ]", $sMensaje));
		//if($iEstado == 2)
			//$sMensaje = 'Error interno del sistema.';
		$hResponse->estado = $iEstado;
		$hResponse->mensaje = $sMensaje;
		return $hResponse;
	}

	function timbrar33($hConfWS, $sXml) {
		//$this->GrabaLog(sprintf("METODO TIMBRADO.. [ %s ]", $sXml));	
		$sCadenaOriginal = '';
		$iEstado = 1;
		$sMensaje = 'Error interno del sistema.';
		$sSello = '';
		$hResponse = new stdClass();
		$hProcesa = NULL;
		try {
			$sXml = $this->complementaXML33($sXml, $hConfWS->arc_xmldomiciliofiscal, $hConfWS->fec_xml, $hConfWS->nom_certificado);			
			
			$hProcesa = $this->procesaXmlComprobante33($sXml);
			if($hProcesa->estado != 0) {
				$sMensaje = $hProcesa->mensaje;
			}
			else {
				if(($sCadenaOriginal = $this->generaCadenaOriginal33($sXml)) == NULL)
				{
					$sMensaje = 'Error al generar cadena original.';					
					}
				else {
					//$hConfWS->arc_empresakey = str_replace('-----BEGIN RSA PRIVATE KEY-----', '', $hConfWS->arc_empresakey);
					//$hConfWS->arc_empresakey = str_replace('-----END RSA PRIVATE KEY-----', '', $hConfWS->arc_empresakey);
					if(($sSello = $this->generaSello33($hConfWS->arc_empresakey, $sCadenaOriginal)) == NULL) {
						
						$sMensaje = 'Error al generar sello SF...'.$hConfWS->arc_empresakey;
						//$sMensaje = 'Error al generar sello.';
					}
					else {
						$sXml = $this->agregarCertificadoYSello33($sXml, $hConfWS->arc_empresacert, $sSello);
						$hDatosPac = $this->timbrarXML33($hConfWS, $sXml);
						if($hDatosPac->estado != 0)
							$sMensaje = $hDatosPac->mensaje;
						else {
							$iEstado = 0;
							$sMensaje = 'OK';
							$hDatosPac->total = intval(floatval($hProcesa->comprobante->Total) * 100);
							$hDatosPac->subtotal = intval(floatval($hProcesa->comprobante->SubTotal) * 100);
							$hDatosPac->descuento = intval(floatval($hProcesa->comprobante->Descuento) * 100);
							$hResponse->datosPac = $hDatosPac;
						}
					}
				}
			}
		}
		catch(exception $ex) {
			$iEstado = 2;
			$sMensaje = $ex->getMessage();
			$this->GrabaLog(sprintf("ERROR EN TIMBRADO....... [ %s ]", $sMensaje." XML ".$sXml));
		}
		//$this->GrabaLog(sprintf("TIMBRADO....... [ %s ]", $sMensaje));
		//if($iEstado == 2)
			//$sMensaje = 'Error interno del sistema.';
		$hResponse->estado = $iEstado;
		$hResponse->mensaje = $sMensaje;
		return $hResponse;
	}
	
	private function timbrarXML($hConfWS, $sXml) {
		$iEstado = 1;
		$sMensaje = 'Error interno del sistema.';
		$hResponse = new stdClass();
		try {
			$this->GrabaLog('CONECTANDO AL SERVICIO WEB DE TIMBRADO');
			$hOptions = array();
			if($hConfWS->opc_proxy == '1') {
				$hOptions['proxy_host'] = $hConfWS->num_proxyhost;
				$hOptions['proxy_port'] = $hConfWS->num_port;
			}
			$this->GrabaLog(sprintf('URL [ %s ]', $hConfWS->nom_url));
			$cliente = new SoapClient($hConfWS->nom_url, $hOptions);
			$time_start = round(microtime(true) * 1000);
			$this->GrabaLog(sprintf("XML ENVIO.............. [ %s ]", $sXml));
			$this->GrabaLog('ENVIANDO SOLICITUD');
			  $response = $cliente->timbrarBase64(array("usuario"=>$hConfWS->nom_usuario, "password"=>$hConfWS->nom_password, "cfdiBase64"=>base64_encode($sXml), "zip"=>"false"));

			$time_end = round(microtime(true) * 1000);
			$time = $time_end - $time_start;
			$this->GrabaLog(sprintf("RESPUESTA MS......... [ %s ]", $time));
			$this->GrabaLog("DATOS OBTENIDOS DE PAC");
			$this->GrabaLog(sprintf("TIMBRE STATUS.......... [ %s ]", $response->return->status));
			$this->GrabaLog(sprintf("TIMBRE MENSAJE......... [ %s ]", $response->return->mensaje));
			$this->GrabaLog(sprintf("CFDI CADENA ORIGINAL... [ %s ]", $response->return->resultados->cadenaOriginal));
			$this->GrabaLog(sprintf("CFDI CERTIFICADO SAT... [ %s ]", $response->return->resultados->certificadoSAT));
			$this->GrabaLog(sprintf("CFDI TIMBRADO.......... [ %s ]", $response->return->resultados->cfdiTimbrado));
			$this->GrabaLog(sprintf("CFDI FECHA TIMBRADO.... [ %s ]", $response->return->resultados->fechaTimbrado));
			$this->GrabaLog(sprintf("CFDI MENSAJE........... [ %s ]", $response->return->resultados->mensaje));
			$this->GrabaLog(sprintf("CFDI QR CODE........... [ %s ]", base64_encode($response->return->resultados->qrCode)));
			$this->GrabaLog(sprintf("CFDI SELLO SAT......... [ %s ]", $response->return->resultados->selloSAT));
			$this->GrabaLog(sprintf("CFDI STATUS............ [ %s ]", $response->return->resultados->status));
			$this->GrabaLog(sprintf("CFDI UUID.............. [ %s ]", $response->return->resultados->uuid));
			$this->GrabaLog(sprintf("CFDI VERSION TFD....... [ %s ]", $response->return->resultados->versionTFD));
			if($response->return->status != 200){
				$sMensaje = $response->return->mensaje;
				}
			else if($response->return->resultados->status != 200 && $response->return->resultados->status != 307) {
					$sMensaje = $response->return->resultados->mensaje; 
	
			}
			else {
				$iEstado = 0;
				$sMensaje = 'OK';
				$hResponse->cadenaOriginal = $response->return->resultados->cadenaOriginal;
				$hResponse->certificadoSAT = $response->return->resultados->certificadoSAT;
				$hResponse->xmlTimbrado = $response->return->resultados->cfdiTimbrado;
				$hResponse->fechatimbrado = $response->return->resultados->fechaTimbrado;
				$hResponse->qr = $response->return->resultados->qrCode;
				$hResponse->selloSAT = $response->return->resultados->selloSAT;
				$hResponse->uuid = $response->return->resultados->uuid;
				$hResponse->versionTFD = $response->return->resultados->versionTFD;			
			}
		}
		catch(exception $ex) {
			$iEstado = 2;
			$sMensaje = $ex->getMessage();
			$this->GrabaLog(sprintf("ERROR EN timbrarXML [ %s ]", $sMensaje." XML ".$sXml));
		}
		//$this->GrabaLog(sprintf("CONEXION WS TIMBRADO [ %s ]", $sMensaje));
		//if($iEstado == 2)
			//$sMensaje = 'Error interno del sistema.';
		$hResponse->estado = $iEstado;
		$hResponse->mensaje = $sMensaje;
		return $hResponse;
	}
	
	private function timbrarXML33($hConfWS, $sXml) {
		$iEstado = 1;
		$sMensaje = 'Error interno del sistema.';
		$hResponse = new stdClass();
		try {
			$this->GrabaLog('CONECTANDO AL SERVICIO WEB DE TIMBRADO');
			$hOptions = array();
			if($hConfWS->opc_proxy == '1') {
				$hOptions['proxy_host'] = $hConfWS->num_proxyhost;
				$hOptions['proxy_port'] = $hConfWS->num_port;
			}
			$this->GrabaLog(sprintf('URL [ %s ]', $hConfWS->nom_url));
			$cliente = new SoapClient($hConfWS->nom_url, $hOptions);
			$time_start = round(microtime(true) * 1000);
			$this->GrabaLog(sprintf("XML ENVIO.............. [ %s ]", $sXml));
			$this->GrabaLog('ENVIANDO SOLICITUD');
			  $response = $cliente->timbrarBase64(array("usuario"=>$hConfWS->nom_usuario, "password"=>$hConfWS->nom_password, "cfdiBase64"=>base64_encode($sXml), "zip"=>"false"));

			$time_end = round(microtime(true) * 1000);
			$time = $time_end - $time_start;
			$this->GrabaLog(sprintf("RESPUESTA MS......... [ %s ]", $time));
			$this->GrabaLog("DATOS OBTENIDOS DE PAC");
			$this->GrabaLog(sprintf("TIMBRE STATUS.......... [ %s ]", $response->return->status));
			$this->GrabaLog(sprintf("TIMBRE MENSAJE......... [ %s ]", $response->return->mensaje));
			$this->GrabaLog(sprintf("CFDI CADENA ORIGINAL... [ %s ]", $response->return->resultados->cadenaOriginal));
			$this->GrabaLog(sprintf("CFDI CERTIFICADO SAT... [ %s ]", $response->return->resultados->certificadoSAT));
			$this->GrabaLog(sprintf("CFDI TIMBRADO.......... [ %s ]", $response->return->resultados->cfdiTimbrado));
			$this->GrabaLog(sprintf("CFDI FECHA TIMBRADO.... [ %s ]", $response->return->resultados->fechaTimbrado));
			$this->GrabaLog(sprintf("CFDI MENSAJE........... [ %s ]", $response->return->resultados->mensaje));
			$this->GrabaLog(sprintf("CFDI QR CODE........... [ %s ]", base64_encode($response->return->resultados->qrCode)));
			$this->GrabaLog(sprintf("CFDI SELLO SAT......... [ %s ]", $response->return->resultados->selloSAT));
			$this->GrabaLog(sprintf("CFDI STATUS............ [ %s ]", $response->return->resultados->status));
			$this->GrabaLog(sprintf("CFDI UUID.............. [ %s ]", $response->return->resultados->uuid));
			$this->GrabaLog(sprintf("CFDI VERSION TFD....... [ %s ]", $response->return->resultados->versionTFD));
			if($response->return->status != 200){
				$sMensaje = $response->return->mensaje;
				}
			else if($response->return->resultados->status != 200 && $response->return->resultados->status != 307) {
					$sMensaje = $response->return->resultados->mensaje; 
	
			}
			else {
				$iEstado = 0;
				$sMensaje = 'OK';
				$hResponse->cadenaOriginal = $response->return->resultados->cadenaOriginal;
				$hResponse->certificadoSAT = $response->return->resultados->certificadoSAT;
				$hResponse->xmlTimbrado = $response->return->resultados->cfdiTimbrado;
				$hResponse->fechatimbrado = $response->return->resultados->fechaTimbrado;
				$hResponse->qr = $response->return->resultados->qrCode;
				$hResponse->selloSAT = $response->return->resultados->selloSAT;
				$hResponse->uuid = $response->return->resultados->uuid;
				$hResponse->versionTFD = $response->return->resultados->versionTFD;			
			}
		}
		catch(exception $ex) {
			$iEstado = 2;
			$sMensaje = $ex->getMessage();
			$this->GrabaLog(sprintf("ERROR EN timbrarXML [ %s ]", $sMensaje." XML ".$sXml));
		}
		//$this->GrabaLog(sprintf("CONEXION WS TIMBRADO [ %s ]", $sMensaje));
		//if($iEstado == 2)
			//$sMensaje = 'Error interno del sistema.';
		$hResponse->estado = $iEstado;
		$hResponse->mensaje = $sMensaje;
		return $hResponse;
	}
}
?>
