<?php 
class CDAMovtoTimbrado extends CGenerales {
    function __construct() {
    }

    function __destruct() {
    }
    
    function buscarMovtoEmpleado($sEmpleado, $sFecNomina) {
        $datosFactura = NULL;
        $sMensaje = "OK";
        try {
            $hCon = $this->activarConexion($GLOBALS['ODBC_CONNECTIONSTRING']['FACTURACIONELECTRONICA']);
            if($hCon == NULL) {
                $sMensaje = 'Error al conectar con la base de datos facturacionelectronica';
            }
            else {
                $hCmd = $hCon->createCommand();
                $hCmd->setCommandText( sprintf("SELECT idu_estado, des_mensaje, arc_xml, arc_qr FROM fun_buscarfacturaelectronicanominaporempleado(%s, '%s');;", $sEmpleado, $sFecNomina) );
                $this->GrabaDebug( sprintf("SELECT idu_estado, des_mensaje, arc_xml, arc_qr FROM fun_buscarfacturaelectronicanominaporempleado(%s, '%s');;", $sEmpleado, $sFecNomina) );
                $ds = $hCmd->executeDataSet(TRUE);
                if(count($ds) > 0) {
                    if($ds[0]['idu_estado'] != 0) {
                        $sMensaje = $ds[0]['des_mensaje'];
                    }
                    else {
                        $datosFactura = new stdClass();
                        $datosFactura->xmlTimbrado = $ds[0]['arc_xml'];
                        $datosFactura->qr = $ds[0]['arc_qr'];
                        //$this->GrabaDebug(sprintf('buscarMovtoEmpleado... [ %s ]', $ds[0]['arc_xml']));
                    }
                }
                else {
                    $sMensaje = 'No se obtuvo respuesta de la base de datos';
                }
            }
            $hCon->close();
        }
        catch(exception $ex) {
            $sMensaje = $ex->getMessage();
            $this->GrabaLog(sprintf('ERROR EN buscarMovtoEmpleado... [ %s ]', $sMensaje));
        }
        //$this->GrabaDebug(sprintf('BUSCAR MOVTO... [ %s ]', $sMensaje));
        return $datosFactura;
    }

    function grabarMovtoCancelacion($sFolio, $sRespuestaPac) {
        $hResponse = new stdClass();
        $iEstado = 1; 
        $sMensaje = 'Error interno del sistema.';
        try {
            $hCon = $this->activarConexion($GLOBALS['ODBC_CONNECTIONSTRING']['FACTURACIONELECTRONICA']);
            if($hCon == NULL) {
                $sMensaje = 'Error al conectar con la base de datos facturacionelectronica';
            }
            else {
                $hCmd = $hCon->createCommand();
                $sQuery = sprintf("SELECT idu_estado, des_mensaje FROM fun_cancelafacturaelectronicanominaresponse(%s, '%s');", $sFolio, $sRespuestaPac);
                $hCmd->setCommandText($sQuery);
                $this->GrabaDebug($sQuery);
                $ds = $hCmd->executeDataSet(TRUE);
                if(count($ds) > 0) {
                    if($ds[0]['idu_estado'] == 0) {
                        $iEstado = 0;
                    }
                    $sMensaje = $ds[0]['des_mensaje'];
                }
                else {
                    $iEstado = 2;
                    $sMensaje = 'No se obtuvo respuesta de la base de datos';
                }
            }
            $hCon->close();
        }
        catch(exception $ex) {
            $iEstado = 2;
            if( $sQuery != '' ) {
                $sMensaje = $ex->getMessage();
                $this->GrabaLog(sprintf('ERROR EN grabarMovtoCancelacion... [ %s ] ... NO SE EJECUTO CORRECTAMENTE %s', $sMensaje, $sQuery));
                $this->GrabaDebug(sprintf('ERROR EN grabarMovtoCancelacion... [ %s ] ... NO SE EJECUTO CORRECTAMENTE %s', $sMensaje, $sQuery));
            } else {
                $sMensaje = $ex->getMessage();
                $this->GrabaLog(sprintf('ERROR EN grabarMovtoCancelacion... [ %s ] ', $sMensaje));
                $this->GrabaDebug(sprintf('ERROR EN grabarMovtoCancelacion... [ %s ] ', $sMensaje));
            }
        }
        $this->GrabaDebug(sprintf('REGISTRO DE RESPONSE [ %s ]', $sMensaje));
        //if($iEstado == 2)
            //$sMensaje = 'Error al registrar solicitud en la base de datos.';
        $hResponse->estado = $iEstado;
        $hResponse->mensaje = $sMensaje;
        return $hResponse;
    }
    
    function grabarMovtoCancelacionPre($sUuid, $sEmpleadoCancela) {
        $hResponse = new stdClass();
        $iEstado = 1; 
        $sMensaje = 'Error interno del sistema.';
        try {
            $hCon = $this->activarConexion($GLOBALS['ODBC_CONNECTIONSTRING']['FACTURACIONELECTRONICA']);
            if($hCon == NULL) {
                $sMensaje = 'Error al conectar con la base de datos facturacionelectronica';
            }
            else {
                $hCmd = $hCon->createCommand();
                $sQuery = sprintf("SELECT idu_estado, des_mensaje, idu_folio, num_paccfdi, nom_url, opc_proxy, num_proxyhost, num_port, opc_credenciales, nom_usuario, nom_password, des_token, nom_certificado, arc_empresacert, arc_empresakey, rfc_emisor, xml_timbrado, cve_password FROM fun_cancelafacturaelectronicanominarequest02('%s', %s);", $sUuid, $sEmpleadoCancela);
                $hCmd->setCommandText($sQuery);
                $this->GrabaDebug($sQuery);
                $ds = $hCmd->executeDataSet(TRUE);
                if(count($ds) > 0) {
                    if($ds[0]['idu_estado'] != 0) {
                        $sMensaje = $ds[0]['des_mensaje'];
                    }
                    else {
                        $hResponse->configuracionWS = new stdClass();
                        $hResponse->configuracionWS->idu_estado         = $ds[0]['idu_estado'];
                        $hResponse->configuracionWS->des_mensaje        = $ds[0]['des_mensaje'];
                        $hResponse->configuracionWS->idu_folio          = $ds[0]['idu_folio'];
                        $hResponse->configuracionWS->num_paccfdi        = $ds[0]['num_paccfdi'];
                        $hResponse->configuracionWS->nom_url            = $ds[0]['nom_url'];
                        $hResponse->configuracionWS->opc_proxy          = $ds[0]['opc_proxy'];
                        $hResponse->configuracionWS->num_proxyhost      = $ds[0]['num_proxyhost'];
                        $hResponse->configuracionWS->num_port           = $ds[0]['num_port'];
                        $hResponse->configuracionWS->opc_credenciales   = $ds[0]['opc_credenciales'];
                        $hResponse->configuracionWS->nom_usuario        = $ds[0]['nom_usuario'];
                        $hResponse->configuracionWS->nom_password       = $ds[0]['nom_password'];
                        $hResponse->configuracionWS->des_token          = $ds[0]['des_token'];
                        $hResponse->configuracionWS->nom_certificado    = $ds[0]['nom_certificado'];
                        $hResponse->configuracionWS->arc_empresacert    = $ds[0]['arc_empresacert'];
                        $hResponse->configuracionWS->arc_empresakey     = $ds[0]['arc_empresakey'];
                        $hResponse->configuracionWS->rfc_emisor         = $ds[0]['rfc_emisor'];
                        $hResponse->configuracionWS->xml_timbrado       = $ds[0]['xml_timbrado'];
                        $hResponse->configuracionWS->cve_password       = $ds[0]['cve_password'];

                        //$this->GrabaDebug(sprintf('grabarMovtoCancelacionPre token. [ %s ] ', $ds[0]['des_token']));
                        $iEstado = 0;
                        $sMensaje = 'OK';
                    }
                }
                else {
                    $iEstado = 2;
                    $sMensaje = 'No se obtuvo respuesta de la base de datos';
                }
            }
            $hCon->close();
        }
        catch(exception $ex) {
            $iEstado = 2;
            if( $sQuery != '' ) {
                $sMensaje = $ex->getMessage();
                $this->GrabaLog(sprintf('ERROR EN grabarMovtoCancelacionPre... [ %s ] ... NO SE EJECUTO CORRECTAMENTE %s', $sMensaje, $sQuery));
                $this->GrabaDebug(sprintf('ERROR EN grabarMovtoCancelacionPre... [ %s ] ... NO SE EJECUTO CORRECTAMENTE %s', $sMensaje, $sQuery));
            } else {
                $sMensaje = $ex->getMessage();
                $this->GrabaLog(sprintf('ERROR EN grabarMovtoCancelacionPre... [ %s ]', $sMensaje));
                $this->GrabaDebug(sprintf('ERROR EN grabarMovtoCancelacionPre... [ %s ]', $sMensaje));
            }
        }
        $this->GrabaDebug(sprintf('REGISTRO DE SOLICITUD [ %s ]', $sMensaje));
        //if($iEstado == 2)
            //$sMensaje = 'Error al registrar solicitud en la base de datos.';
        $hResponse->estado = $iEstado;
        $hResponse->mensaje = $sMensaje;
        return $hResponse;
    }
    
    function grabarMovtoPre($sXml, $sRfc, $sEmpleado, $sFecNomina, $sEmpleadoGenera) {
        $hResponse = new stdClass();
        $iEstado = 1; 
        $sMensaje = 'Error interno del sistema.';
        try {
            $this->GrabaDebug('REGISTRANDO SOLICITUD EN LA BASE DE DATOS: grabarMovtoPre');
            $hCon = $this->activarConexion($GLOBALS['ODBC_CONNECTIONSTRING']['FACTURACIONELECTRONICA']);
            if($hCon == NULL) {
                $sMensaje = 'Error al establecer conexión con la base de datos facturacionelectronica.';
            }
            else {
                $hCmd = $hCon->createCommand();
                $sQuery = sprintf("SELECT idu_folio, des_mensaje, num_paccfdi, nom_url, opc_proxy, num_proxyhost, num_port, opc_credenciales, nom_usuario, nom_password, nom_certificado, arc_empresacert, arc_empresakey, arc_xmldomiciliofiscal, fec_xml FROM fun_timbradofacturaelectronicanominarequest('%s', %s, %s, '%s', '%s');", $sRfc, $sEmpleado, $sEmpleadoGenera, $sFecNomina, $sXml); 
                $hCmd->setCommandText($sQuery);
                $this->GrabaDebug($sQuery);
                $ds = $hCmd->executeDataSet(TRUE);
                if(count($ds) > 0) {
                    if($ds[0]['idu_folio'] == 0) {
                        $sMensaje = $ds[0]['des_mensaje'];
                    }
                    else {
                        $hResponse->configuracionWS = new stdClass();
                        $hResponse->configuracionWS->idu_folio = $ds[0]['idu_folio'];
                        $hResponse->configuracionWS->des_mensaje = $ds[0]['des_mensaje'];
                        $hResponse->configuracionWS->num_paccfdi = $ds[0]['num_paccfdi'];
                        $hResponse->configuracionWS->nom_url = $ds[0]['nom_url'];
                        $hResponse->configuracionWS->opc_proxy = $ds[0]['opc_proxy'];
                        $hResponse->configuracionWS->num_proxyhost = $ds[0]['num_proxyhost'];
                        $hResponse->configuracionWS->num_port = $ds[0]['num_port'];
                        $hResponse->configuracionWS->opc_credenciales = $ds[0]['opc_credenciales'];
                        $hResponse->configuracionWS->nom_usuario = $ds[0]['nom_usuario'];
                        $hResponse->configuracionWS->nom_password = $ds[0]['nom_password'];
                        $hResponse->configuracionWS->nom_certificado = $ds[0]['nom_certificado'];
                        $hResponse->configuracionWS->arc_empresacert = $ds[0]['arc_empresacert'];
                        $hResponse->configuracionWS->arc_empresakey = $ds[0]['arc_empresakey'];
                        $hResponse->configuracionWS->arc_xmldomiciliofiscal = $ds[0]['arc_xmldomiciliofiscal'];
                        $hResponse->configuracionWS->fec_xml = $ds[0]['fec_xml'];
                        //$hResponse->configuracionWS->fec_xml = '2014-02-11T12:55:10';
                        $iEstado = 0;
                        $sMensaje = 'OK';
                    }
                }
                else {
                    $iEstado = 2;
                    $sMensaje = 'No se obtuvo respuesta de la base de datos';
                }
            }
            $hCon->close();
        }
        catch(exception $ex) {
            $iEstado = 2;
            if( $sQuery != '' ) {
                $sMensaje = $ex->getMessage();
                $this->GrabaLog(sprintf('ERROR EN grabarMovtoPre... [ %s ] ... NO SE EJECUTO CORRECTAMENTE %s', $sMensaje, $sQuery));
                $this->GrabaDebug(sprintf('ERROR EN grabarMovtoPre... [ %s ] ... NO SE EJECUTO CORRECTAMENTE %s', $sMensaje, $sQuery));
            } else {
                $sMensaje = $ex->getMessage();
                $this->GrabaLog(sprintf('ERROR EN grabarMovtoPre... [ %s ]', $sMensaje));
                $this->GrabaDebug(sprintf('ERROR EN grabarMovtoPre... [ %s ]', $sMensaje));
            }
        }
        $this->GrabaDebug(sprintf('REGISTRO DE RESPONSE [ %s ]', $sMensaje));
        //if($iEstado == 2)
            //$sMensaje = 'Error al registrar solicitud en la base de datos.';
        $hResponse->estado = $iEstado;
        $hResponse->mensaje = $sMensaje;
        return $hResponse;
    }

    function grabarRespuestaPac($idu_folio, $hDatosPac) {
        $hResponse = new stdClass();
        $iEstado = 1; 
        $sMensaje = 'Error interno del sistema.';
        try {
            $hCon = $this->activarConexion($GLOBALS['ODBC_CONNECTIONSTRING']['FACTURACIONELECTRONICA']);
            if($hCon == NULL) {
                $sMensaje = 'Error al conectar con la base de datos facturacionelectronica';
            }
            else {
                $hCmd = $hCon->createCommand();
                $sQuery = sprintf("SELECT idu_estado, des_mensaje FROM fun_timbradofacturaelectronicanominaresponse(%s, %s, %s, %s, '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s');", $idu_folio, $hDatosPac->total, $hDatosPac->subtotal, $hDatosPac->descuento, $hDatosPac->cadenaOriginal, $hDatosPac->certificadoSAT, $hDatosPac->xmlTimbrado, $hDatosPac->fechatimbrado, base64_encode($hDatosPac->qr), $hDatosPac->selloSAT, $hDatosPac->uuid, $hDatosPac->versionTFD); 
                $hCmd->setCommandText($sQuery);
                $this->GrabaDebug($sQuery);
                $ds = $hCmd->executeDataSet(TRUE);
                if(count($ds) > 0) {
                    if($ds[0]['idu_folio'] == 0) {
                        $iEstado = 0;
                    }
                    $sMensaje = $ds[0]['des_mensaje'];
                }
                else {
                    $sMensaje = 'Error al registrar respuesta de pac en la base de datos.';
                }
            }
            $hCon->close();
        }
        catch(exception $ex) {
            $iEstado = 2;
            if( $sQuery != '' ) {
                $sMensaje = $ex->getMessage();
                $this->GrabaLog(sprintf('ERROR EN grabarRespuestaPac... [ %s ] ... NO SE EJECUTO CORRECTAMENTE %s', $sMensaje, $sQuery));
                $this->GrabaDebug(sprintf('ERROR EN grabarRespuestaPac... [ %s ] ... NO SE EJECUTO CORRECTAMENTE %s', $sMensaje, $sQuery));
            } else {
                $sMensaje = $ex->getMessage();
                $this->GrabaLog(sprintf('ERROR EN grabarRespuestaPac... [ %s ]', $sMensaje));
                $this->GrabaDebug(sprintf('ERROR EN grabarRespuestaPac... [ %s ]', $sMensaje));
            }
        }
        $this->GrabaDebug(sprintf('GRABAR RESPUESTA  PAC [ %s ]', $sMensaje));
        //if($iEstado == 2) $sMensaje = 'Error interno del sistema.';
        $hResponse->estado = $iEstado;
        $hResponse->mensaje = $sMensaje;
        return $hResponse;
    }

    function grabarMovtoPre33($sXml, $sRfc, $sEmpleado, $sFecNomina, $sEmpleadoGenera, $sTipoComprobante, $sNumControl, $sNumIdentKey) {
        $hResponse = new stdClass();
        $iEstado = 1; 
        $sMensaje = 'Error interno del sistema.';
        try {
            $this->GrabaDebug('REGISTRANDO SOLICITUD EN LA BASE DE DATOS: grabarMovtoPre33');
            $hCon = $this->activarConexion($GLOBALS['ODBC_CONNECTIONSTRING']['FACTURACIONELECTRONICA']);
            if($hCon == NULL) {
                $sMensaje = 'Error al establecer conexión con la base de datos facturacionelectronica.';
            }
            else {
                $hCmd = $hCon->createCommand();
                $sQuery = sprintf("SELECT idu_folio, des_mensaje, num_paccfdi, nom_url, opc_proxy, num_proxyhost, num_port, opc_credenciales, nom_usuario, nom_password, des_token, nom_certificado, arc_empresacert, arc_empresakey, arc_xmldomiciliofiscal, fec_xml FROM fun_timbradofacturaelectronicanominarequest02('%s', %s, %s, '%s', '%s', %s, %s, %s);", $sRfc, $sEmpleado, $sEmpleadoGenera, $sFecNomina, $sXml, $sTipoComprobante, $sNumControl, $sNumIdentKey); 
                $hCmd->setCommandText($sQuery);
                $this->GrabaDebug($sQuery);
                $ds = $hCmd->executeDataSet(TRUE);
                if(count($ds) > 0) {
                    if($ds[0]['idu_folio'] == 0) {
                        $sMensaje = $ds[0]['des_mensaje'];
                    }
                    else {
                        $hResponse->configuracionWS = new stdClass();
                        $hResponse->configuracionWS->idu_folio              = $ds[0]['idu_folio'];
                        $hResponse->configuracionWS->des_mensaje            = $ds[0]['des_mensaje'];
                        $hResponse->configuracionWS->num_paccfdi            = $ds[0]['num_paccfdi'];
                        $hResponse->configuracionWS->nom_url                = $ds[0]['nom_url'];
                        $hResponse->configuracionWS->opc_proxy              = $ds[0]['opc_proxy'];
                        $hResponse->configuracionWS->num_proxyhost          = $ds[0]['num_proxyhost'];
                        $hResponse->configuracionWS->num_port               = $ds[0]['num_port'];
                        $hResponse->configuracionWS->opc_credenciales       = $ds[0]['opc_credenciales'];
                        $hResponse->configuracionWS->nom_usuario            = $ds[0]['nom_usuario'];
                        $hResponse->configuracionWS->nom_password           = $ds[0]['nom_password'];
                        $hResponse->configuracionWS->des_token              = $ds[0]['des_token'];
                        $hResponse->configuracionWS->nom_certificado        = $ds[0]['nom_certificado'];
                        $hResponse->configuracionWS->arc_empresacert        = $ds[0]['arc_empresacert'];
                        $hResponse->configuracionWS->arc_empresakey         = $ds[0]['arc_empresakey'];
                        $hResponse->configuracionWS->arc_xmldomiciliofiscal = $ds[0]['arc_xmldomiciliofiscal'];
                        $hResponse->configuracionWS->fec_xml                = $ds[0]['fec_xml'];

                        //$this->GrabaDebug(sprintf('grabarMovtoPre33 token. [ %s ] ', $ds[0]['des_token']));
                        $iEstado = 0;
                        $sMensaje = 'OK';
                    }
                }
                else {
                    $iEstado = 2;
                    $sMensaje = 'No se obtuvo respuesta de la base de datos';
                }
            }
            $hCon->close();
        }
        catch(exception $ex) {
            $iEstado = 2;
            if( $sQuery != '' ) {
                $sMensaje = $ex->getMessage();
                $this->GrabaLog(sprintf('ERROR EN grabarMovtoPre33... [ %s ] ... NO SE EJECUTO CORRECTAMENTE %s', $sMensaje, $sQuery));
                $this->GrabaDebug(sprintf('ERROR EN grabarMovtoPre33... [ %s ] ... NO SE EJECUTO CORRECTAMENTE %s', $sMensaje, $sQuery));
            } else {
                $sMensaje = $ex->getMessage();
                $this->GrabaLog(sprintf('ERROR EN grabarMovtoPre33... [ %s ]', $sMensaje));
                $this->GrabaDebug(sprintf('ERROR EN grabarMovtoPre33... [ %s ]', $sMensaje));
            }
        }
        $this->GrabaDebug(sprintf('REGISTRO DE RESPONSE [ %s ]', $sMensaje));
        //if($iEstado == 2)
            //$sMensaje = 'Error al registrar solicitud en la base de datos.';
        $hResponse->estado = $iEstado;
        $hResponse->mensaje = $sMensaje;
        return $hResponse;
    }

    function grabarRespuestaPac33($idu_folio, $hDatosPac, $sTipoComprobante) {
        $hResponse = new stdClass();
        $iEstado = 1; 
        $sMensaje = 'Error interno del sistema.';
        try {
            $hCon = $this->activarConexion($GLOBALS['ODBC_CONNECTIONSTRING']['FACTURACIONELECTRONICA']);
            if($hCon == NULL) {
                $sMensaje = 'Error al conectar con la base de datos facturacionelectronica';
            }
            else {
                $hCmd = $hCon->createCommand();
                $sQuery = sprintf("SELECT idu_estado, des_mensaje FROM fun_timbradofacturaelectronicanominaresponse01(%s, %s, %s, %s, '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s', %s);", $idu_folio, $hDatosPac->total, $hDatosPac->subtotal, $hDatosPac->descuento, $hDatosPac->cadenaOriginal, $hDatosPac->certificadoSAT, $hDatosPac->xmlTimbrado, $hDatosPac->fechatimbrado, base64_encode($hDatosPac->qr), $hDatosPac->selloSAT, $hDatosPac->uuid, $hDatosPac->versionTFD, $sTipoComprobante); 
                $hCmd->setCommandText($sQuery);
                $this->GrabaDebug($sQuery);
                $ds = $hCmd->executeDataSet(TRUE);
                if(count($ds) > 0) {
                    if($ds[0]['idu_folio'] == 0) {
                        $iEstado = 0;
                    }
                    $sMensaje = $ds[0]['des_mensaje'];
                }
                else {
                    $sMensaje = 'Error al registrar respuesta de pac en la base de datos.';
                }
            }
            $hCon->close();
        }
        catch(exception $ex) {
            $iEstado = 2;
            if( $sQuery != '' ) {
                $sMensaje = $ex->getMessage();
                $this->GrabaLog(sprintf('ERROR EN grabarRespuestaPac33... [ %s ] ... NO SE EJECUTO CORRECTAMENTE %s', $sMensaje, $sQuery));
                $this->GrabaDebug(sprintf('ERROR EN grabarRespuestaPac33... [ %s ] ... NO SE EJECUTO CORRECTAMENTE %s', $sMensaje, $sQuery));
            } else {
                $sMensaje = $ex->getMessage();
                $this->GrabaLog(sprintf('ERROR EN grabarRespuestaPac33... [ %s ]', $sMensaje));
                $this->GrabaDebug(sprintf('ERROR EN grabarRespuestaPac33... [ %s ]', $sMensaje));
            }
        }
        $this->GrabaDebug(sprintf('GRABAR RESPUESTA  PAC [ %s ]', $sMensaje));
        //if($iEstado == 2)
            //$sMensaje = 'Error interno del sistema.';
        $hResponse->estado = $iEstado;
        $hResponse->mensaje = $sMensaje;
        return $hResponse;
    }

    function grabarComprobanteNomina($sEmpleado, $sFecNomina, $sRfcEmpleado, $sUuid, $sClvEstatus, $sNumEmpresa, $sNumSemana, $sClvTipoTimbrado, $sNumObra, $sNumControl, $sNumIdentKey, $sConexionNomina) {
        $hResponse = new stdClass();
        $iEstado = 1; 
        $sMensaje = 'Error al guardar en tabla ctl_comprobantesnominafiscal.';
        $bExito = '0';
        try {
            $GLOBALS['ODBC_CONNECTIONSTRING']['NOMINA'] = $sConexionNomina;
            $this->GrabaDebug(sprintf('Conexion Nomina... [ %s ]', $GLOBALS['ODBC_CONNECTIONSTRING']['NOMINA'])); //VICTOR
            $hCon = $this->activarConexion($GLOBALS['ODBC_CONNECTIONSTRING']['NOMINA']);
            if($hCon == NULL) {
                $sMensaje = 'Error al conectar con la base de datos de la nomina';
            }
            else {
                if($sNumEmpresa == '0') {
                    $hCmd = $hCon->createCommand();
                    $sQuery = sprintf("SELECT fun_almacenacomprobantefiscalnomina02(%s, '%s', '%s', '%s', %s, NOW()::DATE, %s, %s, %s)", $sEmpleado, $sFecNomina, $sRfcEmpleado, $sUuid, $sClvEstatus, $sClvTipoTimbrado, $sNumControl, $sNumIdentKey);
                    $hCmd->setCommandText($sQuery);
                    $this->GrabaDebug($sQuery); //Victor
                    $bExito = $hCmd->executeNonQuery();
                    
                    if($bExito != '0') {
                        $iEstado = 0;
                        $sMensaje = 'Operacion exitosa';
                    }
                } else {
                    $hCmd = $hCon->createCommand();
                    $sQuery = sprintf("SELECT fun_almacenacomprobantefiscalnominainversa01(%s, '%s', '%s', '%s', %s, NOW()::DATE, %s, %s, %s, %s)", $sEmpleado, $sFecNomina, $sRfcEmpleado, $sUuid, $sClvEstatus, $sNumEmpresa, $sNumSemana, $sClvTipoTimbrado, $sNumObra);
                    $hCmd->setCommandText($sQuery);
                    $this->GrabaDebug($sQuery); //Victor
                    $bExito = $hCmd->executeNonQuery();
                    
                    if($bExito != '0') {
                        $iEstado = 0;
                        $sMensaje = 'Operacion exitosa';
                    }
                }
            }
            $hCon->close();
        }
        catch(exception $ex) {
            $iEstado = 2;
            if( $sQuery != '' ) {
                $sMensaje = $ex->getMessage();
                $this->GrabaLog(sprintf('ERROR EN grabarComprobanteNomina... [ %s ] ... NO SE EJECUTO CORRECTAMENTE %s', $sMensaje, $sQuery));
                $this->GrabaDebug(sprintf('ERROR EN grabarComprobanteNomina... [ %s ] ... NO SE EJECUTO CORRECTAMENTE %s', $sMensaje, $sQuery));
            } else {
                $sMensaje = $ex->getMessage();
                $this->GrabaLog(sprintf('ERROR EN grabarComprobanteNomina... [ %s ]', $sMensaje));
                $this->GrabaDebug(sprintf('ERROR EN grabarComprobanteNomina... [ %s ]', $sMensaje));
            }
        }
        $this->GrabaDebug(sprintf('GRABAR RESPUESTA  PAC [ %s ]', $sMensaje));
        //if($iEstado == 2)
            //$sMensaje = 'Error interno del sistema.';
        $hResponse->estado = $iEstado;
        $hResponse->mensaje = $sMensaje;
        return $hResponse;
    }
    
    function grabarErroresTimbradoNomina($sEmpleado, $sFecNomina, $sNumEmpresa, $sNumObra, $sClvTipoTimbrado, $cError, $iEmpleadoCapturo, $sNumControl, $sNumIdentKey, $sConexionNomina) {
        $hResponse = new stdClass();
        $iEstado = 1; 
        $sMensaje = 'Error al guardar en tabla mov_errorestimbradonomina.';
        $bExito = '0';

        try {
            $cError = str_ireplace("'", "", $cError);
            $GLOBALS['ODBC_CONNECTIONSTRING']['NOMINA'] = $sConexionNomina;
            $this->GrabaDebug(sprintf('Conexion Nomina... [ %s ]', $GLOBALS['ODBC_CONNECTIONSTRING']['NOMINA'])); //VICTOR
            $hCon = $this->activarConexion($GLOBALS['ODBC_CONNECTIONSTRING']['NOMINA']);
            if($hCon == NULL) {
                $sMensaje = 'Error al conectar con la base de datos de la nomina';
            }
            else {
                $hCmd = $hCon->createCommand();
                $sQuery = sprintf("SELECT fun_almacenaerrorestimbradonomina01(%s, '%s', '%s', %s, %s, %s, '%s', %s, %s, %s)", $sEmpleado, $sFecNomina, $sFecNomina, $sNumEmpresa, $sNumObra, $sClvTipoTimbrado, $cError, $iEmpleadoCapturo, $sNumControl, $sNumIdentKey);
                $hCmd->setCommandText($sQuery);
                $this->GrabaDebug($sQuery); //Victor
                $bExito = $hCmd->executeNonQuery();
                
                if($bExito != '0') {
                    $iEstado = 0;
                    $sMensaje = 'Operacion exitosa';
                }
            }
            $hCon->close();
        }
        catch(exception $ex) {
            $iEstado = 2;
            if( $sQuery != '' ) {
                $sMensaje = $ex->getMessage();
                $this->GrabaLog(sprintf('ERROR EN grabarErroresTimbradoNomina... [ %s ] ... NO SE EJECUTO CORRECTAMENTE %s', $sMensaje, $sQuery));
                $this->GrabaDebug(sprintf('ERROR EN grabarErroresTimbradoNomina... [ %s ] ... NO SE EJECUTO CORRECTAMENTE %s', $sMensaje, $sQuery));
            } else {
                $sMensaje = $ex->getMessage();
                $this->GrabaLog(sprintf('ERROR EN grabarErroresTimbradoNomina... [ %s ]', $sMensaje));
                $this->GrabaDebug(sprintf('ERROR EN grabarErroresTimbradoNomina... [ %s ]', $sMensaje));
            }
        }
        $this->GrabaDebug(sprintf('GRABAR ERROR EN NOMINA [ %s ]', $sMensaje));
        //if($iEstado == 2)
			//$sMensaje = 'Error interno del sistema.';
        $hResponse->estado = $iEstado;
        $hResponse->mensaje = $sMensaje;
        return $hResponse;
    }
    
    function grabarAcuseCancelacion($sEmpleado, $sFecNomina, $sUuid, $sAcuseCancelacion, $iNumPACCFDI, $sNumEmpresa, $sNumSemana, $sNumObra, $sEmpleadoCancela, $sClvTipoNomina, $sNumControl, $sNumIdentKey, $sConexionNomina) {
        $hResponse = new stdClass();
        $iEstado = 1; 
        $sMensaje = 'Error al guardar en tabla mov_acuse_cancelacion_timbrado.';
        $bExito = '0';
        try {
            $GLOBALS['ODBC_CONNECTIONSTRING']['NOMINA'] = $sConexionNomina;
            $this->GrabaDebug(sprintf('Conexion Nomina... [ %s ]', $GLOBALS['ODBC_CONNECTIONSTRING']['NOMINA'])); //VICTOR
            $hCon = $this->activarConexion($GLOBALS['ODBC_CONNECTIONSTRING']['NOMINA']);
            if($hCon == NULL) {
                $sMensaje = 'Error al conectar con la base de datos de la nomina';
            }
            else {
                if($sNumEmpresa == '0') {
                    $hCmd = $hCon->createCommand();
                    $sQuery = sprintf("SELECT fun_almacena_acuse_cancelacion_timbrado(%s, '%s'::DATE, '%s', '%s'::text, %s, %s, %s, %s, %s);", $sEmpleado, $sFecNomina, $sUuid, $sAcuseCancelacion, $iNumPACCFDI, $sEmpleadoCancela, $sClvTipoNomina, $sNumControl, $sNumIdentKey);
                    $hCmd->setCommandText($sQuery);
                    $this->GrabaDebug($sQuery); //Victor
                    $bExito = $hCmd->executeNonQuery();

                    if($bExito != '0') {
                        $iEstado = 0;
                        $sMensaje = 'Operacion exitosa';
                    }
					
                }
                else {
                    $hCmd = $hCon->createCommand();
                    $sQuery = sprintf("SELECT fun_almacena_acuse_cancelacion_inversa(%s, '%s'::DATE, '%s', '%s'::text, %s, %s, %s, %s, %s, %s);", $sEmpleado, $sFecNomina, $sUuid, $sAcuseCancelacion, $sNumEmpresa, $sNumSemana, $sNumObra, $iNumPACCFDI, $sEmpleadoCancela, $sClvTipoNomina);
                    $hCmd->setCommandText($sQuery);
                    $this->GrabaDebug($sQuery); //Victor
                    $bExito = $hCmd->executeNonQuery();
                    
                    if($bExito != '0') {
                        $iEstado = 0;
                        $sMensaje = 'Operacion exitosa';
                    }
                }
            }
            $hCon->close();
        }
        catch(exception $ex) {
            $iEstado = 2;
            if( $sQuery != '' ) {
                $sMensaje = $ex->getMessage();
                $this->GrabaLog(sprintf('ERROR EN grabarAcuseCancelacion... [ %s ] ... NO SE EJECUTO CORRECTAMENTE %s', $sMensaje, $sQuery));
                $this->GrabaDebug(sprintf('ERROR EN grabarAcuseCancelacion... [ %s ] ... NO SE EJECUTO CORRECTAMENTE %s', $sMensaje, $sQuery));
            } else {
                $sMensaje = $ex->getMessage();
                $this->GrabaLog(sprintf('ERROR EN grabarAcuseCancelacion... [ %s ]', $sMensaje));
                $this->GrabaDebug(sprintf('ERROR EN grabarAcuseCancelacion... [ %s ]', $sMensaje));
            }
        }
        $this->GrabaDebug(sprintf('GRABAR ACUSE [ %s ]', $sMensaje));
        //if($iEstado == 2)
            //$sMensaje = 'Error interno del sistema.';
        $hResponse->estado = $iEstado;
        $hResponse->mensaje = $sMensaje;
        return $hResponse;
    }
}
?>
