<?php
	if(!file_exists('accesodatos/OdbcConnection.php') || !file_exists('accesodatos/CDAMovtoTimbrado.php') || !file_exists('objetonegocio/CComprobante.php') || !file_exists('objetonegocio/CComprobanteSolucionFactible.php') || !file_exists('objetonegocio/CComprobanteDiverza.php') || !file_exists('objetonegocio/CComprobanteDetecno.php') || !file_exists('objetonegocio/CComprobanteSmarterWeb.php') || !file_exists('vendor/autoload.php'))
	throw new Exception('Generación de factura de nómina. Error al procesar la solicitud.', 1);
	require_once 'accesodatos/OdbcConnection.php';
	require_once 'accesodatos/CDAMovtoTimbrado.php';
	require_once 'objetonegocio/CComprobante.php';
	require_once 'objetonegocio/CComprobanteSolucionFactible.php';
	require_once 'objetonegocio/CComprobanteDiverza.php';
	require_once 'objetonegocio/CComprobanteDetecno.php';
    require_once 'objetonegocio/CComprobanteSmarterWeb.php';
		
	class CBOCancelarFacturaElectronicaNomina extends CGenerales {
		private $sUuid;
		private $sEmpleadoCancela;
        private $sRfc;
        private $sEmpleado;
        private $sRfcEmpleado;
        private $sFecNomina;
        private $sNumEmpresa;
        private $sNumSemana;
        private $sNumObra;
        private $sClvTipoTimbrado;
        private $sNumControl;
        private $sNumIdentKey;
        private $sConexionNomina;
        
        private $sXml;
	
		function __construct() {
			$this->sUuid = NULL;
			$this->sEmpleadoCancela = NULL;
            $this->sEmpleado = NULL;
            $this->sRfcEmpleado = NULL;
            $this->sFecNomina = NULL;
            $this->sNumEmpresa = NULL;
            $this->sNumSemana = NULL;
            $this->sNumObra = NULL;
            $this->sClvTipoTimbrado = NULL;
            $this->sNumControl = NULL;
            $this->sNumIdentKey = NULL;
            $this->sConexionNomina = NULL;
            
            $this->sXml = NULL;
		}
	
		function __destruct() {
			$this->sUuid = NULL;
			$this->sEmpleadoCancela = NULL;
            $this->sEmpleado = NULL;
            $this->sRfcEmpleado = NULL;
            $this->sFecNomina = NULL;
            $this->sNumEmpresa = NULL;
            $this->sNumSemana = NULL;
            $this->sNumObra = NULL;
            $this->sClvTipoTimbrado = NULL;
            $this->sNumControl = NULL;
            $this->sNumIdentKey = NULL;
            $this->sConexionNomina = NULL;
            
            $this->sXml = NULL;
		}
	
		function cancelaFactura($sUuid, $sEmpleadoCancela) {
			$sMensajeRespuesta = 'Error interno del sistema';
			$sEstado = '1';
			$bInicia = FALSE;
			try {
				
				$bInicia = TRUE;
				$this->sUuid = $sUuid;
				$this->sEmpleadoCancela = $sEmpleadoCancela;
				
				if($this->esCadenaValida($this->sUuid) && $this->esCadenaValida($this->sEmpleadoCancela)) {
				  	$hMovtoTimbrado = new CDAMovtoTimbrado();
					$hResponse = $hMovtoTimbrado->grabarMovtoCancelacionPre($this->sUuid, $this->sEmpleadoCancela);
					if($hResponse->estado != 0) {
						$sMensajeRespuesta = $hResponse->mensaje;
					}
					else {
						if($hResponse->configuracionWS->num_paccfdi == $GLOBALS['PAC_TIMBRADO_SOLUCIONFACTIBLE']) {
							$hComprobanteCFDI = new CComprobanteSolucionFactible();
							$idu_folio = $hResponse->configuracionWS->idu_folio;
							$hResponse = $hComprobanteCFDI->cancelar($hResponse->configuracionWS, $this->sUuid);
							if($hResponse->estado != 0) {
								$sMensajeRespuesta = $hResponse->mensaje;
							}
							else {
								$hResponse = $hMovtoTimbrado->grabarMovtoCancelacion($idu_folio, $hResponse->respuestaPac);
								if($hResponse->estado != 0) {
									$sMensajeRespuesta = sprintf('Se canceló el UUID %s sin embargo no se pudo registrar la cancelación en la base de datos. Favor de informar a sistemas.', $this->sUuid);
								}
								else {
									$sEstado = 0;
									$sMensajeRespuesta = 'OK';
								}
							}
						}
						else if($hResponse->configuracionWS->num_paccfdi == $GLOBALS['PAC_TIMBRADO_DIVERZA']) {
							$hComprobanteCFDI = new CComprobanteDiverza();
							
							$idu_folio = $hResponse->configuracionWS->idu_folio;
							$hResponse = $hComprobanteCFDI->cancelar($hResponse->configuracionWS, $this->sUuid);
							if($hResponse->estado != 0) {
								$sMensajeRespuesta = $hResponse->mensaje;
							}
							else {
								$hResponse = $hMovtoTimbrado->grabarMovtoCancelacion($idu_folio, $hResponse->respuestaPac);
								if($hResponse->estado != 0) {
									$sMensajeRespuesta = sprintf('Se canceló el UUID %s sin embargo no se pudo registrar la cancelación en la base de datos. Favor de informar a sistemas.', $this->sUuid);
								}
								else {
									$sEstado = 0;
									$sMensajeRespuesta = 'OK';
								}
							}
						}
						else if($hResponse->configuracionWS->num_paccfdi == $GLOBALS['PAC_TIMBRADO_DETECNO']) {
							$hComprobanteCFDI = new CComprobanteDetecno();
							$idu_folio = $hResponse->configuracionWS->idu_folio;
							$hResponse = $hComprobanteCFDI->cancelar($hResponse->configuracionWS, $this->sUuid);
							if($hResponse->estado != 0) {
								$sMensajeRespuesta = $hResponse->mensaje;
							}
							else {
								$hResponse = $hMovtoTimbrado->grabarMovtoCancelacion($idu_folio, $hResponse->respuestaPac);
								if($hResponse->estado != 0) {
									$sMensajeRespuesta = sprintf('Se canceló el UUID %s sin embargo no se pudo registrar la cancelación en la base de datos. Favor de informar a sistemas.', $this->sUuid);
								}
								else {
									$sEstado = 0;
									$sMensajeRespuesta = 'OK';
								}
							}
						}
						else {
							$sMensajeRespuesta = 'Error al cancelar UUID, proveedor invalido'; 
						}
					}
				}
				else {
					$sMensajeRespuesta = "Uno o mas de los parametros recibidos es invalido";
				}
			}
			catch(exception $ex) {
				$sEstadoRespuesta = "1";
				$sMensajeRespuesta = $ex->getMessage();
				if($bInicia) {
					$this->GrabaLog(sprintf("ERROR EN CANCELACION DE FACTURA... [ Numemp %s - UUID %s - %s ]", $sEmpleado, $sUuid, $sMensajeRespuesta));
					}
			}
			return '<?xml version="1.0" encoding="UTF-8"?><respuesta><estado>' . $sEstado . 
			'</estado><mensaje>' . $sMensajeRespuesta . '</mensaje></respuesta>';
		}
	
		function cancelaFacturaTimbre($sUuid, $sEmpleadoCancela, $sNumEmpresa, $sEmpleado, $sRfcEmpleado, $sFecNomina, $sNumSemana, $sNumObra, $sClvTipoTimbrado, $sNumControl, $sNumIdentKey, $sConexionNomina ) {
			$sMensajeRespuesta = 'Error interno del sistema';
            $sMensajeError = "";
            $iPACCfdi = 0;
			$sEstado = 1;
			$bInicia = FALSE;
            $hRespuestaError = NULL;

            $GLOBALS['NUM_EMPLEADO'] = $sEmpleado;

            try {
				$bInicia = TRUE;
				$this->sUuid = $sUuid;
				$this->sEmpleadoCancela = $sEmpleadoCancela;
                $this->sNumEmpresa = $sNumEmpresa;
                $this->sEmpleado = $sEmpleado;
                $this->sRfcEmpleado = $sRfcEmpleado;
                $this->sFecNomina = $sFecNomina;
                $this->sNumSemana = $sNumSemana;
                $this->sNumObra = $sNumObra;
                $this->sClvTipoTimbrado = $sClvTipoTimbrado;
                $this->sNumControl = $sNumControl;
                $this->sNumIdentKey = $sNumIdentKey;
                $this->sConexionNomina = $sConexionNomina;
                
                $this->GrabaDebug("INICIA METODO WEB CANCELARFACTURAELECTRONICANOMINA");
                $this->GrabaDebug("PARAMETROS RECIBIDOS");
                $this->GrabaDebug(sprintf("sUuid............ [ %s ]", $this->sUuid));
                $this->GrabaDebug(sprintf("sEmpleadoCancela. [ %s ]", $this->sEmpleadoCancela));
                $this->GrabaDebug(sprintf("sNumEmpresa...... [ %s ]", $this->sNumEmpresa));
                $this->GrabaDebug(sprintf("sEmpleado........ [ %s ]", $this->sEmpleado));
                $this->GrabaDebug(sprintf("sRfcEmpleado..... [ %s ]", $this->sRfcEmpleado));
                $this->GrabaDebug(sprintf("sFecNomina....... [ %s ]", $this->sFecNomina));
                $this->GrabaDebug(sprintf("sNumSemana....... [ %s ]", $this->sNumSemana));
                $this->GrabaDebug(sprintf("sNumObra......... [ %s ]", $this->sNumObra));
                $this->GrabaDebug(sprintf("sClvTipoTimbrado. [ %s ]", $this->sClvTipoTimbrado));
                $this->GrabaDebug(sprintf("sNumControl...... [ %s ]", $this->sNumControl));
                $this->GrabaDebug(sprintf("sNumIdentKey..... [ %s ]", $this->sNumIdentKey));
                $this->GrabaDebug(sprintf("sConexionNomina.. [ %s ]", $this->sConexionNomina));
              
				if($this->esCadenaValida($this->sUuid) && $this->esCadenaValida($this->sEmpleadoCancela)) 
				{
				  	$hMovtoTimbrado = new CDAMovtoTimbrado();
					$hResponse = $hMovtoTimbrado->grabarMovtoCancelacionPre($this->sUuid, $this->sEmpleadoCancela);
					
					if($hResponse->estado != 0) {
						$sMensajeRespuesta = $hResponse->mensaje;
					}
					else {
                        $iPACCfdi = $hResponse->configuracionWS->num_paccfdi;
						if($iPACCfdi == $GLOBALS['PAC_TIMBRADO_SOLUCIONFACTIBLE']) {
							$hComprobanteCFDI = new CComprobanteSolucionFactible();
							$idu_folio = $hResponse->configuracionWS->idu_folio;
                            $hResponse = $hComprobanteCFDI->cancelar($hResponse->configuracionWS, $this->sUuid);
                            if($hResponse->estado != 0) {
                                $sMensajeRespuesta = $hResponse->mensaje;
                            }
                            else {
                                if($hResponse->EstatusUUID == 201 || $hResponse->EstatusUUID == 202) {
                                    $sAcuseCancelacion = $hResponse->AcuseCanc;
                                    $hResponse = $hMovtoTimbrado->grabarMovtoCancelacion($idu_folio, $hResponse->respuestaPac);

                                    if($hResponse->estado != 0) {
                                        $sMensajeRespuesta = sprintf('Se canceló el UUID %s sin embargo no se pudo registrar la cancelación en la base de datos. Favor de informar a sistemas.', $this->sUuid);
                                    }
                                    else {
                                        $sEstado = 0;
                                        $sMensajeRespuesta = 'OK';
                                        
                                        $hResponse = $hMovtoTimbrado->grabarComprobanteNomina($this->sEmpleado, $this->sFecNomina, $this->sRfcEmpleado, $sUuid, 1, $this->sNumEmpresa, $this->sNumSemana, $this->sClvTipoTimbrado, $this->sNumObra, $this->sNumControl, $this->sNumIdentKey, $this->sConexionNomina);
                                        $sMensajeRespuesta = $hResponse->mensaje;
                                        if($hResponse->estado != 0) {
                                            $hRespuestaError = $hMovtoTimbrado->grabarErroresTimbradoNomina($sEmpleado, $sFecNomina, $sNumEmpresa, $sNumObra, $sClvTipoTimbrado, $sMensajeRespuesta, $sEmpleadoCancela, $sNumControl, $sNumIdentKey, $sConexionNomina);
                                            $sMensajeError = $hRespuestaError->mensaje;
                                            if($hRespuestaError->estado != 0) {
                                                $this->GrabaLog(sprintf("ERROR AL GRABAR ERRORES... [ Numemp %s - %s ]", $sEmpleado, $sMensajeError));
                                            }
                                        }
                                        else {
                                            $sAcuseCancelacion = str_ireplace("'", "\'", $sAcuseCancelacion);
                                            $hResponse = $hMovtoTimbrado->grabarAcuseCancelacion($this->sEmpleado, $this->sFecNomina, $this->sUuid, $sAcuseCancelacion, $iPACCfdi, $this->sNumEmpresa, $this->sNumSemana, $this->sNumObra, $this->sEmpleadoCancela, $this->sClvTipoTimbrado, $this->sNumControl, $this->sNumIdentKey, $this->sConexionNomina);
                                            $sMensajeRespuesta = $hResponse->mensaje;
                                            if($hResponse->estado != 0) {
                                                $hRespuestaError = $hMovtoTimbrado->grabarErroresTimbradoNomina($this->sEmpleado, $sFecNomina, $sNumEmpresa, $sNumObra, $sClvTipoTimbrado, $sMensajeRespuesta, $sEmpleadoCancela, $sNumControl, $sNumIdentKey, $sConexionNomina);
                                                $sMensajeError = $hRespuestaError->mensaje;
                                                if($hRespuestaError->estado != 0) {
                                                    $this->GrabaLog(sprintf("ERROR AL GRABAR ERRORES... [ Numemp %s - %s ]", $sEmpleado, $sMensajeError));
                                                }
                                            }
                                        }
                                    }
                                }
                                else {
                                    $sMensajeRespuesta = 'Error al cancelar UUID, EstatusUUID diferente a 201 y 202, sólo se puede tener certeza de que un CFDI fue cancelado cuando el EstatusUUID es 201 (Se ha cancelado el CFDI) o 202 (El CFDI ya había sido cancelado previamente).'; 
                                }
                            }

						}
						else if($iPACCfdi == $GLOBALS['PAC_TIMBRADO_DIVERZA']) {
							$hComprobanteCFDI = new CComprobanteDiverza();
							
							$idu_folio = $hResponse->configuracionWS->idu_folio;
							$hResponse = $hComprobanteCFDI->cancelar($hResponse->configuracionWS, $this->sUuid);
							if($hResponse->estado != 0) {
								$sMensajeRespuesta = $hResponse->mensaje;
							}
							else {
								$hResponse = $hMovtoTimbrado->grabarMovtoCancelacion($idu_folio, $hResponse->respuestaPac);
								if($hResponse->estado != 0) {
									$sMensajeRespuesta = sprintf('Se canceló el UUID %s sin embargo no se pudo registrar la cancelación en la base de datos. Favor de informar a sistemas.', $this->sUuid);
								}
								else {
									$sEstado = 0;
									$sMensajeRespuesta = 'OK';
                                    
                                    $hResponse = $hMovtoTimbrado->grabarComprobanteNomina($this->sEmpleado, $this->sFecNomina, $this->sRfcEmpleado, $sUuid, 1, $this->sNumEmpresa, $this->sNumSemana, $this->sClvTipoTimbrado, $this->sNumObra, $this->sNumControl, $this->sNumIdentKey, $this->sConexionNomina);
                                    $sMensajeRespuesta = $hResponse->mensaje;
                                    if($hResponse->estado != 0) {
                                        $hRespuestaError = $hMovtoTimbrado->grabarErroresTimbradoNomina($sEmpleado, $sFecNomina, $sNumEmpresa, $sNumObra, $sClvTipoTimbrado, $sMensajeRespuesta, $sEmpleadoCancela, $sNumControl, $sNumIdentKey, $sConexionNomina);
                                        $sMensajeError = $hRespuestaError->mensaje;
                                        if($hRespuestaError->estado != 0) {
                                            $this->GrabaLog(sprintf("ERROR AL GRABAR ERRORES... [ Numemp %s - %s ]", $sEmpleado, $sMensajeError));
                                        }
                                    }
								}
							}
						}
						else if($iPACCfdi == $GLOBALS['PAC_TIMBRADO_DETECNO']) {
							$hComprobanteCFDI = new CComprobanteDetecno();
							$idu_folio = $hResponse->configuracionWS->idu_folio;
							$hResponse = $hComprobanteCFDI->cancelar($hResponse->configuracionWS, $this->sUuid);
							if($hResponse->estado != 0) {
								$sMensajeRespuesta = $hResponse->mensaje;
							}
							else {
								$hResponse = $hMovtoTimbrado->grabarMovtoCancelacion($idu_folio, $hResponse->respuestaPac);
								if($hResponse->estado != 0) {
									$sMensajeRespuesta = sprintf('Se canceló el UUID %s sin embargo no se pudo registrar la cancelación en la base de datos. Favor de informar a sistemas.', $this->sUuid);
								}
								else {
									$sEstado = 0;
									$sMensajeRespuesta = 'OK';
                                    
                                    $hResponse = $hMovtoTimbrado->grabarComprobanteNomina($this->sEmpleado, $this->sFecNomina, $this->sRfcEmpleado, $sUuid, 1, $this->sNumEmpresa, $this->sNumSemana, $this->sClvTipoTimbrado, $this->sNumObra, $this->sNumControl, $this->sNumIdentKey, $this->sConexionNomina);
                                    $sMensajeRespuesta = $hResponse->mensaje;
                                    if($hResponse->estado != 0) {
                                        $hRespuestaError = $hMovtoTimbrado->grabarErroresTimbradoNomina($sEmpleado, $sFecNomina, $sNumEmpresa, $sNumObra, $sClvTipoTimbrado, $sMensajeRespuesta, $sEmpleadoCancela, $sNumControl, $sNumIdentKey, $sConexionNomina);
                                        $sMensajeError = $hRespuestaError->mensaje;
                                        if($hRespuestaError->estado != 0) {
                                            $this->GrabaLog(sprintf("ERROR AL GRABAR ERRORES... [ Numemp %s - %s ]", $sEmpleado, $sMensajeError));
                                        }
                                    }
								}
							}
						}
                        else if($iPACCfdi == $GLOBALS['PAC_TIMBRADO_SMARTERWEB']) {
                           $hComprobanteCFDI = new CComprobanteSmarterWeb();

							$idu_folio = $hResponse->configuracionWS->idu_folio;
                            $hResponse = $hComprobanteCFDI->cancelar($hResponse->configuracionWS, $this->sUuid);
                            if($hResponse->estado != 0) {
                                $sMensajeRespuesta = $hResponse->mensaje;
                            }
                            else {
                                if($hResponse->EstatusUUID == 201 || $hResponse->EstatusUUID == 202) {
                                    $sAcuseCancelacion = $hResponse->AcuseCanc;
                                    $hResponse = $hMovtoTimbrado->grabarMovtoCancelacion($idu_folio, $hResponse->respuestaPac);

                                    if($hResponse->estado != 0) {
                                        $sMensajeRespuesta = sprintf('Se canceló el UUID %s sin embargo no se pudo registrar la cancelación en la base de datos. Favor de informar a sistemas.', $this->sUuid);
                                    }
                                    else {
                                        $sEstado = 0;
                                        $sMensajeRespuesta = 'OK';
                                        
                                        $hResponse = $hMovtoTimbrado->grabarComprobanteNomina($this->sEmpleado, $this->sFecNomina, $this->sRfcEmpleado, $sUuid, 1, $this->sNumEmpresa, $this->sNumSemana, $this->sClvTipoTimbrado, $this->sNumObra, $this->sNumControl, $this->sNumIdentKey, $this->sConexionNomina);
                                        $sMensajeRespuesta = $hResponse->mensaje;
                                        if($hResponse->estado != 0) {
                                            $hRespuestaError = $hMovtoTimbrado->grabarErroresTimbradoNomina($sEmpleado, $sFecNomina, $sNumEmpresa, $sNumObra, $sClvTipoTimbrado, $sMensajeRespuesta, $sEmpleadoCancela, $sNumControl, $sNumIdentKey, $sConexionNomina);
                                            $sMensajeError = $hRespuestaError->mensaje;
                                            if($hRespuestaError->estado != 0) {
                                                $this->GrabaLog(sprintf("ERROR AL GRABAR ERRORES... [ Numemp %s - %s ]", $sEmpleado, $sMensajeError));
                                            }
                                        }
                                        else {
                                              $sAcuseCancelacion = str_ireplace("'", "\"", $sAcuseCancelacion);
                                            $hResponse = $hMovtoTimbrado->grabarAcuseCancelacion($this->sEmpleado, $this->sFecNomina, $this->sUuid, $sAcuseCancelacion, $iPACCfdi, $this->sNumEmpresa, $this->sNumSemana, $this->sNumObra, $this->sEmpleadoCancela, $this->sClvTipoTimbrado, $this->sNumControl, $this->sNumIdentKey, $this->sConexionNomina);
                                            $sMensajeRespuesta = $hResponse->mensaje;
                                            if($hResponse->estado != 0) {
                                                $hRespuestaError = $hMovtoTimbrado->grabarErroresTimbradoNomina($this->sEmpleado, $sFecNomina, $sNumEmpresa, $sNumObra, $sClvTipoTimbrado, $sMensajeRespuesta, $sEmpleadoCancela, $sNumControl, $sNumIdentKey, $sConexionNomina);
                                                $sMensajeError = $hRespuestaError->mensaje;
                                                if($hRespuestaError->estado != 0) {
                                                    $this->GrabaLog(sprintf("ERROR AL GRABAR ERRORES... [ Numemp %s - %s ]", $sEmpleado, $sMensajeError));
                                                }
                                            }
                                        }
                                    }
                                }
                            }
							
                        }
						else {
							$sMensajeRespuesta = 'Error al cancelar UUID, proveedor invalido'; 
						}
					}
				}
				else {
					$sMensajeRespuesta = "Uno o mas de los parametros recibidos es invalido";
				}
			}
			catch(exception $ex) {
				$sEstado = 1;
				$sMensajeRespuesta = $ex->getMessage();
				if($bInicia) {
                    $this->GrabaLog(sprintf("ERROR EN CANCELACION DE FACTURA... [ Numemp %s - UUID %s - %s ]", $sEmpleado, $sUuid, $sMensajeRespuesta));
                }
			}
            
            if($sEstado != 0) {
                $this->GrabaDebug(sprintf("ERROR EN CANCELACION DE FACTURA... [ Numemp %s - UUID %s - %s ]", $sEmpleado, $sUuid, $sMensajeRespuesta));
                $hMovtoTimbrado2 = new CDAMovtoTimbrado();
                // //$hResponse = $hMovtoTimbrado->grabarMovtoPre($this->sXml, $this->sRfc, $this->sEmpleado, $this->sFecNomina, $this->sEmpleadoGenera);
                $hRespuestaError = $hMovtoTimbrado2->grabarErroresTimbradoNomina($sEmpleado, $sFecNomina, $sNumEmpresa, $sNumObra, $sClvTipoTimbrado, $sMensajeRespuesta, $sEmpleadoCancela, $sNumControl, $sNumIdentKey, $sConexionNomina);
                $sMensajeError = $hRespuestaError->mensaje;
                if($hRespuestaError->estado != 0) {
                    $this->GrabaLog(sprintf("ERROR AL GRABAR ERRORES... [ Numemp %s - %s ]", $sEmpleado, $sMensajeError));
                }
            }
            
			return '<?xml version="1.0" encoding="UTF-8"?><respuesta><estado>' . $sEstado . 
			'</estado><mensaje>' . $sMensajeRespuesta . '</mensaje></respuesta>';
		}
        
        function cancelaFacturaConXML( $sUUID, $sEmpleadoCancela, $sNumEmpresa, $sEmpleado, $sRfcEmpleado, $sFecNomina, $sNumSemana, $sNumObra, $sClvTipoTimbrado, $sNumControl, $sNumIdentKey, $sConexionNomina, $sXml ) {
            $sMensajeRespuesta = 'Error interno del sistema - cancelaFacturaConXML';
            $sMensajeError = "";
            $iPACCfdi = 0;
            $sEstado = '1';
            $bInicia = FALSE;
            $hRespuestaError = NULL;

            $GLOBALS['NUM_EMPLEADO'] = $sEmpleado;

            try {
                
                $bInicia = TRUE;
                $this->sUuid = $sUUID;
                $this->sEmpleadoCancela = $sEmpleadoCancela;
                $this->sNumEmpresa = $sNumEmpresa;
                $this->sEmpleado = $sEmpleado;
                $this->sRfcEmpleado = $sRfcEmpleado;
                $this->sFecNomina = $sFecNomina;
                $this->sNumSemana = $sNumSemana;
                $this->sNumObra = $sNumObra;
                $this->sClvTipoTimbrado = $sClvTipoTimbrado;
                $this->sNumControl = $sNumControl;
                $this->sNumIdentKey = $sNumIdentKey;
                $this->sConexionNomina = $sConexionNomina;
                $this->sXml = $sXml;
                
                $this->GrabaDebug("INICIA METODO WEB CANCELARFACTURAELECTRONICANOMINA");
                $this->GrabaDebug("PARAMETROS RECIBIDOS");
                $this->GrabaDebug(sprintf("sUuid............ [ %s ]", $this->sUuid));
                $this->GrabaDebug(sprintf("sEmpleadoCancela. [ %s ]", $this->sEmpleadoCancela));
                $this->GrabaDebug(sprintf("sNumEmpresa...... [ %s ]", $this->sNumEmpresa));
                $this->GrabaDebug(sprintf("sEmpleado........ [ %s ]", $this->sEmpleado));
                $this->GrabaDebug(sprintf("sRfcEmpleado..... [ %s ]", $this->sRfcEmpleado));
                $this->GrabaDebug(sprintf("sFecNomina....... [ %s ]", $this->sFecNomina));
                $this->GrabaDebug(sprintf("sNumSemana....... [ %s ]", $this->sNumSemana));
                $this->GrabaDebug(sprintf("sNumObra......... [ %s ]", $this->sNumObra));
                $this->GrabaDebug(sprintf("sClvTipoTimbrado. [ %s ]", $this->sClvTipoTimbrado));
                $this->GrabaDebug(sprintf("sNumControl...... [ %s ]", $this->sNumControl));
                $this->GrabaDebug(sprintf("sNumIdentKey..... [ %s ]", $this->sNumIdentKey));
                $this->GrabaDebug(sprintf("sConexionNomina.. [ %s ]", $this->sConexionNomina));
                $this->GrabaDebug(sprintf("sXml............. [ %s ]", $this->sXml));
                
                if($this->esCadenaValida($this->sXml) && $this->esCadenaValida($this->sEmpleadoCancela)) {
                    $hMovtoTimbrado = new CDAMovtoTimbrado();

                    $hResponse = $hMovtoTimbrado->grabarMovtoCancelacionPre($this->sUuid, $this->sEmpleadoCancela);
                    if($hResponse->estado != 0) {
                        $sMensajeRespuesta = $hResponse->mensaje;
                    }
                    else {
                        $iPACCfdi = $hResponse->configuracionWS->num_paccfdi;
                        if($iPACCfdi == $GLOBALS['PAC_TIMBRADO_DETECNO']) {
                            $hComprobanteCFDI = new CComprobanteDetecno();
                            $idu_folio = $hResponse->configuracionWS->idu_folio;
                            $hResponse = $hComprobanteCFDI->cancelarConXml($hResponse->configuracionWS, $this->sXml, $this->sUuid);
                            if($hResponse->estado != 0) {
                                $sMensajeRespuesta = $hResponse->mensaje;
                            }
                            else {
                                if($hResponse->EstatusUUID == 201 || $hResponse->EstatusUUID == 202) {
                                    $sAcuseCancelacion = $hResponse->AcuseCanc;
                                    $hResponse = $hMovtoTimbrado->grabarMovtoCancelacion($idu_folio, $hResponse->respuestaPac);
                                    if($hResponse->estado != 0) {
                                        $sMensajeRespuesta = sprintf('Se canceló el UUID %s sin embargo no se pudo registrar la cancelación en la base de datos. Favor de informar a sistemas.', $this->sUuid);
                                    }
                                    else {
                                        $sEstado = 0;
                                        $sMensajeRespuesta = 'OK';
                                        
                                        $hResponse = $hMovtoTimbrado->grabarComprobanteNomina($this->sEmpleado, $this->sFecNomina, $this->sRfcEmpleado, $this->sUuid, 1, $this->sNumEmpresa, $this->sNumSemana, $this->sClvTipoTimbrado, $this->sNumObra, $this->sNumControl, $this->sNumIdentKey, $this->sConexionNomina);
                                        $sMensajeRespuesta = $hResponse->mensaje;
                                        if($hResponse->estado != 0) {
                                            $hRespuestaError = $hMovtoTimbrado->grabarErroresTimbradoNomina($this->sEmpleado, $sFecNomina, $sNumEmpresa, $sNumObra, $sClvTipoTimbrado, $sMensajeRespuesta, $sEmpleadoCancela, $sNumControl, $sNumIdentKey, $sConexionNomina);
                                            $sMensajeError = $hRespuestaError->mensaje;
                                            if($hRespuestaError->estado != 0) {
                                                $this->GrabaLog(sprintf("ERROR AL GRABAR ERRORES... [ Numemp %s - %s ]", $sEmpleado, $sMensajeError));
                                            }
                                        }
                                        else {
                                            $sAcuseCancelacion = str_ireplace("'", "\'", $sAcuseCancelacion);
                                            //$sAcuseCancelacion = str_ireplace("'", "", $sAcuseCancelacion);
                                            $hResponse = $hMovtoTimbrado->grabarAcuseCancelacion($this->sEmpleado, $this->sFecNomina, $this->sUuid, $sAcuseCancelacion, $iPACCfdi, $this->sNumEmpresa, $this->sNumSemana, $this->sNumObra, $this->sEmpleadoCancela, $this->sClvTipoTimbrado, $this->sNumControl, $this->sNumIdentKey, $this->sConexionNomina);
                                            $sMensajeRespuesta = $hResponse->mensaje;
                                            if($hResponse->estado != 0) {
                                                $hRespuestaError = $hMovtoTimbrado->grabarErroresTimbradoNomina($this->sEmpleado, $sFecNomina, $sNumEmpresa, $sNumObra, $sClvTipoTimbrado, $sMensajeRespuesta, $sEmpleadoCancela, $sNumControl, $sNumIdentKey, $sConexionNomina);
                                                $sMensajeError = $hRespuestaError->mensaje;
                                                if($hRespuestaError->estado != 0) {
                                                    $this->GrabaLog(sprintf("ERROR AL GRABAR ERRORES... [ Numemp %s - %s ]", $sEmpleado, $sMensajeError));
                                                }
                                            }
                                        }
                                    }
                                }
                                else {
                                    $sMensajeRespuesta = 'Error al cancelar UUID, EstatusUUID diferente a 201 y 202, sólo se puede tener certeza de que un CFDI fue cancelado cuando el EstatusUUID es 201 (Se ha cancelado el CFDI) o 202 (El CFDI ya había sido cancelado previamente).'; 
                                }
                            }
                        }
                        else {
                            $sMensajeRespuesta = 'Error al cancelar UUID, proveedor invalido'; 
                        }
                    }
                }
                else {
                    $sMensajeRespuesta = "Uno o mas de los parametros recibidos es invalido";
                }
            }
            catch(exception $ex) {
                $sEstadoRespuesta = "1";
                $sMensajeRespuesta = $ex->getMessage();
                if($bInicia) {
                    $this->GrabaLog(sprintf('ERROR EN cancelaFactura... [ %s ]', $sMensajeRespuesta));
                }
            }
            
            if($sEstado != 0) {
                $this->GrabaDebug(sprintf("ERROR EN CANCELACION DE FACTURA... [ Numemp %s - UUID %s - %s ]", $sEmpleado, $sUuid, $sMensajeRespuesta));
                $hMovtoTimbrado2 = new CDAMovtoTimbrado();
                // //$hResponse = $hMovtoTimbrado->grabarMovtoPre($this->sXml, $this->sRfc, $this->sEmpleado, $this->sFecNomina, $this->sEmpleadoGenera);
                $hRespuestaError = $hMovtoTimbrado2->grabarErroresTimbradoNomina($sEmpleado, $sFecNomina, $sNumEmpresa, $sNumObra, $sClvTipoTimbrado, $sMensajeRespuesta, $sEmpleadoCancela, $sNumControl, $sNumIdentKey, $sConexionNomina);
                $sMensajeError = $hRespuestaError->mensaje;
                if($hRespuestaError->estado != 0) {
                    $this->GrabaLog(sprintf("ERROR AL GRABAR ERRORES... [ Numemp %s - %s ]", $sEmpleado, $sMensajeError));
                    $this->GrabaDebug(sprintf("ERROR AL GRABAR ERRORES... [ Numemp %s - %s ]", $sEmpleado, $sMensajeError));
                }
                /*
                $hResponse = $hMovtoTimbrado2->grabarComprobanteNomina($this->sEmpleado, $this->sFecNomina, $this->sRfcEmpleado, $this->sUuid, -1, $this->sNumEmpresa, $this->sNumSemana, $this->sClvTipoTimbrado, $this->sNumObra, $this->sConexionNomina);
                $sMensajeError = $hResponse->mensaje;*/
            }
            
            return '<?xml version="1.0" encoding="UTF-8"?><respuesta><estado>' . $sEstado . 
            '</estado><mensaje>' . $sMensajeRespuesta . '</mensaje></respuesta>';
        }
    
	}
?>
