<?php
	if(!file_exists('accesodatos/OdbcConnection.php') || !file_exists('accesodatos/CDAMovtoTimbrado.php') || !file_exists('objetonegocio/CComprobante.php') || !file_exists('objetonegocio/CComprobanteSolucionFactible.php'))
		throw new Exception('Generación de factura de nómina. Error al procesar la solicitud.', 1);
	require_once 'accesodatos/OdbcConnection.php';
	require_once 'accesodatos/CDAMovtoTimbrado.php';
	require_once 'objetonegocio/CComprobante.php';
	require_once 'objetonegocio/CComprobanteSolucionFactible.php';
	require_once 'objetonegocio/CComprobanteDiverza_cancelacion.php';
	
	class CBOCancelarFacturaElectronicaNomina extends CGenerales {
		private $sUuid;
		private $sEmpleadoCancela;
	
		function __construct() {
			$this->sUuid = NULL;
			$this->sEmpleadoCancela = NULL;
		}
	
		function __destruct() {
			$this->sUuid = NULL;
			$this->sEmpleadoCancela = NULL;
		}
	
		function cancelaFactura($sUuid, $sEmpleadoCancela) {
			$sMensajeRespuesta = 'Error interno del sistema';
			$sEstado = '1';
			$bInicia = FALSE;
			try {
				$this->GrabaLog("INICIA METODO WEB CANCELARFACTURAELECTRONICANOMINA");
				$bInicia = TRUE;
				$this->sUuid = $sUuid;
				$this->sEmpleadoCancela = $sEmpleadoCancela;
				$this->GrabaLog("PARAMETROS RECIBIDOS");
				$this->GrabaLog(sprintf("UUID............... [ %s ]", $this->sUuid));
				$this->GrabaLog(sprintf("EMPLEADO CANCELA... [ %s ]", $this->sEmpleadoCancela));
				if($this->esCadenaValida($this->sUuid) && $this->esCadenaValida($this->sEmpleadoCancela)) {
				  	$hMovtoTimbrado = new CDAMovtoTimbrado();
					$hResponse = $hMovtoTimbrado->grabarMovtoCancelacionPre($this->sUuid, $this->sEmpleadoCancela);
					if($hResponse->estado != 0) {
						$sMensajeRespuesta = $hResponse->mensaje;
					}
					else {
						if($hResponse->configuracionWS->num_paccfdi == $GLOBALS['PAC_TIMBRADO_SOLUCIONFACTIBLE']) {
							$hComprobanteCFDI = new CComprobanteSolucionFactible();
							$idu_folio = $hResponse->configuracionWS->idu_folio;
							$hResponse = $hComprobanteCFDI->cancelar($hResponse->configuracionWS, $this->sUuid);
							if($hResponse->estado != 0) {
								$sMensajeRespuesta = $hResponse->mensaje;
							}
							else {
								$hResponse = $hMovtoTimbrado->grabarMovtoCancelacion($idu_folio, $hResponse->respuestaPac);
								if($hResponse->estado != 0) {
									$sMensajeRespuesta = sprintf('Se canceló el UUID %s sin embargo no se pudo registrar la cancelación en la base de datos. Favor de informar a sistemas.', $this->sUuid);
								}
								else {
									$sEstado = 0;
									$sMensajeRespuesta = 'OK';
								}
							}
						}
						else if($hResponse->configuracionWS->num_paccfdi == $GLOBALS['PAC_TIMBRADO_DIVERZA']) {
							//$hComprobanteCFDI = new CComprobanteSolucionFactible();
							$hComprobanteCFDI = new CComprobanteDiverza();
							
							$idu_folio = $hResponse->configuracionWS->idu_folio;
							$hResponse = $hComprobanteCFDI->cancelar($hResponse->configuracionWS, $this->sUuid);
							if($hResponse->estado != 0) {
								$sMensajeRespuesta = $hResponse->mensaje;
							}
							else {
								$hResponse = $hMovtoTimbrado->grabarMovtoCancelacion($idu_folio, $hResponse->respuestaPac);
								if($hResponse->estado != 0) {
									$sMensajeRespuesta = sprintf('Se canceló el UUID %s sin embargo no se pudo registrar la cancelación en la base de datos. Favor de informar a sistemas.', $this->sUuid);
								}
								else {
									$sEstado = 0;
									$sMensajeRespuesta = 'OK';
								}
							}
						}
						else {
							$sMensajeRespuesta = 'Error al cancelar UUID, proveedor invalido'; 
						}
					}
				}
				else {
					$sMensajeRespuesta = "Uno o mas de los parametros recibidos es invalido";
				}
				$this->GrabaLog(sprintf("CANCELACION DE FACTURA... [ %s ]", $sMensajeRespuesta));
				$this->GrabaLog("TERMINA METODO WEB CANCELARFACTURAELECTRONICANOMINA");
			}
			catch(exception $ex) {
				$sEstadoRespuesta = "1";
				$sMensajeRespuesta = $ex->getMessage();
				if($bInicia) {
					$this->GrabaLog(sprintf("EXCEPCION......... [ %s ]", $sMensajeRespuesta));
					$this->GrabaLog("TERMINA METODO WEB GENERARFACTURAELECTRONICANOMINA");
				}
			}
			return '<?xml version="1.0" encoding="UTF-8"?><respuesta><estado>' . $sEstado . 
			'</estado><mensaje>' . $sMensajeRespuesta . '</mensaje></respuesta>';
		}
	}
?>
