<?php
class CComprobante extends CGenerales {
	function __construct() {
	}

	function __destruct() {
	}

	function agregarCertificadoYSelloDIVERZA($sXml, $sCertificado, $sSello, $noCertificado) {
		$sCertificado = str_replace('-----BEGIN CERTIFICATE-----', '', $sCertificado);
		$sCertificado = str_replace('-----END CERTIFICATE-----', '', $sCertificado);
		$sXml = str_replace('http://www.sat.gob.mx/nomina12 http://www.sat.gob.mx/sitio_internet/cfd/nomina/nomina12.xsd"  ', 'http://www.sat.gob.mx/nomina12 http://www.sat.gob.mx/sitio_internet/cfd/nomina/nomina12.xsd"  certificado="' . $sCertificado . '" noCertificado="'.$noCertificado.'" sello="' . $sSello.'" ', $sXml);
		return $sXml;
	}

	function agregarCertificadoYSelloDIVERZA33($sXml, $sCertificado, $sSello, $noCertificado) {
		$sCertificado = str_replace('-----BEGIN CERTIFICATE-----', '', $sCertificado);
		$sCertificado = str_replace('-----END CERTIFICATE-----', '', $sCertificado);
		$sXml = str_replace('http://www.sat.gob.mx/nomina12 http://www.sat.gob.mx/sitio_internet/cfd/nomina/nomina12.xsd"  ', 'http://www.sat.gob.mx/nomina12 http://www.sat.gob.mx/sitio_internet/cfd/nomina/nomina12.xsd"  Certificado="' . $sCertificado . '" NoCertificado="'.$noCertificado.'" Sello="' . $sSello.'" ', $sXml);
		return $sXml;
	}

	function agregarCertificadoYSelloDetecno($sXml, $sCertificado, $sSello, $noCertificado) {
		$sCertificado = str_replace('-----BEGIN CERTIFICATE-----', '', $sCertificado);
		$sCertificado = str_replace('-----END CERTIFICATE-----', '', $sCertificado);
		$sXml = str_replace('http://www.sat.gob.mx/nomina12 http://www.sat.gob.mx/sitio_internet/cfd/nomina/nomina12.xsd"  ', 'http://www.sat.gob.mx/nomina12 http://www.sat.gob.mx/sitio_internet/cfd/nomina/nomina12.xsd"  certificado="' . $sCertificado . '" noCertificado="'.$noCertificado.'" sello="' . $sSello.'" ', $sXml);
		return $sXml;
	}

	function agregarCertificadoYSelloDetecno33($sXml, $sCertificado, $sSello, $noCertificado) {
		$sCertificado = str_replace('-----BEGIN CERTIFICATE-----', '', $sCertificado);
		$sCertificado = str_replace('-----END CERTIFICATE-----', '', $sCertificado);
		$sXml = str_replace('http://www.sat.gob.mx/nomina12 http://www.sat.gob.mx/sitio_internet/cfd/nomina/nomina12.xsd"  ', 'http://www.sat.gob.mx/nomina12 http://www.sat.gob.mx/sitio_internet/cfd/nomina/nomina12.xsd"  Certificado="' . $sCertificado . '" Sello="' . $sSello.'" ', $sXml);
		return $sXml;
	}
	
	function agregarcfdiNominaDIVERZA($sXml) {
		$sXml = str_replace('xmlns:cfdi="http://www.sat.gob.mx/cfd/3" ', 'xmlns:cfdi="http://www.sat.gob.mx/cfd/3" xmlns:nomina12="http://www.sat.gob.mx/nomina12" ', $sXml);
		return $sXml;
	}

	function agregarcfdiNominaDetecno($sXml) {
		$sXml = str_replace('xmlns:cfdi="http://www.sat.gob.mx/cfd/3" ', 'xmlns:cfdi="http://www.sat.gob.mx/cfd/3" xmlns:nomina12="http://www.sat.gob.mx/nomina12" ', $sXml);
		return $sXml;
	}
		
	function agregarCertificadoYSello($sXml, $sCertificado, $sSello) {
		$sCertificado = str_replace('-----BEGIN CERTIFICATE-----', '', $sCertificado);
		$sCertificado = str_replace('-----END CERTIFICATE-----', '', $sCertificado);
		$sXml = str_replace('formaDePago',  'sello="' . $sSello . '" formaDePago', $sXml);
		$sXml = str_replace('subTotal',  'certificado="' . $sCertificado . '" subTotal', $sXml);
		return $sXml;
	}
		
	function agregarCertificadoYSello33($sXml, $sCertificado, $sSello) {
		$sCertificado = str_replace('-----BEGIN CERTIFICATE-----', '', $sCertificado);
		$sCertificado = str_replace('-----END CERTIFICATE-----', '', $sCertificado);
		$sXml = str_replace('FormaPago',  'Sello="' . $sSello . '" FormaPago', $sXml);
		$sXml = str_replace('SubTotal',  'Certificado="' . $sCertificado . '" SubTotal', $sXml);
		return $sXml;
	}
		
	function agregarCertificadoYSelloSmarterWeb33($sXml, $sCertificado, $sSello) {
		$sCertificado = str_replace('-----BEGIN CERTIFICATE-----', '', $sCertificado);
		$sCertificado = str_replace('-----END CERTIFICATE-----', '', $sCertificado);
		$sXml = str_replace('FormaPago',  'Sello="' . $sSello . '" FormaPago', $sXml);
		$sXml = str_replace('SubTotal',  'Certificado="' . $sCertificado . '" SubTotal', $sXml);
		return $sXml;
	}

	function complementaXML($sXml, $sNodoDomicilio, $sFecha, $sNombreCertificado) {
		$sXml = str_replace('folio', 'version="3.2" serie="HDS" folio', $sXml);
		$sXml = str_replace('formaDePago',  'fecha="' .$sFecha . '" formaDePago', $sXml);
		$sXml = str_replace('subTotal', 'noCertificado="' . $sNombreCertificado . '" subTotal', $sXml);	
		$sXml = str_replace('TipoNomina',  'Version="1.2" TipoNomina', $sXml);		
		return $sXml;
	}

	function complementaXML33($sXml, $sNodoDomicilio, $sFecha, $sNombreCertificado) {
		$sXml = str_replace('Folio', 'Version="3.3" Serie="HDS" Folio', $sXml);
		$sXml = str_replace('FormaPago',  'Fecha="' .$sFecha . '" FormaPago', $sXml);
		$sXml = str_replace('SubTotal', 'NoCertificado="' . $sNombreCertificado . '" SubTotal', $sXml);	
		$sXml = str_replace('TipoNomina',  'Version="1.2" TipoNomina', $sXml);		
		return $sXml;
	}
	
	function complementaXMLDIVERZA($sXml, $sNodoDomicilio, $sFecha, $sNombreCertificado = NULL ) {
		$sXml = str_replace('folio', 'version="3.2" serie="HDS" folio', $sXml);
		$sXml = str_replace('formaDePago',  'fecha="' .$sFecha . '" formaDePago', $sXml);	
		$sXml = str_replace('TipoNomina',  'Version="1.2" TipoNomina', $sXml);	
		return $sXml;
	}
	
	function complementaXMLDIVERZA33($sXml, $sNodoDomicilio, $sFecha, $sNombreCertificado) {
		$sXml = str_replace('Folio', 'Version="3.3" Serie="HDS" Folio', $sXml);
		$sXml = str_replace('FormaPago',  'Fecha="' .$sFecha . '" FormaPago', $sXml);	
		$sXml = str_replace('TipoNomina',  'Version="1.2" TipoNomina', $sXml);	
		return $sXml;
	}

	function complementaXMLDetecno($sXml, $sNodoDomicilio, $sFecha, $sNombreCertificado) {
		$sXml = str_replace('folio', 'version="3.2" serie="HDS" folio', $sXml);
		$sXml = str_replace('formaDePago',  'fecha="' .$sFecha . '" formaDePago', $sXml);	
		$sXml = str_replace('TipoNomina',  'Version="1.2" TipoNomina', $sXml);	
		
		return $sXml;	
	}

	function complementaXMLDetecno33($sXml, $sNodoDomicilio, $sFecha, $sNombreCertificado) {
		$sXml = str_replace('Folio', 'Version="3.3" Serie="HDS" Folio', $sXml);
		$sXml = str_replace('FormaPago',  'Fecha="' .$sFecha . '" FormaPago', $sXml);	
		$sXml = str_replace('SubTotal', 'NoCertificado="' . $sNombreCertificado . '" SubTotal', $sXml);	
		$sXml = str_replace('TipoNomina',  'Version="1.2" TipoNomina', $sXml);	
		
		return $sXml;	
	}

	function complementaXMLSmarterWeb33($sXml, $sNodoDomicilio, $sFecha, $sNombreCertificado) {
		$sXml = str_replace('Folio', 'Version="3.3" Serie="HDS" Folio', $sXml);
		$sXml = str_replace('FormaPago',  'Fecha="' .$sFecha . '" FormaPago', $sXml);
		$sXml = str_replace('SubTotal', 'NoCertificado="' . $sNombreCertificado . '" SubTotal', $sXml);	
		$sXml = str_replace('TipoNomina',  'Version="1.2" TipoNomina', $sXml);		
		return $sXml;
	}
	
	function complementaXMLtimbreFiscal($sXml, $sNodoTimbreFiscal) {
		$sXml = str_replace('</cfdi:Complemento>', $sNodoTimbreFiscal . ' </cfdi:Complemento>', $sXml);
		return $sXml;
	}

	function generaCadenaOriginal($sXML) {
		$sCadenaOriginal = NULL;
		$sMensaje = 'Error interno del sistema.';
		try {
			$proc = new XSLTProcessor;
			$hXmlNomina = new DOMDocument();
			$hXmlCadenaOriginal = new DOMDocument();
			$hXmlCadenaOriginal->load($GLOBALS['WS_XSLTPATH'] . '/cadenaoriginal_3_2.xslt');
			$hXmlNomina->loadXML($sXML);
			$proc->importStyleSheet($hXmlCadenaOriginal);
			$sCadenaOriginal = $proc->transformToXML($hXmlNomina);			
			$proc = NULL;
			$hXmlCadenaOriginal = NULL;
			$hXmlNomina = NULL;
			$sMensaje = 'OK';
				
		}
		catch(exception $ex) {
			$sMensaje = $ex->getMessage();
			$this->GrabaLog(sprintf("ERROR EN generaCadenaOriginal... [ %s ]", $sMensajeRespuesta." XML ".$sXML));
			$sCadenaOriginal = NULL;
		}
		$this->GrabaDebug(sprintf("GENERACION DE CADENA ORIGINAL... [ %s ]",$sCadenaOriginal ));
		return $sCadenaOriginal;
	}

	function generaCadenaOriginal33($sXML) {
		$sCadenaOriginal = NULL;
		$sMensaje = 'Error interno del sistema.';
		try {
			$proc = new XSLTProcessor;
			$hXmlNomina = new DOMDocument();
			$hXmlCadenaOriginal = new DOMDocument();
			$hXmlCadenaOriginal->load($GLOBALS['WS_XSLTPATH'] . '/cadenaoriginal_3_3.xslt');
			$hXmlNomina->loadXML($sXML);
			$proc->importStyleSheet($hXmlCadenaOriginal);
			$sCadenaOriginal = $proc->transformToXML($hXmlNomina);			
			$proc = NULL;
			$hXmlCadenaOriginal = NULL;
			$hXmlNomina = NULL;
			$sMensaje = 'OK';
				
		}
		catch(exception $ex) {
			$sMensaje = $ex->getMessage();
			$this->GrabaLog(sprintf("ERROR EN generaCadenaOriginal... [ %s ]", $sMensajeRespuesta." XML ".$sXML));
			$sCadenaOriginal = NULL;
		}
		$this->GrabaDebug(sprintf("GENERACION DE CADENA ORIGINAL... [ %s ]", utf8_decode($sCadenaOriginal) ));
		return $sCadenaOriginal;
	}

	function generaCadenaOriginaltimbreFiscal($sXML) {
		$sCadenaOriginal = NULL;
		$sMensaje = 'Error interno del sistema.';
		try {
			$proc = new XSLTProcessor;
			$hXmlNomina = new DOMDocument();
			$hXmlCadenaOriginal = new DOMDocument();
			$hXmlCadenaOriginal->load($GLOBALS['WS_XSLTPATH'] . '/cadenaoriginal_TFD_1_0.xslt');
			$hXmlNomina->loadXML($sXML);
			$proc->importStyleSheet($hXmlCadenaOriginal);
			$sCadenaOriginal = $proc->transformToXML($hXmlNomina);
			$proc = NULL;
			$hXmlCadenaOriginal = NULL;
			$hXmlNomina = NULL;
			$sMensaje = 'OK';
			//$this->GrabaLog(sprintf("CADENA ORIGINAL... [ %s ]", $sCadenaOriginal));
		}
		catch(exception $ex) {
			$sMensaje = $ex->getMessage();
			$sCadenaOriginal = NULL;
			$this->GrabaLog(sprintf("generaCadenaOriginaltimbreFiscal... [ %s ]", $sMensaje." XML ".$sXML));
		}
		//$this->GrabaLog(sprintf("GENERACION DE CADENA ORIGINAL... [ %s ]", $sMensaje));
		return $sCadenaOriginal;
	}

	function generaNodoTimbreFiscal($hTimbreFiscal) {
		$sNodo = sprintf('<tfd:TimbreFiscalDigital xmlns:tfd="http://www.sat.gob.mx/TimbreFiscalDigital" xsi:schemaLocation="http://www.sat.gob.mx/TimbreFiscalDigital http://www.sat.gob.mx/TimbreFiscalDigital/TimbreFiscalDigital.xsd" selloCFD="%s" FechaTimbrado="%s" UUID="%s" noCertificadoSAT="%s" version="%s" selloSAT="%s" />', 
		$hTimbreFiscal->selloCFD, $hTimbreFiscal->fechatimbrado, $hTimbreFiscal->uuid, $hTimbreFiscal->certificadoSAT, $hTimbreFiscal->versionTFD, $hTimbreFiscal->selloSAT);
		return $sNodo;
	}
	
	/********************************************************************/
	function AgregaURLFiscal($sXml) {
		//xmlns:cfdi="http://www.sat.gob.mx/cfd/3"
		
		
		
		$sNodo=str_replace('xmlns:cfdi="http://www.sat.gob.mx/cfd/3"','xmlns:cfdi="http://www.sat.gob.mx/cfd/3" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://www.sat.gob.mx/cfd/3 http://www.sat.gob.mx/sitio_internet/cfd/3/cfdv32.xsd http://www.sat.gob.mx/TimbreFiscalDigital http://www.sat.gob.mx/TimbreFiscalDigital/TimbreFiscalDigital.xsd http://www.sat.gob.mx/nomina12 http://www.sat.gob.mx/sitio_internet/cfd/nomina/nomina12.xsd" ',$sXml);
		//$fec_cargoropa=str_replace("/","",$fec_cargoropa_aux);
		
		//$sNodo = sprintf($sXml,'<tfd:TimbreFiscalDigital xmlns:tfd="http://www.sat.gob.mx/TimbreFiscalDigital" xsi:schemaLocation="http://www.sat.gob.mx/TimbreFiscalDigital http://www.sat.gob.mx/TimbreFiscalDigital/TimbreFiscalDigital.xsd"/>');
		return $sNodo;
	}
	/********************************************************************/
	
	function generaSello($sLlave, $sCadenaOriginal) {
		$sSello = NULL;
		$sMensaje = 'Error interno del sistema.';
		try {
			//$sSello=$sLlave;
			$pkeyid = openssl_get_privatekey($sLlave);
			openssl_sign($sCadenaOriginal, $crypttext, $pkeyid, OPENSSL_ALGO_SHA1);
			openssl_free_key($pkeyid);
			$sSello = base64_encode($crypttext);
			$sMensaje = 'OK';
			//$this->GrabaLog(sprintf("SELLO... [ %s ]", $sSello));
		}
		catch(exception $ex) {
			$sMensaje = $ex->getMessage();
			$sSello = NULL;
			$this->GrabaLog(sprintf("ERROR EN generaSello... [ %s ]", $sMensaje));
		}
		//$this->GrabaLog(sprintf("GENERACION DE SELLO... [ %s ]", $sMensaje));
		return $sSello;
	}
	
	function generaSello33($sLlave, $sCadenaOriginal) {
		$sSello = NULL;
		$sMensaje = 'Error interno del sistema.';
		try {
			//$sSello=$sLlave;
			$pkeyid = openssl_get_privatekey($sLlave);
			openssl_sign($sCadenaOriginal, $crypttext, $pkeyid, "sha256WithRSAEncryption");
			openssl_free_key($pkeyid);
			$sSello = base64_encode($crypttext);
			$sMensaje = 'OK';
			//$this->GrabaLog(sprintf("SELLO... [ %s ]", $sSello));
		}
		catch(exception $ex) {
			$sMensaje = $ex->getMessage();
			$sSello = NULL;
			$this->GrabaLog(sprintf("ERROR EN generaSello... [ %s ]", $sMensaje));
		}
		//$this->GrabaLog(sprintf("GENERACION DE SELLO... [ %s ]", $sMensaje));
		return $sSello;
	}
	
	function generaSelloDiverza($sLlave, $sCadenaOriginal) {
		$sSello = NULL;
		
		$sMensaje = 'Error interno del sistema.';
		try {
			//$sSello=$sLlave;
			$pkeyid = openssl_get_privatekey($sLlave);
			openssl_sign($sCadenaOriginal, $crypttext, $pkeyid, OPENSSL_ALGO_SHA1);
			openssl_free_key($pkeyid);
			$sSello = base64_encode($crypttext);
			$sMensaje = 'OK';
			//$this->GrabaLog(sprintf("SELLO... [ %s ]", $sSello));
		}
		catch(exception $ex) {
			$sMensaje = $ex->getMessage();
			$sSello = NULL;
			$this->GrabaLog(sprintf("ERROR EN generaSelloDiverza... [ %s ]", $sSello));
		}
		//$this->GrabaLog(sprintf("GENERACION DE SELLO... [ %s ]", $sMensaje));
		return $sSello;
	}
	
	function generaSelloDiverza33($sLlave, $sCadenaOriginal) {
		$sSello = NULL;
		
		$sMensaje = 'Error interno del sistema.';
		try {
			//$sSello=$sLlave;
			$pkeyid = openssl_get_privatekey($sLlave);
			openssl_sign($sCadenaOriginal, $crypttext, $pkeyid, "sha256WithRSAEncryption");
			openssl_free_key($pkeyid);
			$sSello = base64_encode($crypttext);
			$sMensaje = 'OK';
			//$this->GrabaLog(sprintf("SELLO... [ %s ]", $sSello));
		}
		catch(exception $ex) {
			$sMensaje = $ex->getMessage();
			$sSello = NULL;
			$this->GrabaLog(sprintf("ERROR EN generaSelloDiverza... [ %s ]", $sSello));
		}
		//$this->GrabaLog(sprintf("GENERACION DE SELLO... [ %s ]", $sMensaje));
		return $sSello;
	}

	function generaSelloDetecno($sLlave, $sCadenaOriginal) {
		$sSello = NULL;
		
		$sMensaje = 'Error interno del sistema.';
		try {
			//$sSello=$sLlave;
			$pkeyid = openssl_get_privatekey($sLlave);
			openssl_sign($sCadenaOriginal, $crypttext, $pkeyid, OPENSSL_ALGO_SHA1);
			openssl_free_key($pkeyid);
			$sSello = base64_encode($crypttext);
			$sMensaje = 'OK';
			//$this->GrabaLog(sprintf("SELLO... [ %s ]", $sSello));
		}
		catch(exception $ex) {
			$sMensaje = $ex->getMessage();
			$sSello = NULL;
			$this->GrabaLog(sprintf("ERROR EN generaSelloDetecno... [ %s ]", $sSello));
		}
		//$this->GrabaLog(sprintf("GENERACION DE SELLO... [ %s ]", $sMensaje));
		return $sSello;
	}

	function generaSelloDetecno33($sLlave, $sCadenaOriginal) {
		$sSello = NULL;
		
		$sMensaje = 'Error interno del sistema.';
		
		try {
			//$sSello=$sLlave;
			$pkeyid = openssl_get_privatekey($sLlave);
			openssl_sign($sCadenaOriginal, $crypttext, $pkeyid, "sha256WithRSAEncryption");
			openssl_free_key($pkeyid);
			$sSello = base64_encode($crypttext);
			$this->GrabaDebug(sprintf("Generacion de sello Detecno... [ %s ]", $sSello));
			$sMensaje = 'OK';
		}
		catch(exception $ex) {
			$sMensaje = $ex->getMessage();
			$sSello = NULL;
			$this->GrabaLog(sprintf("ERROR EN generaSelloDetecno... [ %s ]", $sSello));
		}
		$this->GrabaDebug(sprintf("GENERACION DE SELLO... [ %s ]", $sMensaje));
		return $sSello;
	}
	
	function generaSelloSmarterWeb33($sLlave, $sCadenaOriginal) {
		$sSello = NULL;
		$sMensaje = 'Error interno del sistema generaSelloSmarterWeb33.';
		try {	
			 //$sSello=$sLlave;
			 $pkeyid = openssl_get_privatekey($sLlave);
			 openssl_sign($sCadenaOriginal, $crypttext, $pkeyid, "sha256WithRSAEncryption");
			 //openssl_sign($sCadenaOriginal, $crypttext, $pkeyid, OPENSSL_ALGO_SHA1);

			 openssl_free_key($pkeyid);
			 $sSello = base64_encode($crypttext);
			 
			 $sMensaje = 'OK';
			//$this->GrabaLog(sprintf("SELLO... [ %s ]", $sSello));

		}
		catch(exception $ex) {
			$sMensaje = $ex->getMessage();
			$sSello = NULL;
			$this->GrabaLog(sprintf("ERROR EN generaSelloSmarterWeb33... [ %s ]", $sMensaje));
		}
		return $sSello;
	}
	
	function generaQR() {
		
	}

	function procesaXmlComprobante($sXML) {
		$Comprobante = NULL;
		$hResponse = new stdClass();
		$iEstado = 1;
		$sMensaje = 'Error interno del sistema.';
		try {
			$obj = simplexml_load_string($sXML);
			$obj->registerXPathNamespace('cfdi', 'http://www.sat.gob.mx/cfd/3');
			$obj->registerXPathNamespace('nomina12', 'http://www.sat.gob.mx/nomina12');
			if(!$obj->xpath('//cfdi:Comprobante'))
				$sMensaje = 'El nodo Comprobante es requerido';
			else if(!$obj->xpath('//cfdi:Emisor'))
				$sMensaje = 'El nodo Emisor es requerido';
			else if(!$obj->xpath('//cfdi:RegimenFiscal'))
				$sMensaje = 'El nodo RegimenFiscal es requerido';
			else if(!$obj->xpath('//cfdi:Receptor'))
				$sMensaje = 'El nodo Receptor es requerido';
			else if(!$obj->xpath('//cfdi:Concepto'))
				$sMensaje = 'El nodo Concepto es requerido';
			else if(!$obj->xpath('//cfdi:Impuestos'))
				$sMensaje = 'El nodo Impuestos es requerido';
			else if(!$obj->xpath('//nomina12:Nomina'))
				$sMensaje = 'El nodo Nomina es requerido';
			else if(!$obj->xpath('//nomina12:Percepcion'))
				$sMensaje = 'El nodo Percepcion es requerido';
			else if(!$obj->xpath('//nomina12:Deduccion'))
				$sMensaje = 'El nodo Deduccion es requerido';
			else {
				$elementocfdi = NULL;
				$Comprobante = new stdClass();
				$elementocfdi = $obj->xpath('//cfdi:Comprobante');
				foreach($elementocfdi[0]->attributes() as $indice => $valor) {
					$Comprobante->$indice = (string)$valor;
				}
				$elementocfdi = NULL;
				$elementocfdi = $obj->xpath('//cfdi:Emisor');
				$Comprobante->Emisor = new stdClass();
				foreach($elementocfdi[0]->attributes() as $indice => $valor) {
					$Comprobante->Emisor->$indice = (string)$valor;
				}
				$elementocfdi = NULL;
				$elementocfdi = $obj->xpath('//cfdi:RegimenFiscal');
				$Comprobante->Emisor->RegimenFiscal = new stdClass();
				foreach($elementocfdi[0]->attributes() as $indice => $valor) {
					$Comprobante->Emisor->RegimenFiscal->$indice = (string)$valor;
				}
				$elementocfdi = NULL;
				$elementocfdi = $obj->xpath('//cfdi:Receptor');
				$Comprobante->Receptor = new stdClass();
				foreach($elementocfdi[0]->attributes() as $indice => $valor) {
					$Comprobante->Receptor->$indice = (string)$valor;
				}
				$elementocfdi = NULL;
				$elementocfdi = $obj->xpath('//cfdi:Concepto');
				$Comprobante->Conceptos = new stdClass();
				$Comprobante->Conceptos->Concepto = new stdClass();
				foreach($elementocfdi[0]->attributes() as $indice => $valor) {
					$Comprobante->Conceptos->Concepto->$indice = (string)$valor;
				}
				$elementocfdi = NULL;
				$elementocfdi = $obj->xpath('//cfdi:Impuestos');
				$Comprobante->Impuestos = new stdClass();
				foreach($elementocfdi[0]->attributes() as $indice => $valor) {
					$Comprobante->Impuestos->$indice = (string)$valor;
				}
				$elementocfdi = NULL;
				$elementocfdi = $obj->xpath('//nomina12:Nomina');
				$Comprobante->Complemento = new stdClass();
				$Comprobante->Complemento->Nomina = new stdClass();
				foreach($elementocfdi[0]->attributes() as $indice => $valor) {
					$Comprobante->Complemento->Nomina->$indice = (string)$valor;
				}
				$elementocfdi = NULL;
				$elementocfdi = $obj->xpath('//nomina12:Percepcion');
				$Comprobante->Complemento->Nomina->Percepciones = new stdClass();
				$iElemento = 1;
				foreach($elementocfdi as $elemento) {
					$hijo = sprintf("Percepcion_%04d", $iElemento);
					$Comprobante->Complemento->Nomina->Percepciones->$hijo = new stdClass();
					foreach($elemento->attributes() as $indice => $valor) {
						$Comprobante->Complemento->Nomina->Percepciones->$hijo->$indice = (string)$valor;
					}
					$iElemento++;
				}
				$elementocfdi = NULL;
				$elementocfdi = $obj->xpath('//nomina12:Deduccion');
				$Comprobante->Complemento->Nomina->Deducciones = new stdClass();
				$iElemento = 1;
				foreach($elementocfdi as $elemento) {
					$hijo = sprintf("Deduccion_%04d", $iElemento);
					$Comprobante->Complemento->Nomina->Deducciones->$hijo = new stdClass();
					foreach($elemento->attributes() as $indice => $valor) {
						$Comprobante->Complemento->Nomina->Deducciones->$hijo->$indice = (string)$valor;
					}
					$iElemento++;
				}
				$elementocfdi = NULL;
				$elementocfdi = $obj->xpath('//nomina12:Incapacidad');
				if($elementocfdi) {
					$Comprobante->Complemento->Nomina->Incapacidades = new stdClass();
					$iElemento = 1;
					foreach($elementocfdi as $elemento) {
						$hijo = sprintf("Incapacidad_%04d", $iElemento);
						$Comprobante->Complemento->Nomina->Incapacidades->$hijo = new stdClass();
						foreach($elemento->attributes() as $indice => $valor) {
							$Comprobante->Complemento->Nomina->Incapacidades->$hijo->$indice = (string)$valor;
						}
						$iElemento++;
					}
				}
				$elementocfdi = NULL;
				$elementocfdi = $obj->xpath('//nomina12:HorasExtra');
				if($elementocfdi) {
					$Comprobante->Complemento->Nomina->HorasExtras = new stdClass();
					$iElemento = 1;
					foreach($elementocfdi as $elemento) {
						$hijo = sprintf("HorasExtra_%04d", $iElemento);
						$Comprobante->Complemento->Nomina->HorasExtras->$hijo = new stdClass();
						foreach($elemento->attributes() as $indice => $valor) {
							$Comprobante->Complemento->Nomina->HorasExtras->$hijo->$indice = (string)$valor;
						}
						$iElemento++;
					}
				}
				$iEstado = 0;
				$sMensaje = 'OK';
				$hResponse->comprobante = $Comprobante;
			}
		}
		catch(exception $ex) {
			$iEstado = 2;
			$sMensaje = $ex->getMessage();
			$Comprobante = NULL;
			$this->GrabaLog(sprintf("ERROR EN procesaXmlComprobante... [ %s ]", $sMensaje." XML ".$sXML));
			
		}
		//$this->GrabaLog(sprintf("PROCESAMIENTO DE XML... [ %s ]", $sMensaje));
		if($iEstado == 2)
			$sMensaje = 'Error al procesar XML.';
		$hResponse->estado = $iEstado;
		$hResponse->mensaje = $sMensaje;
		return $hResponse;
	}

	function procesaXmlComprobante33($sXML, $sClvTipoTimbrado = NULL) {
		$Comprobante = NULL;
		$hResponse = new stdClass();
		$iEstado = 1;
		$sMensaje = 'Error interno del sistema.';
		try {
			$obj = simplexml_load_string($sXML);
			$obj->registerXPathNamespace('cfdi', 'http://www.sat.gob.mx/cfd/3');
			$obj->registerXPathNamespace('nomina12', 'http://www.sat.gob.mx/nomina12');
			if(!$obj->xpath('//cfdi:Comprobante'))
				$sMensaje = 'El nodo Comprobante es requerido';
			else if(!$obj->xpath('//cfdi:Emisor'))
				$sMensaje = 'El nodo Emisor es requerido';
			else if(!$obj->xpath('//cfdi:Receptor'))
				$sMensaje = 'El nodo Receptor es requerido';
			else if(!$obj->xpath('//cfdi:Concepto'))
				$sMensaje = 'El nodo Concepto es requerido';
			else if(!$obj->xpath('//nomina12:Nomina'))
				$sMensaje = 'El nodo Nomina es requerido';
			else if(!$obj->xpath('//nomina12:Percepcion') && $sClvTipoTimbrado != '2')
				$sMensaje = 'El nodo Percepcion es requerido';
			else if(!$obj->xpath('//nomina12:Deduccion') && $sClvTipoTimbrado != '2')
				$sMensaje = 'El nodo Deduccion es requerido';
			else {
				$elementocfdi = NULL;
				$Comprobante = new stdClass();
				$elementocfdi = $obj->xpath('//cfdi:Comprobante');
				foreach($elementocfdi[0]->attributes() as $indice => $valor) {
					$Comprobante->$indice = (string)$valor;
				}

				$elementocfdi = NULL;
				$elementocfdi = $obj->xpath('//cfdi:CfdiRelacionados');
				if($elementocfdi) {
					$Comprobante->CfdiRelacionados = new stdClass();
					$Comprobante->CfdiRelacionados->CfdiRelacionado = new stdClass();
					foreach($elementocfdi[0]->attributes() as $indice => $valor) {
					$Comprobante->CfdiRelacionados->CfdiRelacionado->$indice = (string)$valor;
					}
				}

				$elementocfdi = NULL;
				$elementocfdi = $obj->xpath('//cfdi:Emisor');
				$Comprobante->Emisor = new stdClass();
				foreach($elementocfdi[0]->attributes() as $indice => $valor) {
					$Comprobante->Emisor->$indice = (string)$valor;
				}

				$elementocfdi = NULL;
				$elementocfdi = $obj->xpath('//cfdi:Receptor');
				$Comprobante->Receptor = new stdClass();
				foreach($elementocfdi[0]->attributes() as $indice => $valor) {
					$Comprobante->Receptor->$indice = (string)$valor;
				}

				$elementocfdi = NULL;
				$elementocfdi = $obj->xpath('//cfdi:Concepto');
				$Comprobante->Conceptos = new stdClass();
				$Comprobante->Conceptos->Concepto = new stdClass();
				foreach($elementocfdi[0]->attributes() as $indice => $valor) {
					$Comprobante->Conceptos->Concepto->$indice = (string)$valor;
				}

				$elementocfdi = NULL;
				$elementocfdi = $obj->xpath('//nomina12:Nomina');
				$Comprobante->Complemento = new stdClass();
				$Comprobante->Complemento->Nomina = new stdClass();
				foreach($elementocfdi[0]->attributes() as $indice => $valor) {
					$Comprobante->Complemento->Nomina->$indice = (string)$valor;
				}

				$elementocfdi = NULL;
				$elementocfdi = $obj->xpath('//nomina12:Percepcion');
				$Comprobante->Complemento->Nomina->Percepciones = new stdClass();
				$iElemento = 1;
				foreach($elementocfdi as $elemento) {
					$hijo = sprintf("Percepcion_%04d", $iElemento);
					$Comprobante->Complemento->Nomina->Percepciones->$hijo = new stdClass();
					foreach($elemento->attributes() as $indice => $valor) {
						$Comprobante->Complemento->Nomina->Percepciones->$hijo->$indice = (string)$valor;
					}
					$iElemento++;
				}

				$elementocfdi = NULL;
				$elementocfdi = $obj->xpath('//nomina12:Deduccion');
				$Comprobante->Complemento->Nomina->Deducciones = new stdClass();
				$iElemento = 1;
				foreach($elementocfdi as $elemento) {
					$hijo = sprintf("Deduccion_%04d", $iElemento);
					$Comprobante->Complemento->Nomina->Deducciones->$hijo = new stdClass();
					foreach($elemento->attributes() as $indice => $valor) {
						$Comprobante->Complemento->Nomina->Deducciones->$hijo->$indice = (string)$valor;
					}
					$iElemento++;
				}

				$elementocfdi = NULL;
				$elementocfdi = $obj->xpath('//nomina12:Incapacidad');
				if($elementocfdi) {
					$Comprobante->Complemento->Nomina->Incapacidades = new stdClass();
					$iElemento = 1;
					foreach($elementocfdi as $elemento) {
						$hijo = sprintf("Incapacidad_%04d", $iElemento);
						$Comprobante->Complemento->Nomina->Incapacidades->$hijo = new stdClass();
						foreach($elemento->attributes() as $indice => $valor) {
							$Comprobante->Complemento->Nomina->Incapacidades->$hijo->$indice = (string)$valor;
						}
						$iElemento++;
					}
				}
				$elementocfdi = NULL;
				$elementocfdi = $obj->xpath('//nomina12:HorasExtra');
				if($elementocfdi) {
					$Comprobante->Complemento->Nomina->HorasExtras = new stdClass();
					$iElemento = 1;
					foreach($elementocfdi as $elemento) {
						$hijo = sprintf("HorasExtra_%04d", $iElemento);
						$Comprobante->Complemento->Nomina->HorasExtras->$hijo = new stdClass();
						foreach($elemento->attributes() as $indice => $valor) {
							$Comprobante->Complemento->Nomina->HorasExtras->$hijo->$indice = (string)$valor;
						}
						$iElemento++;
					}
				}
				$iEstado = 0;
				$sMensaje = 'OK';
				$hResponse->comprobante = $Comprobante;
			}
		//} 
		}
		catch(exception $ex) {
			$iEstado = 2;
			$sMensaje = $ex->getMessage();
			$Comprobante = NULL;
			$this->GrabaLog(sprintf("ERROR EN procesaXmlComprobante... [ %s ]", $sMensaje." XML ".$sXML));
			
		}
		//$this->GrabaLog(sprintf("PROCESAMIENTO DE XML... [ %s ]", $sMensaje));
		if($iEstado == 2)
			$sMensaje = 'Error al procesar XML.';
		$hResponse->estado = $iEstado;
		$hResponse->mensaje = $sMensaje;
		return $hResponse;
	}
}
?>
