<?php
    require_once 'vendor/autoload.php';
    use SWServices\Stamp\StampService as StampService;                   // Incluimos el servicio del timbrado
    use SWServices\Cancelation\CancelationService as CancelationService; // Incluimos el servicio de la cancelacion

class CComprobanteSmarterWeb extends CComprobante {
    function __construct() {
    }
    
    function __destruct() {
    }

    function timbrar33($hConfWS, $sXml, $sClvTipoTimbrado) {
        $this->GrabaDebug(sprintf("INICIA METODO TIMBRADO timbrar33 SmarterWeb.. [ %s ]", $sXml));
        $sCadenaOriginal = '';
        $iEstado = 1;
        $sMensaje = 'Error interno del sistema timbrar33 SmarterWeb.';
        $sSello = '';
        $hResponse = new stdClass();
        $hProcesa = NULL;

        try {
            $sXml = $this->complementaXMLSmarterWeb33($sXml, $hConfWS->arc_xmldomiciliofiscal, $hConfWS->fec_xml, $hConfWS->nom_certificado);
            
            $hProcesa = $this->procesaXmlComprobante33($sXml, $sClvTipoTimbrado);
            if($hProcesa->estado != 0) {
                $sMensaje = $hProcesa->mensaje;
            }
            else {
                if(($sCadenaOriginal = $this->generaCadenaOriginal33($sXml)) == NULL)
                {
                    $sMensaje = 'Error al generar cadena original SmarterWeb.';
                }
                else {
                    if(($sSello = $this->generaSelloSmarterWeb33($hConfWS->arc_empresakey, $sCadenaOriginal)) == NULL) {
                        $sMensaje = 'Error al generar sello SmarterWeb.';
                    }
                    else {
                        $sXml = $this->agregarCertificadoYSelloSmarterWeb33($sXml, $hConfWS->arc_empresacert, $sSello);
                        $hDatosPac = $this->timbrarXML33($hConfWS, $sXml);
                        if($hDatosPac->estado != 0)
                            $sMensaje = $hDatosPac->mensaje;
                        else {
                            $iEstado = 0;
                            $sMensaje = 'OK';
                            $hDatosPac->total = intval(floatval($hProcesa->comprobante->Total) * 100);
                            $hDatosPac->subtotal = intval(floatval($hProcesa->comprobante->SubTotal) * 100);
                            $hDatosPac->descuento = intval(floatval($hProcesa->comprobante->Descuento) * 100);
                            $hResponse->datosPac = $hDatosPac;
                        }
                    }
                }
            }
        }
        catch(exception $ex) {
            $iEstado = 2;
            $sMensaje = $ex->getMessage();
            $this->GrabaLog(sprintf("ERROR EN GENERACION DE FACTURA... ERROR EN TIMBRADO timbrar33 SmarterWeb....... [ %s ]", $sMensaje." XML ".$sXml));
        }
        
        $hResponse->estado = $iEstado;
        $hResponse->mensaje = $sMensaje;
        return $hResponse;
    }

    private function timbrarXML33($hConfWS, $sXml) {
        $iEstado = 1;
        $sMensaje = 'Error interno del sistema timbrarXML33 SmarterWeb.';
        $hResponse = new stdClass();
        $proxyHost = "";
        $proxyPort = "";

        $message = "";
        $messageDetail = "";
        $status = "";

        $cadenaOriginalSAT = "";
        $noCertificadoSAT = "";
        $noCertificadoCFDI = "";
        $UUID = "";
        $selloSAT = "";
        $fechaTimbrado = "";
        $qrCode = "";
        $cfdi = "";

        try {
            // Configura el proxy para la conexion
            if($hConfWS->opc_proxy == '1') {
                $proxyHost = $hConfWS->num_proxyhost;
                $proxyPort = $hConfWS->num_port;
            }
			
            // Asigna los parametros necesarios para ejecutar la api
            $params = array(
                "url"  => $hConfWS->nom_url,
                "token"=> $hConfWS->des_token,
                // , "proxyhost" => $proxyHost
                // , "proxyport" => $proxyPort
				"proxy"=> "".$proxyHost.":".$proxyPort // Esto da como resultado proxycoppel.com:8080
            );
		
            $this->GrabaDebug(sprintf("SmarterWeb url... [ %s ]", $hConfWS->nom_url));
            $this->GrabaDebug(sprintf("SmarterWeb token. [ %s ]", $hConfWS->des_token));
            $this->GrabaDebug(sprintf("XML ENVIO........ [ %s ]", $sXml));
            $this->GrabaDebug('ENVIANDO SOLICITUD');

            header("Content-type: application/json");
            $stamp = StampService::Set($params); // Inicializa la clase del servicio.
            $json = $stamp::StampV4($sXml); // Realiza la solicitud del timbrado en la version 4 del servicio

            $resultstring = json_encode($json); // Codifica el resultado JSON de la solicitud REST a String
            $resultarray = json_decode($resultstring, true); // Codifica el String de la solicitud REST al tipo Array para poder acceder a sus variables
            
            $this->GrabaDebug(sprintf("RespuestaSmarterWeb String[ %s ]", $resultstring));
            $status = $resultarray["status"];

            if($status == "success") {
                $iEstado = 0;
                $sMensaje = 'OK';

                // Obtiene el resultado del array y lo almacena en las variables de salida
                $cadenaOriginalSAT  = $resultarray["data"]["cadenaOriginalSAT"];
                $noCertificadoSAT   = $resultarray["data"]["noCertificadoSAT"];
                $UUID               = $resultarray["data"]["uuid"];
                $selloSAT           = $resultarray["data"]["selloSAT"];
                $fechaTimbrado      = $resultarray["data"]["fechaTimbrado"];
                $qrCode             = $resultarray["data"]["qrCode"];
                $cfdi               = $resultarray["data"]["cfdi"];

                // Obtener Valores de los Atributos del nodo cfdi
                $dom = new DOMDocument;
                $dom->loadXML($cfdi);

                // Obtiene el atributo Version del elemento TimbreFiscalDigital
                $ElementTimbre = $dom->getElementsByTagName('TimbreFiscalDigital');
                if($ElementTimbre->item(0)->hasAttribute('Version')) {
                    $versionTFD = trim($ElementTimbre->item(0)->getAttribute('Version'));
                } else if($ElementTimbre->item(0)->hasAttribute('version')) {
                    $versionTFD = trim($ElementTimbre->item(0)->getAttribute('version'));
                }

                // Asigna las variables de salida a la clase $hResponse
                $hResponse->cadenaOriginal  = $cadenaOriginalSAT;
                $hResponse->certificadoSAT  = $noCertificadoSAT;
                $hResponse->xmlTimbrado     = $cfdi;
                $hResponse->fechatimbrado   = $fechaTimbrado;
                $hResponse->qr              = $qrCode;
                $hResponse->selloSAT        = $selloSAT;
                $hResponse->uuid            = strtoupper($UUID);
                $hResponse->versionTFD      = $versionTFD;

                $this->GrabaDebug(sprintf("Respuesta SmarterWeb cadenaOriginalSAT   [ %s ]", $cadenaOriginalSAT));
                $this->GrabaDebug(sprintf("Respuesta SmarterWeb noCertificadoSAT    [ %s ]", $noCertificadoSAT));
                $this->GrabaDebug(sprintf("Respuesta SmarterWeb cfdi                [ %s ]", $cfdi));
                $this->GrabaDebug(sprintf("Respuesta SmarterWeb fechaTimbrado       [ %s ]", $fechaTimbrado));
                $this->GrabaDebug(sprintf("Respuesta SmarterWeb qrCode              [ %s ]", $qrCode));
                $this->GrabaDebug(sprintf("Respuesta SmarterWeb selloSAT            [ %s ]", $selloSAT));
                $this->GrabaDebug(sprintf("Respuesta SmarterWeb UUID                [ %s ]", strtoupper($UUID)));
                $this->GrabaDebug(sprintf("Respuesta SmarterWeb versionTFD          [ %s ]", $versionTFD));

            } else {
                $message        = $resultarray["message"];
                $messageDetail  = $resultarray["messageDetail"];
                $sMensaje       = "Error en el timbrado de la nomina con SmartWeb: [ ". $message . " | " . $messageDetail . " ]";
            }
        }
        catch(exception $ex) {
            header("Content-type: text/plain");
            $iEstado = 2;
            $sMensaje = $ex->getMessage();
            $this->GrabaLog(sprintf("ERROR EN GENERACION DE FACTURA... ERROR EN timbrarXML33 SmarterWeb [ %s ]", $sMensaje." XML ".$sXml));
        }
        
        $hResponse->estado = $iEstado;
        $hResponse->mensaje = $sMensaje;
        return $hResponse;
    }

    function cancelar( $hConfWS, $sUuid ) {
        $iEstado = 1;
        $sMensaje = 'Error interno del sistema.';
        $hResponse = new stdClass();
        $proxyHost = "";
        $proxyPort = "";

        $message = "";
        $messageDetail = "";
        $status = "";

        $XmlAcuseCanc = '';
        $EstatusUUID = '';
		
		$motivo = "02";
		$foliosustitucion = "";
        
        try {
            // Inicializamos los parámetros, Datos requeridos: url del servicio, token de autenticacion, uuid del xml, password del archivo key, rfc emisor, Certificado (.cer) en base64, Key (.key) en base64.
            $hConfWS->arc_empresacert = str_replace('-----BEGIN CERTIFICATE-----', '', $hConfWS->arc_empresacert);
            $hConfWS->arc_empresacert = str_replace('-----END CERTIFICATE-----', '', $hConfWS->arc_empresacert);
            $hConfWS->arc_empresakey = str_replace('-----BEGIN RSA PRIVATE KEY-----', '', $hConfWS->arc_empresakey);
            $hConfWS->arc_empresakey = str_replace('-----END RSA PRIVATE KEY-----', '', $hConfWS->arc_empresakey);
            // Configura el proxy para la conexion
            if($hConfWS->opc_proxy == '1') {
                $proxyHost = $hConfWS->num_proxyhost;
                $proxyPort = $hConfWS->num_port;
            }
            $params = array(
                'url'       => $hConfWS->nom_url,
                'token'     => $hConfWS->des_token,
				'proxy'		=> "".$proxyHost.":".$proxyPort,
                'uuid'      => $sUuid,
                'password'  => $hConfWS->cve_password,
                'rfc'       => $hConfWS->rfc_emisor,
				'motivo'    => $motivo,
                'b64Cer'    => $hConfWS->arc_empresacert,
                'b64Key'    => $hConfWS->arc_empresakey
            );
			
            $this->GrabaDebug(sprintf("url........ [ %s ]", $hConfWS->nom_url));
            $this->GrabaDebug(sprintf("token...... [ %s ]", $hConfWS->des_token));
            $this->GrabaDebug(sprintf("uuid....... [ %s ]", $sUuid));
            $this->GrabaDebug(sprintf("password... [ %s ]", $hConfWS->cve_password));
            $this->GrabaDebug(sprintf("rfc_Emisor. [ %s ]", $hConfWS->rfc_emisor));
            $this->GrabaDebug(sprintf("csdCer..... [ %s ]", $hConfWS->arc_empresacert));
            $this->GrabaDebug(sprintf("csdKey..... [ %s ]", $hConfWS->arc_empresakey));

            //header("Content-type: application/json");
            //$cancelationService = CancelationService::Set($params); //asignamos los valores al servicio
            //$json = $cancelationService::CancelationByCSD(); //usamos el servicio de cancelación
			
			//RAÚL VERDUGO: Se agrega método directo ya que la librería con el nuevo parámetro motivo no es compatible
			//con la versión del PHP 5.3
			$json = $this->sendReqCSD($params);

            $resultstring = json_encode($json); // Codifica el resultado JSON de la solicitud REST a String
            $resultarray = json_decode($resultstring, true); // Codifica el String de la solicitud REST al tipo Array para poder acceder a sus variables

            $this->GrabaDebug(sprintf("RespuestaSmarterWeb String[ %s ]", $resultstring));
            
            $status = $resultarray["status"];
            if($status == "success") {
                // Obtiene el resultado del array y lo almacena en las variables de salida
                $XmlAcuseCanc   = $resultarray["data"]["acuse"];
                $arrayUUID      = $resultarray["data"]["uuid"];

                $EstatusUUID    = $arrayUUID[$sUuid];

                $iEstado = 0;
                $sMensaje = 'OK';
                $hResponse->EstatusUUID = $EstatusUUID;
                $hResponse->AcuseCanc = $XmlAcuseCanc;
                $hResponse->respuestaPac = "UUID Cancelado correctamente con SmarterWeb";

                $this->GrabaLog(sprintf("Se cancelo el folio fiscal: [%s]", $sUuid));

                $this->GrabaDebug(sprintf("Respuesta SmarterWeb XmlAcuseCanc   [ %s ]", $XmlAcuseCanc));
                $this->GrabaDebug(sprintf("Respuesta SmarterWeb EstatusUUID    [ %s ]", $EstatusUUID));
                $this->GrabaDebug(sprintf("Respuesta SmarterWeb sUuid          [ %s ]", $sUuid));

            } else {
                $message        = $resultarray["message"];
                //$messageDetail  = $resultarray["messageDetail"];
                //$sMensaje       = "Error en el timbrado de la nomina con SmarterWeb: [ ". $message . " | " . $messageDetail . " ]";
				$sMensaje       = "Error en el timbrado de la nomina con SmarterWeb: [ ". $message . " ]";
            }
        }
        catch(exception $ex) {
            $iEstado = 2;
            $sMensaje = $ex->getMessage();
            $this->GrabaLog(sprintf("ERROR EN CANCELACION DE FACTURA... [ %s ]", $sMensaje. " UUID ".$sUuid));
        }
        
        //if($iEstado == 2)
            //$sMensaje = 'Error interno del sistema.';
        $hResponse->estado = $iEstado;
        $hResponse->mensaje = $sMensaje;
        return $hResponse;
    }
	
	public static function sendReqCSD($cfdiData) { 
	
		$url = $cfdiData['url'];
		$token = $cfdiData['token'];
		$proxy = $cfdiData['proxy'];

        $data = json_encode($cfdiData);
        $curl  = curl_init($url.'/cfdi33/cancel/csd');
        curl_setopt($curl , CURLOPT_RETURNTRANSFER, true);
        curl_setopt($curl , CURLOPT_POST, true);
        if(isset($proxy)){
            curl_setopt($curl , CURLOPT_PROXY, $proxy);
        }
        
        curl_setopt($curl , CURLOPT_HTTPHEADER , array(
            'Content-Type: application/json;  ',
            'Content-Length: ' . strlen($data),
            'Authorization: Bearer '.$token,
			'Expect: '
        ));  
        curl_setopt($curl , CURLOPT_POSTFIELDS, $data);

        $response = curl_exec($curl);
        $httpcode = curl_getinfo($curl, CURLINFO_HTTP_CODE);
        $err = curl_error($curl );
        curl_close($curl);

        if ($err) {
            throw new Exception("cURL Error #:" . $err);
        } else{
            if($httpcode < 500)
                return json_decode($response);
            else
                throw new Exception("cUrl Error, HTTPCode: $httpcode, Response: $response");
        }
    }

}
?>