CREATE OR REPLACE FUNCTION fun_obtener_proveedor_cancelacion_activo(IN character varying)
   RETURNS integer AS
$BODY$
DECLARE
    sIpWSFacturacionNomina  ALIAS FOR $1;
    num_pac                 INTEGER;

    /*
        NOMBRE              : 97295493 Victor Vizcarra.
        BD                  : NOMINACONTABILIDAD
        FECHA               : 03/01/2018
        SERVIDOR PRUEBAS    : 10.44.15.182
        SERVIDOR PRODUCCION : 10.44.1.12
        DESCRIPCION         : Se encarga de obtener el proveedor activo para la cancelacion de comprobantes de nomina para el servidor de la FACTURACION.
        MODULO              : NOMG0010.DLL y NOMG0011.DLL
        RUTA                : svn://10.44.15.239/sysx/administracion/PROYECTOS WEB/FacturacionElectronicaNomina/FacturacionElectronicaNomina/scripts
    */
BEGIN
    num_pac := COALESCE((SELECT a.num_paccfdicancelacion FROM ctl_wsfacturaselectronicasnominahost AS a WHERE a.num_wshost = sIpWSFacturacionNomina::cidr), 0);

    RETURN num_pac;
END;
$BODY$
   LANGUAGE plpgsql VOLATILE SECURITY DEFINER;

GRANT EXECUTE ON FUNCTION fun_obtener_proveedor_cancelacion_activo(IN character varying) TO sysfacturaelectronicaadmin;

COMMENT ON FUNCTION fun_obtener_proveedor_cancelacion_activo(IN character varying) 
    IS 'Se encarga de obtener el proveedor activo para la cancelacion de comprobantes de nomina para el servidor de la FACTURACION.
sIpWSFacturacionNomina = Ip del servidor de la nomina encargado de cancelar.'; 