﻿CREATE OR REPLACE FUNCTION fun_timbradofacturaelectronicanominarequest02(IN character varying, IN integer, IN integer, IN date, IN text, IN integer, IN bigint, IN bigint)
  RETURNS TABLE(idu_folio integer, des_mensaje character varying, num_paccfdi integer, nom_url character varying, opc_proxy integer, num_proxyhost character varying, num_port integer, opc_credenciales integer, nom_usuario character varying, nom_password character varying, des_token text, nom_certificado character varying, arc_empresacert text, arc_empresakey text, arc_xmldomiciliofiscal text, fec_xml character varying) AS
$BODY$
DECLARE
	/*
		NOMBRE              : VICTOR VIZCARRA # 97295493
		BD                  : facturacionelectronica POSGRESQL
		FECHA               : 21/02/2018
		SERVIDOR PRUEBAS    : 10.44.15.127
		SERVIDOR PRODUCCION : 10.44.1.130
		DESCRIPCION         : Se encarga de verificar que una factura no se encuentre activa y valida el RFC y certificado de la empresa.
		MODULO              : FacturacionElectronicaNomina.ZIP
		RUTA                : svn://10.44.15.239/sysx/administracion/PROYECTOS WEB/FacturacionElectronicaNomina/FacturacionElectronicaNomina/scripts

		FECHA MODIFICACION  : 11/10/2019
		NOMBRE MODIFICO     : JOVANY PEREZ CASTA#EDA
		MODIFICACION        : Se modifica para validar si el rfc es Afore tome la fecha y hora actual del servidor, en caso contrario tomará la fecha de la zona horaria de mazatlan
	*/
    
	cRFC                ALIAS FOR $1;
	iNumEmpleado        ALIAS FOR $2;
	iNumEmpleadoGenera  ALIAS FOR $3;
	dtFechaNomina       ALIAS FOR $4;
	cXMLNomina          ALIAS FOR $5;
	iTipoNomina         ALIAS FOR $6;
	iNumControl         ALIAS FOR $7;
	iNumIdentKey        ALIAS FOR $8;
	iFolio integer;
	cMensaje varchar(1024);
	dtFechaMovto timestamp without time zone;
	iNumPacCfdi integer;
	cUrlWS varchar(512);
	iProxy integer;
	cIpProxy varchar(15);
	iPuerto integer;
	CNomCert varchar(64);
	cWSCert text;
	cWSKey text;
	iCredenciales integer;
	cUsuario varchar(128);
	cPassword varchar(256);
	cToken text;
	cEmpresaCert text;
	cDomicilioFiscal text;
	cEmpresaCalle varchar(150);
	cEmpresaNumExterior varchar(10);
	cEmpresaColonia varchar(150);
	cEmpresaLocalidad varchar(150);
	cEmpresaMunicipio varchar(150);
	cEmpresaEstado varchar(150);
	cEmpresaPais varchar(150);
	cCodigoPostal varchar(5);
	cFechaXML varchar(19);
    
BEGIN
    iFolio:= 0;
    cMensaje:= 'Operacion exitosa';
    dtFechaMovto:= now();    
    iNumPacCfdi:= 0;
    cUrlWS:= '';
    iProxy:= 0;
    cIpProxy:= '';
    iPuerto:= 0;
    CNomCert:= '';
    cWSCert:= '';
    cWSKey:= '';
    iCredenciales:= 0;
    cUsuario:= '';
    cPassword:= '';
    cToken:= '';
    cEmpresaCert:= '';
    cDomicilioFiscal:= '';
    cEmpresaCalle:= '';
    cEmpresaNumExterior:= '';
    cEmpresaColonia:= '';
    cEmpresaLocalidad:= '';
    cEmpresaMunicipio:= '';
    cEmpresaEstado:= '';
    cEmpresaPais:= '';
    cCodigoPostal:= '';

    if('ACO051202NK7' != cRFC) THEN
	dtFechaMovto := dtFechaMovto - INTERVAL '1 Hour';
    end if;

    cFechaXML := replace(to_char(dtFechaMovto, 'YYYY-MM-DD T HH24:MI:SS'), ' ', '');

    SELECT a.num_paccfdi INTO iNumPacCfdi FROM ctl_wsfacturaselectronicasnominahost a WHERE num_wshost = inet_client_addr();
    IF FOUND THEN
        IF (SELECT COUNT(idu_foliomovto) FROM mov_facturasnomina WHERE num_empleado = iNumEmpleado AND fec_nomina = dtFechaNomina::date AND opc_estatus = 1 AND clv_rfcempresa = cRFC AND clv_tiponomina = iTipoNomina AND num_control = iNumControl AND num_ident_key = iNumIdentKey ) > 0 THEN
            cMensaje:= 'Ya existe una factura activa para el empleado con la fecha de nomina ' || dtFechaNomina::date;
        ELSE
            SELECT trim(nom_calle), trim(num_exterior), trim(nom_colonia), trim(nom_localidad), trim(nom_municipio), trim(nom_estado), trim(nom_pais), trim(num_cp) 
            INTO cEmpresaCalle, cEmpresaNumExterior, cEmpresaColonia, cEmpresaLocalidad, cEmpresaMunicipio, cEmpresaEstado, cEmpresaPais, cCodigoPostal
            FROM cat_empresasnomina WHERE clv_rfc = cRFC;
            IF FOUND THEN
                SELECT b.nom_urlws, b.opc_requireproxy::integer, host(b.num_proxyhost), b.num_proxyport, b.opc_credenciales::integer, 
                b.nom_usuario, b.nom_password INTO cUrlWS, iProxy, cIpProxy, iPuerto, iCredenciales, cUsuario, cPassword
                FROM ctl_operacionesurlwspaccfdi a INNER JOIN cat_urlwspaccfdi b ON a.num_urlwspaccfdi = b.idu_urlwspaccfdi 
                WHERE a.num_paccfdi = iNumPacCfdi AND a.num_operacion = 1;
                IF FOUND THEN
                    SELECT split_part(arc_cer, '.', 1), cve_llavepublica, cve_llaveprivada INTO CNomCert, cWSCert, cWSKey FROM cat_archivopem WHERE clv_rfcempresa = cRFC;
                    IF FOUND THEN
                        IF iNumPacCfdi = 3 THEN
                            SELECT d.nom_usuario, d.nom_password INTO cUsuario, cPassword FROM ctl_usuariosdetecno d WHERE clv_rfc = cRFC;
                            IF FOUND THEN
                                iFolio:= nextval('facturaselectronicasnominakeyx_seq');
                                INSERT INTO mov_facturasnominarequest(idu_foliomovto, clv_rfcempresa, num_empleado, num_empleadogenera, fec_nomina, 
                                arc_xmlnomina, num_paccfdi, fec_movto, num_control, num_ident_key) 
                                VALUES (iFolio, cRFC, iNumEmpleado, iNumEmpleadoGenera, dtFechaNomina, cXMLNomina, iNumPacCfdi, dtFechaMovto, iNumControl, iNumIdentKey);
                            ELSE
                                cMensaje:= 'No esta registrado el usuario y contrasena para la empresa en el proveedor detecno';
                            END IF;
                        ELSIF iNumPacCfdi = 4 THEN
                            SELECT d.nom_usuario, d.nom_password, d.des_token INTO cUsuario, cPassword, cToken FROM ctl_usuarios_smarterweb d WHERE d.opc_activo = 1 AND d.clv_rfc = cRFC;
                            IF FOUND THEN
                                iFolio:= nextval('facturaselectronicasnominakeyx_seq');
                                INSERT INTO mov_facturasnominarequest(idu_foliomovto, clv_rfcempresa, num_empleado, num_empleadogenera, fec_nomina, 
                                arc_xmlnomina, num_paccfdi, fec_movto, num_control, num_ident_key) 
                                VALUES (iFolio, cRFC, iNumEmpleado, iNumEmpleadoGenera, dtFechaNomina, cXMLNomina, iNumPacCfdi, dtFechaMovto, iNumControl, iNumIdentKey);
                            ELSE
                                cMensaje:= 'No esta registrado el usuario y contrasena para la empresa en el proveedor SmarterWeb';
                            END IF;
                        ELSE
                            iFolio:= nextval('facturaselectronicasnominakeyx_seq');
                            INSERT INTO mov_facturasnominarequest(idu_foliomovto, clv_rfcempresa, num_empleado, num_empleadogenera, fec_nomina, 
                            arc_xmlnomina, num_paccfdi, fec_movto, num_control, num_ident_key) 
                            VALUES (iFolio, cRFC, iNumEmpleado, iNumEmpleadoGenera, dtFechaNomina, cXMLNomina, iNumPacCfdi, dtFechaMovto, iNumControl, iNumIdentKey);
                        END IF;
                    ELSE
                        cMensaje:= 'No esta registrado el certificado de la empresa';
                    END IF;
                ELSE
                    cMensaje:= 'El servicio web al que intenta conectarse no esta configurado';
                END IF;
            ELSE
                cMensaje:= 'El rfc de la empresa no esta registrado';
            END IF;
        END IF;
    ELSE
        cMensaje:= 'El servidor remoto no esta autorizado para el timbrado de facturas electronicas de nomina';
    END IF;

    IF iFolio = 0 THEN
        iNumPacCfdi:= 0;
        cUrlWS:= '';
        iProxy:= 0;
        cIpProxy:= '';
        iPuerto:= 0;
        CNomCert:= '';
        cWSCert:= '';
        cWSKey:= '';
        iCredenciales:= 0;
        cUsuario:= '';
        cPassword:= '';
        cToken:= '';
        cEmpresaCert:= '';
        cDomicilioFiscal:= '';
        cFechaXML:= '';
    END IF;
    
    RETURN QUERY SELECT iFolio, cMensaje, iNumPacCfdi, cUrlWS, iProxy, cIpProxy, iPuerto, iCredenciales, cUsuario, cPassword, cToken, CNomCert, cWSCert, cWSKey, cDomicilioFiscal, cFechaXML;
  END;
$BODY$
  LANGUAGE plpgsql VOLATILE SECURITY DEFINER;