-- Function: fun_cancelafacturaelectronicanominarequest01(character varying, integer)

-- DROP FUNCTION fun_cancelafacturaelectronicanominarequest01(character varying, integer);

CREATE OR REPLACE FUNCTION fun_cancelafacturaelectronicanominarequest01(IN character varying, IN integer)
  RETURNS TABLE(idu_estado integer, des_mensaje character varying, idu_folio integer, num_paccfdi integer, nom_url character varying, opc_proxy integer, num_proxyhost character varying, num_port integer, opc_credenciales integer, nom_usuario character varying, nom_password character varying, nom_certificado character varying, arc_empresacert text, arc_empresakey text, rfc_emisor character varying, xml_timbrado text, cve_password character varying) AS
$BODY$
  DECLARE
    cUuid ALIAS FOR $1;
    iNumEmpleadoCancela ALIAS FOR $2;
    iEstado integer;
    cMensaje varchar(1024);
    iFolioMovto integer;
    iEstatus smallint;
    cRFC varchar(13);
    iNumPacCfdi integer;
    cUrlWS varchar(512);
    iProxy integer;
    cIpProxy varchar(15);
    iPuerto integer;
    CNomCert varchar(64);
    cWSCert text;
    cWSKey text;
    iCredenciales integer;
    cUsuario varchar(128);
    cPassword varchar(256);
    dtFechaMovto timestamp without time zone;
    cXml_timbrado text;
    cPasswordPEM varchar(256);
    
/*
    NOMBRE              : Victor Manuel Vizcarra Bejarano 97295493
    BD                  : facturacionelectronica PostgreSQL
    FECHA               : 21/12/2017
    SERVIDOR PRUEBAS    : 10.44.15.127
    SERVIDOR PRODUCCION : 10.44.1.130
    DESCRIPCION         : Se encarga de obtener los datos para la cancelacion de una factura de nomina.
*/

  BEGIN
    iEstado:= 1;
    cMensaje:= 'Operacion exitosa';
    iFolioMovto:= 0;
    iEstatus:= 0;
    cRFC:= '';
    iNumPacCfdi:= 0;
    cUrlWS:= '';
    iProxy:= 0;
    cIpProxy:= '';
    iPuerto:= 0;
    CNomCert:= '';
    cWSCert:= '';
    cWSKey:= '';
    iCredenciales:= 0;
    cUsuario:= '';
    cPassword:= '';
    dtFechaMovto:= now();
    cXml_timbrado:='';
    cPasswordPEM := '';

    SELECT a.num_paccfdicancelacion INTO iNumPacCfdi FROM ctl_wsfacturaselectronicasnominahost a WHERE num_wshost = inet_client_addr();
    IF FOUND THEN
        SELECT a.idu_foliomovto, a.opc_estatus, a.clv_rfcempresa, a.arc_xmltimbrado INTO iFolioMovto, iEstatus, cRFC, cXml_timbrado FROM mov_facturasnomina a WHERE a.fol_uuid = cUuid;
        IF FOUND THEN
            IF iEstatus = 0 THEN
                iEstado:= 1;
                cMensaje:= 'La factura ya esta cancelada';
            ELSE
                SELECT b.nom_urlws, b.opc_requireproxy::integer, host(b.num_proxyhost), b.num_proxyport, b.opc_credenciales::integer, b.nom_usuario, b.nom_password 
                INTO cUrlWS, iProxy, cIpProxy, iPuerto, iCredenciales, cUsuario, cPassword
                FROM ctl_operacionesurlwspaccfdi a INNER JOIN cat_urlwspaccfdi b ON a.num_urlwspaccfdi = b.idu_urlwspaccfdi 
                WHERE a.num_paccfdi = iNumPacCfdi AND a.num_operacion = 2;
                IF FOUND THEN
                    SELECT split_part(b.arc_cer, '.', 1), b.cve_llavepublica, b.cve_llaveprivada, b.cve_password INTO CNomCert, cWSCert, cWSKey, cPasswordPEM FROM cat_archivopem b WHERE b.clv_rfcempresa = cRFC;
                    IF FOUND THEN
                        IF iNumPacCfdi = 3 THEN
                            SELECT d.nom_usuario, d.nom_password INTO cUsuario, cPassword FROM ctl_usuariosdetecno d WHERE clv_rfc = cRFC;
                            IF FOUND THEN
                                INSERT INTO mov_cancelacionfacturasnominarequest(idu_foliomovto, num_empleadocancela, fol_uuid, fec_movto)
                                VALUES(iFolioMovto, iNumEmpleadoCancela, cUuid, dtFechaMovto);
                                iEstado:= 0;
                            ELSE
                                cMensaje:= 'No esta registrado el usuario y contrasena para la empresa en el proveedor detecno';
                            END IF;
                        ELSE
                            INSERT INTO mov_cancelacionfacturasnominarequest(idu_foliomovto, num_empleadocancela, fol_uuid, fec_movto)
                            VALUES(iFolioMovto, iNumEmpleadoCancela, cUuid, dtFechaMovto);
                            iEstado:= 0;
                        END IF;
                    ELSE
                        cMensaje:= 'No esta registrado el certificado de la empresa';
                    END IF;
                ELSE
                    cMensaje:= 'El servicio web al que intenta conectarse no esta configurado';
                END IF;
            END IF;
        ELSE
            cMensaje:= 'El folio uuid no se encuentra registrado';
        END IF;
    ELSE
        cMensaje:= 'El servidor remoto no esta autorizado para la cancelacion de facturas electronicas de nomina';
    END IF;

    IF iEstado <> 0 THEN
        iFolioMovto:= 0;
        iNumPacCfdi:= 0;
        cUrlWS:= '';
        iProxy:= 0;
        cIpProxy:= '';
        iPuerto:= 0;
        CNomCert:= '';
        cWSCert:= '';
        cWSKey:= '';
        iCredenciales:= 0;
        cUsuario:= '';
        cPassword:= '';
        cRFC:=0;
        cXml_timbrado:='';
        cPasswordPEM := '';
    END IF;
    RETURN QUERY SELECT iEstado, cMensaje, iFolioMovto, iNumPacCfdi, cUrlWS, iProxy, cIpProxy, iPuerto, iCredenciales, cUsuario, cPassword, CNomCert, cWSCert, cWSKey,cRFC,cXml_timbrado, cPasswordPEM;
  END;
$BODY$
  LANGUAGE plpgsql VOLATILE SECURITY DEFINER;

GRANT EXECUTE ON FUNCTION fun_cancelafacturaelectronicanominarequest01(character varying, integer) TO public;
GRANT EXECUTE ON FUNCTION fun_cancelafacturaelectronicanominarequest01(character varying, integer) TO sysfacturaelectronicaadmin;
