CREATE OR REPLACE FUNCTION fun_timbradofacturaelectronicanominarequest(IN character varying, IN integer, IN integer, IN date, IN text)
  RETURNS TABLE(idu_folio integer, des_mensaje character varying, num_paccfdi integer, nom_url character varying, opc_proxy integer, num_proxyhost character varying, num_port integer, opc_credenciales integer, nom_usuario character varying, nom_password character varying, nom_certificado character varying, arc_empresacert text, arc_empresakey text, arc_xmldomiciliofiscal text, fec_xml character varying) AS
$BODY$
  DECLARE
    cRFC ALIAS FOR $1;
    iNumEmpleado ALIAS FOR $2;
    iNumEmpleadoGenera ALIAS FOR $3;
    dtFechaNomina ALIAS FOR $4;
    cXMLNomina ALIAS FOR $5;
    iFolio integer;
    cMensaje varchar(1024);
    dtFechaMovto timestamp without time zone;
    iNumPacCfdi integer;
    cUrlWS varchar(512);
    iProxy integer;
    cIpProxy varchar(15);
    iPuerto integer;
    CNomCert varchar(64);
    cWSCert text;
    cWSKey text;
    iCredenciales integer;
    cUsuario varchar(128);
    cPassword varchar(256);
    cEmpresaCert text;
    cDomicilioFiscal text;
    cEmpresaCalle varchar(150);
    cEmpresaNumExterior varchar(10);
    cEmpresaColonia varchar(150);
    cEmpresaLocalidad varchar(150);
    cEmpresaMunicipio varchar(150);
    cEmpresaEstado varchar(150);
    cEmpresaPais varchar(150);
    cCodigoPostal varchar(5);
    cFechaXML varchar(19);
  BEGIN
    iFolio:= 0;
    cMensaje:= 'Operacion exitosa';
    dtFechaMovto:= now();
    cFechaXML:= replace(to_char(dtFechaMovto, 'YYYY-MM-DD T HH24:MI:SS'), ' ', '');
    iNumPacCfdi:= 0;
    cUrlWS:= '';
    iProxy:= 0;
    cIpProxy:= '';
    iPuerto:= 0;
    CNomCert:= '';
    cWSCert:= '';
    cWSKey:= '';
    iCredenciales:= 0;
    cUsuario:= '';
    cPassword:= '';
    cEmpresaCert:= '';
    cDomicilioFiscal:= '';
    cEmpresaCalle:= '';
    cEmpresaNumExterior:= '';
    cEmpresaColonia:= '';
    cEmpresaLocalidad:= '';
    cEmpresaMunicipio:= '';
    cEmpresaEstado:= '';
    cEmpresaPais:= '';
    cCodigoPostal:= '';
    SELECT a.num_paccfdi INTO iNumPacCfdi FROM ctl_wsfacturaselectronicasnominahost a WHERE num_wshost = inet_client_addr();
    IF FOUND THEN
      IF (SELECT COUNT(idu_foliomovto) FROM mov_facturasnomina WHERE num_empleado = iNumEmpleado AND fec_nomina = dtFechaNomina::date AND opc_estatus = 1) > 0 THEN
        cMensaje:= 'Ya existe una factura activa para el empleado con la fecha de nomina ' || dtFechaNomina::date;
      ELSE
        SELECT trim(nom_calle), trim(num_exterior), trim(nom_colonia), trim(nom_localidad), trim(nom_municipio), trim(nom_estado), trim(nom_pais), trim(num_cp) 
        INTO cEmpresaCalle, cEmpresaNumExterior, cEmpresaColonia, cEmpresaLocalidad, cEmpresaMunicipio, cEmpresaEstado, cEmpresaPais, cCodigoPostal
        FROM cat_empresasnomina WHERE clv_rfc = cRFC;
        IF FOUND THEN
          cDomicilioFiscal:= '<cfdi:DomicilioFiscal calle="' || cEmpresaCalle || '" noExterior="' || cEmpresaNumExterior|| '" colonia="' ||
          cEmpresaColonia || '" localidad="' || cEmpresaLocalidad || '"  municipio="' || cEmpresaMunicipio || '" estado="' || 
          cEmpresaEstado || '" pais="' || cEmpresaPais || '" codigoPostal="' || cCodigoPostal || '" />';
          SELECT b.nom_urlws, b.opc_requireproxy::integer, host(b.num_proxyhost), b.num_proxyport, b.opc_credenciales::integer, 
          b.nom_usuario, b.nom_password INTO cUrlWS, iProxy, cIpProxy, iPuerto, iCredenciales, cUsuario, cPassword
          FROM ctl_operacionesurlwspaccfdi a INNER JOIN cat_urlwspaccfdi b ON a.num_urlwspaccfdi = b.idu_urlwspaccfdi 
          WHERE a.num_paccfdi = iNumPacCfdi AND a.num_operacion = 1;
          IF FOUND THEN
            SELECT split_part(arc_cer, '.', 1), cve_llavepublica, cve_llaveprivada INTO CNomCert, cWSCert, cWSKey FROM cat_archivopem WHERE clv_rfcempresa = cRFC;
            IF FOUND THEN
              iFolio:= nextval('facturaselectronicasnominakeyx_seq');
              INSERT INTO mov_facturasnominarequest(idu_foliomovto, clv_rfcempresa, num_empleado, num_empleadogenera, fec_nomina, 
                arc_xmlnomina, num_paccfdi, fec_movto) VALUES (iFolio, cRFC, iNumEmpleado, iNumEmpleadoGenera, dtFechaNomina, cXMLNomina, iNumPacCfdi, dtFechaMovto);
            ELSE
              cMensaje:= 'No esta registrado el certificado de la empresa';
            END IF;
          ELSE
            cMensaje:= 'El servicio web al que intenta conectarse no esta configurado';
          END IF;
        ELSE
          cMensaje:= 'El rfc de la empresa no esta registrado';
        END IF;
      END IF;
    ELSE
      cMensaje:= 'El servidor remoto no esta autorizado para el timbrado de facturas electronicas de nomina';
    END IF;
    IF iFolio = 0 THEN
      iNumPacCfdi:= 0;
      cUrlWS:= '';
      iProxy:= 0;
      cIpProxy:= '';
      iPuerto:= 0;
      CNomCert:= '';
      cWSCert:= '';
      cWSKey:= '';
      iCredenciales:= 0;
      cUsuario:= '';
      cPassword:= '';
      cEmpresaCert:= '';
      cDomicilioFiscal:= '';
      cFechaXML:= '';
    END IF;
    RETURN QUERY SELECT iFolio, cMensaje, iNumPacCfdi, cUrlWS, iProxy, cIpProxy, iPuerto, iCredenciales, cUsuario, cPassword, CNomCert, cWSCert, cWSKey, cDomicilioFiscal, cFechaXML;
  END;
$BODY$
  LANGUAGE plpgsql VOLATILE;
ALTER FUNCTION fun_timbradofacturaelectronicanominarequest(character varying, integer, integer, date, text)
  OWNER TO sysfacturaelectronicaadmin;
