<?php
    if(!file_exists('accesodatos/OdbcConnection.php') || !file_exists('accesodatos/CDAMovtoTimbrado.php') || !file_exists('objetonegocio/CComprobante.php') || !file_exists('objetonegocio/CComprobanteSolucionFactible.php') || !file_exists('objetonegocio/CComprobanteDiverza.php') || !file_exists('objetonegocio/CComprobanteDetecno.php') || !file_exists('objetonegocio/CComprobanteSmarterWeb.php') || !file_exists('vendor/autoload.php'))
        throw new Exception('GeneraciÃ³n de factura de nÃ³mina. Error al procesar la solicitud.', 1);
    require_once 'accesodatos/OdbcConnection.php';
    require_once 'accesodatos/CDAMovtoTimbrado.php';
    require_once 'objetonegocio/CComprobante.php';
    require_once 'objetonegocio/CComprobanteDiverza.php';
    require_once 'objetonegocio/CComprobanteDetecno.php';
    require_once 'objetonegocio/CComprobanteSolucionFactible.php';
    require_once 'objetonegocio/CComprobanteSmarterWeb.php';
    
    class CBOGenerarFacturaElectronicaNomina extends CGenerales {
        private $sXml;
        private $sRfc;
        private $sEmpleado;
        private $sRfcEmpleado;
        private $sFecNomina;
        private $sEmpleadoGenera;
        private $sNumEmpresa;
        private $sNumSemana;
        private $sNumObra;
        private $sClvTipoTimbrado;
        private $sNumControl;
        private $sNumIdentKey;
        private $sConexionNomina;

        function __construct() {
            $this->sXml = NULL;
            $this->sRfc = NULL;
            $this->sEmpleado = NULL;
            $this->sRfcEmpleado = NULL;
            $this->sFecNomina = NULL;
            $this->sEmpleadoGenera = NULL;
            $this->sNumEmpresa = NULL;
            $this->sNumSemana = NULL;
            $this->sNumObra = NULL;
            $this->sClvTipoTimbrado = NULL;
            $this->sNumControl = NULL;
            $this->sNumIdentKey = NULL;
            $this->sConexionNomina = NULL;
        }
    
        function __destruct() {
            $this->sXml = NULL;
            $this->sRfc = NULL;
            $this->sEmpleado = NULL;
            $this->sRfcEmpleado = NULL;
            $this->sFecNomina = NULL;
            $this->sEmpleadoGenera = NULL;
            $this->sNumEmpresa = NULL;
            $this->sNumSemana = NULL;
            $this->sNumObra = NULL;
            $this->sClvTipoTimbrado = NULL;
            $this->sNumControl = NULL;
            $this->sNumIdentKey = NULL;
            $this->sConexionNomina = NULL;
        }
    
        function generaFactura($sXml, $sRfc, $sEmpleado, $sFecNomina, $sEmpleadoGenera) {
            $sMensajeRespuesta = 'Error interno del sistema.';
            $sUuidRespuesta = "";
            $bInicia = FALSE;
            $hResponse = NULL;

            $GLOBALS['NUM_EMPLEADO'] = $sEmpleado;

            try {
                $bInicia = TRUE;
                $this->sXml = $sXml;
                $this->sRfc = $sRfc;
                $this->sEmpleado = $sEmpleado;
                $this->sFecNomina = $sFecNomina;
                $this->sEmpleadoGenera = $sEmpleadoGenera;

                $this->GrabaDebug("INICIA METODO WEB GENERARFACTURAELECTRONICANOMINA");
                $this->GrabaDebug("PARAMETROS RECIBIDOS");
                $this->GrabaDebug(sprintf("XML............... [ %s ]", $this->sXml));
                $this->GrabaDebug(sprintf("RFC............... [ %s ]", $this->sRfc));
                $this->GrabaDebug(sprintf("EMPLEADO.......... [ %s ]", $this->sEmpleado));
                $this->GrabaDebug(sprintf("FECHA NOMINA...... [ %s ]", $this->sFecNomina));
                $this->GrabaDebug(sprintf("EMPLEADO GENERA... [ %s ]", $this->sEmpleadoGenera));

                if($this->esCadenaValida($this->sXml) && $this->esCadenaValida($this->sRfc) && 
                  $this->esCadenaValida($this->sEmpleado) && $this->esCadenaValida($this->sFecNomina) && $this->esCadenaValida($this->sEmpleadoGenera)) {
                    $hMovtoTimbrado = new CDAMovtoTimbrado();
                    $hResponse = $hMovtoTimbrado->grabarMovtoPre($this->sXml, $this->sRfc, $this->sEmpleado, $this->sFecNomina, $this->sEmpleadoGenera);
                    if($hResponse->estado != 0) {
                        $sMensajeRespuesta = $hResponse->mensaje;
                    }
                    else {
                        if($hResponse->configuracionWS->num_paccfdi == $GLOBALS['PAC_TIMBRADO_SOLUCIONFACTIBLE']) {
                            $idu_folio = $hResponse->configuracionWS->idu_folio;
                            $hComprobanteCFDI = new CComprobanteSolucionFactible();
                            $hResponse = $hComprobanteCFDI->timbrar($hResponse->configuracionWS, $this->sXml);
                            if($hResponse->estado != 0)
                                $sMensajeRespuesta = $hResponse->mensaje;
                            else {
                                $sUuidRespuesta = $hResponse->datosPac->uuid;
                                $hResponse = $hMovtoTimbrado->grabarRespuestaPac($idu_folio, $hResponse->datosPac);
                                $sMensajeRespuesta = $hResponse->mensaje;
                                if($hResponse->estado != 0) {
                                    $sMensajeRespuesta = sprintf('Se generÃ³ el UUID %s sin embargo no se pudo registrar en la base de datos. Favor de solicitar su cancelaciÃ³n.', $sUuidRespuesta);
                                    $sUuidRespuesta = '';
                                }
                            }
                        }
                        else if($hResponse->configuracionWS->num_paccfdi == $GLOBALS['PAC_TIMBRADO_DIVERZA']) {
                            $idu_folio = $hResponse->configuracionWS->idu_folio;
                            $hComprobanteCFDI = new CComprobanteDiverza();
                            $hResponse = $hComprobanteCFDI->timbrar($hResponse->configuracionWS, $this->sXml);
                            if($hResponse->estado != 0)
                                $sMensajeRespuesta = $hResponse->mensaje;
                            else {
                                $sUuidRespuesta = $hResponse->datosPac->uuid;
                                $hResponse = $hMovtoTimbrado->grabarRespuestaPac($idu_folio, $hResponse->datosPac);
                                $sMensajeRespuesta = $hResponse->mensaje;
                                if($hResponse->estado != 0) {
                                    $sMensajeRespuesta = sprintf('Se generÃ³ el UUID %s sin embargo no se pudo registrar en la base de datos. Favor de solicitar su cancelaciÃ³n.', $sUuidRespuesta);
                                    $sUuidRespuesta = '';
                                }
                            }
                        }
                        else if($hResponse->configuracionWS->num_paccfdi == $GLOBALS['PAC_TIMBRADO_DETECNO']) {
                            $idu_folio = $hResponse->configuracionWS->idu_folio;
                            $hComprobanteCFDI = new CComprobanteDetecno();
                            $hResponse = $hComprobanteCFDI->timbrar($hResponse->configuracionWS, $this->sXml);
                            if($hResponse->estado != 0)
                                $sMensajeRespuesta = $hResponse->mensaje;
                            else {
                                $sUuidRespuesta = $hResponse->datosPac->uuid;
                                $hResponse = $hMovtoTimbrado->grabarRespuestaPac($idu_folio, $hResponse->datosPac);
                                $sMensajeRespuesta = $hResponse->mensaje;
                                if($hResponse->estado != 0) {
                                    $sMensajeRespuesta = sprintf('Se generÃ³ el UUID %s sin embargo no se pudo registrar en la base de datos. Favor de solicitar su cancelaciÃ³n.', $sUuidRespuesta);
                                    $sUuidRespuesta = '';
                                } else {
                                    $hResponse = $hMovtoTimbrado->grabarRespuestaPac($idu_folio, $hResponse->datosPac);
                                }
                            }
                        }
                        else {
                            $sMensajeRespuesta = 'Error al timbrar XML, proveedor invÃ¡lido.'; 
                        }
                    }
                }
                else {
                    $sMensajeRespuesta = "Uno o mas de los parÃ¡metros recibidos es invÃ¡lido.";
                }
                $this->GrabaDebug(sprintf("GENERACION DE FACTURA... [ Numemp %s - %s ]", $this->sEmpleado, $sMensajeRespuesta));
                $this->GrabaDebug("TERMINA METODO WEB GENERARFACTURAELECTRONICANOMINA");
            }
            catch(exception $ex) {
                $sEstadoRespuesta = "1";
                $sMensajeRespuesta = $ex->getMessage();
                if($bInicia) {
                //    $this->GrabaLog(sprintf("EXCEPCION......... [ %s ]", $sMensajeRespuesta));
                    $this->GrabaLog(sprintf("GENERACION DE FACTURA... [ Numemp %s - %s ]", $this->sEmpleado, $sMensajeRespuesta));
                    $this->GrabaDebug(sprintf("GENERACION DE FACTURA... [ Numemp %s - %s ]", $this->sEmpleado, $sMensajeRespuesta));
                    $this->GrabaDebug("TERMINA METODO WEB GENERARFACTURAELECTRONICANOMINA");
                }
            }
            return '<?xml version="1.0" encoding="UTF-8"?><respuesta><idu_empleado>' . $sEmpleado . 
            '</idu_empleado><fec_nomina>' . $sFecNomina . '</fec_nomina><uuid>' . $sUuidRespuesta . 
            '</uuid><mensaje>' . $sMensajeRespuesta . '</mensaje></respuesta>';
        }
        
        function generaFacturaTimbre($sXml, $sNumEmpresa, $sRfc, $sEmpleado, $sRfcEmpleado, $sFecNomina, $sNumSemana, $sNumObra, $sEmpleadoGenera, $sClvTipoTimbrado, $sNumControl, $sNumIdentKey, $sConexionNomina) {
            $sMensajeRespuesta = 'Error interno del sistema.';
            $sMensajeError = "";
            $sUuidRespuesta = "";
            $bInicia = FALSE;
            $hResponse = NULL;
            $hRespuestaError = NULL;

            $GLOBALS['NUM_EMPLEADO'] = $sEmpleado;

            try {
                $bInicia = TRUE;
                $this->sXml = $sXml;
                $this->sNumEmpresa = $sNumEmpresa;
                $this->sRfc = $sRfc;
                $this->sEmpleado = $sEmpleado;
                $this->sRfcEmpleado = $sRfcEmpleado;
                $this->sFecNomina = $sFecNomina;
                $this->sNumSemana = $sNumSemana;
                $this->sNumObra = $sNumObra;
                $this->sEmpleadoGenera = $sEmpleadoGenera;
                $this->sClvTipoTimbrado = $sClvTipoTimbrado;
                $this->sNumControl = $sNumControl;
                $this->sNumIdentKey = $sNumIdentKey;
                $this->sConexionNomina = $sConexionNomina;

                $this->GrabaDebug("INICIA METODO WEB GENERARFACTURAELECTRONICANOMINA");
                $this->GrabaDebug("PARAMETROS RECIBIDOS"); //Victor
                $this->GrabaDebug(sprintf("XML............... [ %s ]", $this->sXml));
                $this->GrabaDebug(sprintf("NUMERO DE EMPRESA. [ %s ]", $this->sNumEmpresa));
                $this->GrabaDebug(sprintf("RFC............... [ %s ]", $this->sRfc));
                $this->GrabaDebug(sprintf("EMPLEADO.......... [ %s ]", $this->sEmpleado));
                $this->GrabaDebug(sprintf("RFC EMPLEADO...... [ %s ]", $this->sRfcEmpleado));
                $this->GrabaDebug(sprintf("FECHA NOMINA...... [ %s ]", $this->sFecNomina));
                $this->GrabaDebug(sprintf("NUMERO SEMANA..... [ %s ]", $this->sNumSemana));
                $this->GrabaDebug(sprintf("NUMERO OBRA....... [ %s ]", $this->sNumObra));
                $this->GrabaDebug(sprintf("EMPLEADO GENERA... [ %s ]", $this->sEmpleadoGenera));
                $this->GrabaDebug(sprintf("CLV TIPO TIMBRADO. [ %s ]", $this->sClvTipoTimbrado));
                $this->GrabaDebug(sprintf("NUMERO DE CONTROL. [ %s ]", $this->sNumControl));
                $this->GrabaDebug(sprintf("NUMERO IDENT KEY.. [ %s ]", $this->sNumIdentKey));
                $this->GrabaDebug(sprintf("CONEXION NOMINA... [ %s ]", $this->sConexionNomina));

                if($this->esCadenaValida($this->sXml) && $this->esCadenaValida($this->sRfc) && 
                  $this->esCadenaValida($this->sEmpleado) && $this->esCadenaValida($this->sFecNomina) && $this->esCadenaValida($this->sEmpleadoGenera)) {
                    $hMovtoTimbrado = new CDAMovtoTimbrado();
                    $hResponse = $hMovtoTimbrado->grabarMovtoPre33($this->sXml, $this->sRfc, $this->sEmpleado, $this->sFecNomina, $this->sEmpleadoGenera, $this->sClvTipoTimbrado, $this->sNumControl, $this->sNumIdentKey);
                    if($hResponse->estado != 0) {
                        $sMensajeRespuesta = $hResponse->mensaje;
                        
                        $sUuidRespuesta = "";
                    } 
                    else {
                        if($hResponse->configuracionWS->num_paccfdi == $GLOBALS['PAC_TIMBRADO_SOLUCIONFACTIBLE']) {
                            $idu_folio = $hResponse->configuracionWS->idu_folio;
                            $hComprobanteCFDI = new CComprobanteSolucionFactible();
                            $hResponse = $hComprobanteCFDI->timbrar33($hResponse->configuracionWS, $this->sXml);
                            if($hResponse->estado != 0) {
                                $sMensajeRespuesta = $hResponse->mensaje;
                        
                                $sUuidRespuesta = "";
                            } else {
                                $sUuidRespuesta = $hResponse->datosPac->uuid;
                                $hResponse = $hMovtoTimbrado->grabarRespuestaPac33($idu_folio, $hResponse->datosPac, $this->sClvTipoTimbrado);
                                $sMensajeRespuesta = $hResponse->mensaje;
                                if($hResponse->estado != 0) {
                                    $sMensajeRespuesta = sprintf('Se generÃ³ el UUID %s sin embargo no se pudo registrar en la base de datos. Favor de solicitar su cancelaciÃ³n.', $sUuidRespuesta);
                                    $sUuidRespuesta = "";
                                } else {
                                    $hResponse = $hMovtoTimbrado->grabarComprobanteNomina($this->sEmpleado, $this->sFecNomina, $this->sRfcEmpleado, $sUuidRespuesta, 0, $this->sNumEmpresa, $this->sNumSemana, $this->sClvTipoTimbrado, $this->sNumObra, $this->sNumControl, $this->sNumIdentKey, $this->sConexionNomina);
                                    $sMensajeError = $hResponse->mensaje;
                                    if($hResponse->estado != 0) {
                                        $hRespuestaError = $hMovtoTimbrado->grabarErroresTimbradoNomina($sEmpleado, $sFecNomina, $sNumEmpresa, $sNumObra, $sClvTipoTimbrado, $sMensajeError, $sEmpleadoGenera, $sNumControl, $sNumIdentKey, $sConexionNomina);
                                        $sMensajeError = $hRespuestaError->mensaje;
                                        if($hRespuestaError->estado != 0) {
                                            $this->GrabaLog(sprintf("GRABAR ERRORES... [ Numemp %s - %s ]", $sEmpleado, $sMensajeError));
                                        }
                                    }
                                }
                            }
                        }
                        else if($hResponse->configuracionWS->num_paccfdi == $GLOBALS['PAC_TIMBRADO_DIVERZA']) {
                            $idu_folio = $hResponse->configuracionWS->idu_folio;
                            $hComprobanteCFDI = new CComprobanteDiverza();
                            $hResponse = $hComprobanteCFDI->timbrar($hResponse->configuracionWS, $this->sXml);
                            if($hResponse->estado != 0) {
                                $sMensajeRespuesta = $hResponse->mensaje;
                        
                                $sUuidRespuesta = "";
                            } else {
                                $sUuidRespuesta = $hResponse->datosPac->uuid;
                                $hResponse = $hMovtoTimbrado->grabarRespuestaPac33($idu_folio, $hResponse->datosPac, $this->sClvTipoTimbrado);
                                $sMensajeRespuesta = $hResponse->mensaje;
                                if($hResponse->estado != 0) {
                                    $sMensajeRespuesta = sprintf('Se generÃ³ el UUID %s sin embargo no se pudo registrar en la base de datos. Favor de solicitar su cancelaciÃ³n.', $sUuidRespuesta);
                                    $sUuidRespuesta = "";
                                } else {
                                    $hResponse = $hMovtoTimbrado->grabarComprobanteNomina($this->sEmpleado, $this->sFecNomina, $this->sRfcEmpleado, $sUuidRespuesta, 0, $this->sNumEmpresa, $this->sNumSemana, $this->sClvTipoTimbrado, $this->sNumObra, $this->sNumControl, $this->sNumIdentKey, $this->sConexionNomina);
                                    $sMensajeError = $hResponse->mensaje;
                                    if($hResponse->estado != 0) {
                                        $hRespuestaError = $hMovtoTimbrado->grabarErroresTimbradoNomina($sEmpleado, $sFecNomina, $sNumEmpresa, $sNumObra, $sClvTipoTimbrado, $sMensajeError, $sEmpleadoGenera, $sNumControl, $sNumIdentKey, $sConexionNomina);
                                        $sMensajeError = $hRespuestaError->mensaje;
                                        if($hRespuestaError->estado != 0) {
                                            $this->GrabaLog(sprintf("GRABAR ERRORES... [ Numemp %s - %s ]", $sEmpleado, $sMensajeError));
                                        }
                                    }
                                }
                            }
                        }
                        else if($hResponse->configuracionWS->num_paccfdi == $GLOBALS['PAC_TIMBRADO_DETECNO']) {
                            $idu_folio = $hResponse->configuracionWS->idu_folio;
                            $hComprobanteCFDI = new CComprobanteDetecno();
                            $hResponse = $hComprobanteCFDI->timbrar33($hResponse->configuracionWS, $this->sXml, $this->sClvTipoTimbrado);
                            if($hResponse->estado != 0) {
                                $sMensajeRespuesta = $hResponse->mensaje;
                        
                                $sUuidRespuesta = "";
                            } else {
                                $sUuidRespuesta = $hResponse->datosPac->uuid;
                                $hResponse = $hMovtoTimbrado->grabarRespuestaPac33($idu_folio, $hResponse->datosPac, $this->sClvTipoTimbrado);
                                $sMensajeRespuesta = $hResponse->mensaje;
                                if($hResponse->estado != 0) {
                                    $sMensajeRespuesta = sprintf('Se generÃ³ el UUID %s sin embargo no se pudo registrar en la base de datos. Favor de solicitar su cancelaciÃ³n.', $sUuidRespuesta);
                                    $sUuidRespuesta = "";
                                } else {
                                    $hResponse = $hMovtoTimbrado->grabarComprobanteNomina($this->sEmpleado, $this->sFecNomina, $this->sRfcEmpleado, $sUuidRespuesta, 0, $this->sNumEmpresa, $this->sNumSemana, $this->sClvTipoTimbrado, $this->sNumObra, $this->sNumControl, $this->sNumIdentKey, $this->sConexionNomina);
                                    $sMensajeError = $hResponse->mensaje;
                                    if($hResponse->estado != 0) {
                                        $hRespuestaError = $hMovtoTimbrado->grabarErroresTimbradoNomina($sEmpleado, $sFecNomina, $sNumEmpresa, $sNumObra, $sClvTipoTimbrado, $sMensajeError, $sEmpleadoGenera, $sNumControl, $sNumIdentKey, $sConexionNomina);
                                        $sMensajeError = $hRespuestaError->mensaje;
                                        if($hRespuestaError->estado != 0) {
                                            $this->GrabaLog(sprintf("GRABAR ERRORES... [ Numemp %s - %s ]", $sEmpleado, $sMensajeError));
                                        }
                                    }
                                }
                            }
                        }
                        else if($hResponse->configuracionWS->num_paccfdi == $GLOBALS['PAC_TIMBRADO_SMARTERWEB']) {
                            $idu_folio = $hResponse->configuracionWS->idu_folio;
                            $hComprobanteCFDI = new CComprobanteSmarterWeb();

                            $hResponse = $hComprobanteCFDI->timbrar33($hResponse->configuracionWS, $this->sXml, $this->sClvTipoTimbrado);
                            if($hResponse->estado != 0) {
                                $sMensajeRespuesta = $hResponse->mensaje;
                                $sUuidRespuesta = "";
                            } else {
                                $sUuidRespuesta = $hResponse->datosPac->uuid;
                                $hResponse = $hMovtoTimbrado->grabarRespuestaPac33($idu_folio, $hResponse->datosPac, $this->sClvTipoTimbrado);
                                $sMensajeRespuesta = $hResponse->mensaje;
                                if($hResponse->estado != 0) {
                                    $sMensajeRespuesta = sprintf('Se generÃ³ el UUID %s sin embargo no se pudo registrar en la base de datos. Favor de solicitar su cancelaciÃ³n.', $sUuidRespuesta);
                                    $sUuidRespuesta = "";
                                } else {
                                    $hResponse = $hMovtoTimbrado->grabarComprobanteNomina($this->sEmpleado, $this->sFecNomina, $this->sRfcEmpleado, $sUuidRespuesta, 0, $this->sNumEmpresa, $this->sNumSemana, $this->sClvTipoTimbrado, $this->sNumObra, $this->sNumControl, $this->sNumIdentKey, $this->sConexionNomina);
                                    $sMensajeError = $hResponse->mensaje;
                                    if($hResponse->estado != 0) {
                                        $hRespuestaError = $hMovtoTimbrado->grabarErroresTimbradoNomina($sEmpleado, $sFecNomina, $sNumEmpresa, $sNumObra, $sClvTipoTimbrado, $sMensajeError, $sEmpleadoGenera, $sNumControl, $sNumIdentKey, $sConexionNomina);
                                        $sMensajeError = $hRespuestaError->mensaje;
                                        if($hRespuestaError->estado != 0) {
                                            $this->GrabaLog(sprintf("GRABAR ERRORES... [ Numemp %s - %s ]", $sEmpleado, $sMensajeError));
                                        }
                                    }
                                }
                            }
                        }
                        else {
                            $sMensajeRespuesta = 'Error al timbrar XML, proveedor invÃ¡lido.'; 
                        }
                    }
                }
                else {
                    $sMensajeRespuesta = "Uno o mas de los parÃ¡metros recibidos es invÃ¡lido.";
                }
                $this->GrabaDebug(sprintf("GENERACION DE FACTURA... [ Numemp %s - %s ]", $this->sEmpleado, $sMensajeRespuesta));
                $this->GrabaDebug("TERMINA METODO WEB GENERARFACTURAELECTRONICANOMINA");
            }
            catch(exception $ex) {
                $sEstadoRespuesta = "1";
                $sMensajeRespuesta = $ex->getMessage();
                if($bInicia) {
                //  $this->GrabaLog(sprintf("EXCEPCION......... [ %s ]", $sMensajeRespuesta));
                    $this->GrabaLog(sprintf("GENERACION DE FACTURA... [ Numemp %s - %s ]", $this->sEmpleado, $sMensajeRespuesta));
                    $this->GrabaDebug(sprintf("GENERACION DE FACTURA... [ Numemp %s - %s ]", $this->sEmpleado, $sMensajeRespuesta));
                    $this->GrabaDebug("TERMINA METODO WEB GENERARFACTURAELECTRONICANOMINA");
                }
            }
            
            if($sUuidRespuesta == "") {
                $this->GrabaLog(sprintf("ERROR EN GENERACION DE FACTURA... [ Numemp %s - %s ]", $sEmpleado, $sMensajeRespuesta));
                $hMovtoTimbrado2 = new CDAMovtoTimbrado();
                // //$hResponse = $hMovtoTimbrado->grabarMovtoPre($this->sXml, $this->sRfc, $this->sEmpleado, $this->sFecNomina, $this->sEmpleadoGenera);
                $hRespuestaError = $hMovtoTimbrado2->grabarErroresTimbradoNomina($sEmpleado, $sFecNomina, $sNumEmpresa, $sNumObra, $sClvTipoTimbrado, $sMensajeRespuesta, $sEmpleadoGenera, $sNumControl, $sNumIdentKey, $sConexionNomina);
                $sMensajeError = $hRespuestaError->mensaje;
                if($hRespuestaError->estado != 0) {
                    $this->GrabaDebug(sprintf("GRABAR ERRORES... [ Numemp %s - %s ]", $sEmpleado, $sMensajeError));
                }
                
                $hResponse = $hMovtoTimbrado2->grabarComprobanteNomina($this->sEmpleado, $this->sFecNomina, $this->sRfcEmpleado, $sUuidRespuesta, -1, $this->sNumEmpresa, $this->sNumSemana, $this->sClvTipoTimbrado, $this->sNumObra, $this->sNumControl, $this->sNumIdentKey, $this->sConexionNomina);
                $sMensajeError = $hResponse->mensaje;
            }
            
            return '<?xml version="1.0" encoding="UTF-8"?><respuesta><idu_empleado>' . $sEmpleado . 
            '</idu_empleado><fec_nomina>' . $sFecNomina . '</fec_nomina><uuid>' . $sUuidRespuesta . 
            '</uuid><mensaje>' . $sMensajeRespuesta . '</mensaje></respuesta>';
        }
    
        function validaXml($sXML) {
            $doc = DOMDocument();
            $doc->loadXML($sXML);
        }
    }
?>
