<?php
    error_reporting(0);
    if(!file_exists('files/cfg/definiciones.php')) {
        ExcepcionHTML('Error al procesar la solicitud. No existe la configuración del sistema.');
    }
    require_once 'files/cfg/definiciones.php';
    if($GLOBALS['WS_OP'] == 'WSDL') {
        header('Content-type: text/xml; charset=UTF-8;');
        echo displayWSDL();
    }
    else if($GLOBALS['WS_OP'] == 'wsdl') {
        header('Location: ' . $GLOBALS['PROJECTNAME'] . '.php?WSDL');
    }
    else if($GLOBALS['WS_OP'] == 'xsd=' . $GLOBALS['PROJECTNAME']) {
        header('Content-type: text/xml; charset=UTF-8;');
        echo displayXSD();
    }
    else if($GLOBALS['WS_OP'] == '') {
        if(isset($_SERVER['HTTP_SOAPACTION'])) {
            $hServer = new SoapServer($GLOBALS['WS_URL'] . '/' . $GLOBALS['PROJECTNAME'] . '.php?WSDL');
            for ($index = 0; $index < count($GLOBALS['WS_METHODS']); $index++) {
                $hServer->addFunction($GLOBALS['WS_METHODS'][$index]["MethodName"]);
            }
            $hServer->handle();
        }
        else {
            header('Content-type: text/html; charset=UTF-8;');
            displayHTML();	
        }
    }
    else {
        ExcepcionHTML('Error al procesar la solicitud. Operación inválida.');
    }

    function displayHTML() {
        $WebMethod = $GLOBALS['WS_METHODS'];
        $tab = '	';
        $newLine = '
';
        $html = '<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01//EN"' . $newLine;
        $html .= '"http://www.w3.org/TR/html4/strict.dtd">' . $newLine;
        $html .= '<html xmlns="http://www.w3.org/1999/xhtml" lang="en">' . $newLine;
        $html .= $tab . '<head>' . $newLine;
        $html .= $tab . $tab . '<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />' . $newLine;
        $html .= $tab . $tab . '<title>' . $GLOBALS['PROJECTNAME'] . '</title>' . $newLine;
        $html .= $tab . $tab . '<meta name="author" content="92556019" />' . $newLine;
        $html .= $tab . $tab . '<meta name="description" content="Servicio web para la generacion de facturas electronicas de nomina." />' . $newLine;
        $html .= $tab . $tab . '<!-- Date: 2014-01-12 -->' . $newLine;
        $html .= $tab . $tab . '<link rel="stylesheet" type="text/css" href="files/css/' . $GLOBALS['PROJECTNAME'] . '.css" />' . $newLine;
        $html .= $tab . '</head>' . $newLine;
        $html .= $tab . '<body>' . $newLine;
        $html .= $tab . $tab . '<div id="header">' . $newLine;
        $html .= $tab . $tab . $tab . $GLOBALS['PROJECTNAME'] . $newLine;
        $html .= $tab . $tab . '</div>' . $newLine;
        $html .= $tab . $tab . '<div id="content">' . $newLine;
        $html .= $tab . $tab . $tab . '<p>Las siguientes operaciones son soportadas. Para una descripcion formal, consulte la <a href="' . $GLOBALS['PROJECTNAME'] . '.php?WSDL">descripcion del servicio web</a></p>' . $newLine;
        $html .= $tab . $tab . $tab . '<ul>' . $newLine;
        for ($index = 0; $index < count($WebMethod); $index++) {
            $html .= $tab . $tab . $tab . $tab . '<li>' . $WebMethod[$index]["MethodName"] . '</li>' . $newLine;
        }
        $html .= $tab . $tab . $tab . '</ul>' . $newLine;
        $html .= $tab . $tab . '</div>' . $newLine;
        $html .= $tab . $tab . '<div id="footer">' . $newLine;
        $html .= $tab . $tab . '</div>' . $newLine;
        $html .= $tab . '</body>' . $newLine;
        $html .= '</html>' . $newLine;
        echo $html;
    }

    function displayWSDL() {
        $WebMethod = $GLOBALS['WS_METHODS'];
        $tab = '	';
        $newLine = '
';
        $xml = '<?xml version="1.0" encoding="UTF-8"?>' . $newLine;
        $xml .= '<wsdl:definitions name="' . $GLOBALS['PROJECTNAME'] . 'Service" targetNamespace="' . $GLOBALS['WS_TARGETNAMESPACE'] . '" xmlns:soap="http://schemas.xmlsoap.org/wsdl/soap/" xmlns:tns="' . $GLOBALS['WS_TARGETNAMESPACE'] . '" xmlns:wsdl="http://schemas.xmlsoap.org/wsdl/" xmlns:xsd="http://www.w3.org/2001/XMLSchema">' . $newLine;
        $xml .= $tab . '<wsdl:types>' . $newLine;
        $xml .= $tab . $tab . '<schema xmlns="http://www.w3.org/2001/XMLSchema">' . $newLine;
        $xml .= $tab . $tab . $tab . '<import namespace="' . $GLOBALS['WS_TARGETNAMESPACE'] . '" schemaLocation="' . $GLOBALS['WS_URL'] . '/' . $GLOBALS['PROJECTNAME'] . '.php?xsd=' . $GLOBALS['PROJECTNAME'] . '"/>' . $newLine;
        $xml .= $tab . $tab . '</schema>' . $newLine;
        $xml .= $tab . '</wsdl:types>' . $newLine;
        for ($index = 0; $index < count($WebMethod); $index++) {
            $xml .= $tab . '<wsdl:message name="' . $WebMethod[$index]["MethodName"] . '">' . $newLine;
            $xml .= $tab . $tab . '<wsdl:part element="tns:' . $WebMethod[$index]["MethodName"] . '" name="parameters">' . $newLine;
            $xml .= $tab . $tab . '</wsdl:part>'. $newLine;
            $xml .= $tab . '</wsdl:message>' . $newLine;
            $xml .= $tab . '<wsdl:message name="' . $WebMethod[$index]["MethodName"] . 'Response">' . $newLine;
            $xml .= $tab . $tab . '<wsdl:part element="tns:' . $WebMethod[$index]["MethodName"] . 'Response" name="parameters">' . $newLine;
            $xml .= $tab . $tab . '</wsdl:part>'. $newLine;
            $xml .= $tab . '</wsdl:message>' . $newLine;
        }
        $xml .= $tab . '<wsdl:portType name="' . $GLOBALS['PROJECTNAME'] . '">' . $newLine;
        for ($index = 0; $index < count($WebMethod); $index++) {
            $xml .= $tab . $tab . '<wsdl:operation name="' . $WebMethod[$index]["MethodName"] . '">' . $newLine;
            $xml .= $tab . $tab . $tab . '<wsdl:input message="tns:' . $WebMethod[$index]["MethodName"] . '" name="' . $WebMethod[$index]["MethodName"] . '">' . $newLine;
            $xml .= $tab . $tab . $tab . '</wsdl:input>'. $newLine;
            $xml .= $tab . $tab . $tab . '<wsdl:output message="tns:' . $WebMethod[$index]["MethodName"] . 'Response" name="' . $WebMethod[$index]["MethodName"] . 'Response">' . $newLine;
            $xml .= $tab . $tab . $tab . '</wsdl:output>'. $newLine;
            $xml .= $tab . $tab . '</wsdl:operation>' . $newLine;
        }
        $xml .= $tab . '</wsdl:portType>' . $newLine;
        $xml .= $tab . '<wsdl:binding name="' . $GLOBALS['PROJECTNAME'] . 'ServiceSoapBinding' . '" type="tns:' . $GLOBALS['PROJECTNAME'] . '">' . $newLine;
        $xml .= $tab . $tab . '<soap:binding style="document" transport="http://schemas.xmlsoap.org/soap/http" />' . $newLine;
        for ($index = 0; $index < count($WebMethod); $index++) {
            $xml .= $tab . $tab . '<wsdl:operation name="' . $WebMethod[$index]["MethodName"] . '">' . $newLine;
            $xml .= $tab . $tab . $tab . '<soap:operation soapAction="urn:' . $WebMethod[$index]["MethodName"] . '" style="document" />' . $newLine;
            $xml .= $tab . $tab . $tab . '<wsdl:input name="' . $WebMethod[$index]["MethodName"] . '">' . $newLine;
            $xml .= $tab . $tab . $tab . $tab . '<soap:body use="literal" />'. $newLine;
            $xml .= $tab . $tab . $tab . '</wsdl:input>'. $newLine;
            $xml .= $tab . $tab . $tab . '<wsdl:output name="' . $WebMethod[$index]["MethodName"] . 'Response">' . $newLine;
            $xml .= $tab . $tab . $tab . $tab . '<soap:body use="literal" />'. $newLine;
            $xml .= $tab . $tab . $tab . '</wsdl:output>'. $newLine;
            $xml .= $tab . $tab . '</wsdl:operation>' . $newLine;
        }
        $xml .= '</wsdl:binding>' . $newLine;
        $xml .= $tab . '<wsdl:service name="' . $GLOBALS['PROJECTNAME'] . 'Service">' . $newLine;
        $xml .= $tab . $tab . '<wsdl:port binding="tns:' . $GLOBALS['PROJECTNAME'] . 'ServiceSoapBinding" name="' . $GLOBALS['PROJECTNAME'] . 'Port">' . $newLine;
        $xml .= $tab . $tab . $tab . '<soap:address location="' . $GLOBALS['WS_LOCATION'] . '" />' . $newLine;
        $xml .= $tab . $tab . '</wsdl:port>' . $newLine;
        $xml .= $tab . '</wsdl:service>' . $newLine;
        $xml .= '</wsdl:definitions>' . $newLine;
        echo $xml;
    }
    
    function displayXSD() {
        $WebMethod = $GLOBALS['WS_METHODS'];
        $tab = '	';
        $newLine = '
';
        $xml = '<?xml version="1.0" encoding="UTF-8"?>' . $newLine;
        $xml .= '<xs:schema elementFormDefault="unqualified" targetNamespace="' . $GLOBALS['WS_TARGETNAMESPACE'] . '" version="1.0" xmlns:tns="' . $GLOBALS['WS_TARGETNAMESPACE'] . '" xmlns:xs="http://www.w3.org/2001/XMLSchema">' . $newLine;
        for ($index = 0; $index < count($WebMethod); $index++) {
            if(array_key_exists('RequestParams', $WebMethod[$index])) {
                $xml .= $tab . '<xs:element name="' . $WebMethod[$index]["MethodName"] . '" type="tns:' . $WebMethod[$index]["MethodName"] . '" />' . $newLine;
            }
            if(array_key_exists('ResponseParams', $WebMethod[$index])) {
                $xml .= $tab . '<xs:element name="' . $WebMethod[$index]["MethodName"] . 'Response" type="tns:' . $WebMethod[$index]["MethodName"] . 'Response" />' . $newLine;
            }
        }
        for ($index = 0; $index < count($WebMethod); $index++) {
            if(array_key_exists('RequestParams', $WebMethod[$index])) {
                $xml .= $tab . '<xs:complexType name="' . $WebMethod[$index]["MethodName"] . '">' . $newLine;
                $xml .= $tab . $tab . '<xs:sequence>' . $newLine;
                for ($indexParam = 0; $indexParam < count($WebMethod[$index]['RequestParams']); $indexParam++) {
                    $xml .= $tab . $tab . $tab . '<xs:element minOccurs="0" name="' . $WebMethod[$index]['RequestParams'][$indexParam]['Name'] . '" type="xs:' . $WebMethod[$index]['RequestParams'][$indexParam]['Type'] . '"/>' . $newLine;
                }
                $xml .= $tab . $tab . '</xs:sequence>' . $newLine;
                $xml .= $tab . '</xs:complexType>' . $newLine;
            }
            if(array_key_exists('ResponseParams', $WebMethod[$index])) {
                $xml .= $tab . '<xs:complexType name="' . $WebMethod[$index]["MethodName"] . 'Response">' . $newLine;
                $xml .= $tab . $tab . '<xs:sequence>' . $newLine;
                for ($indexParam = 0; $indexParam < count($WebMethod[$index]['ResponseParams']); $indexParam++) {
                    $xml .= $tab . $tab . $tab . '<xs:element minOccurs="0" name="' . $WebMethod[$index]['ResponseParams'][$indexParam]['Name'] . '" type="xs:' . $WebMethod[$index]['ResponseParams'][$indexParam]['Type'] . '"/>' . $newLine;
                }
                $xml .= $tab . $tab . '</xs:sequence>' . $newLine;
                $xml .= $tab . '</xs:complexType>' . $newLine;
            }
        }
        $xml .= '</xs:schema>' . $newLine;
        echo $xml;
    }
    
    function configuraServicio($webMethod) {
        $GLOBALS['WS_LOGFILE'] = 'CBO' . $webMethod;
        $GLOBALS['WS_DEBUGFILE'] = 'CBO' . $webMethod;
        if(!file_exists('logicanegocio/CGenerales.php') || !file_exists('logicanegocio/CBO' . $webMethod . '.php'))
            throw new Exception("Configuración de servicio. Error al procesar la solicitud.", 1);
        require_once 'logicanegocio/CGenerales.php';
        require_once 'logicanegocio/CBO' . $webMethod . '.php';
    }

    function ExcepcionHTML($sMensaje) {
        header('Content-type: text/html; charset=UTF-8;');
        exit($sMensaje);
    }
    
    function BuscarFacturaElectronicaNomina($formData) {
        $response = new stdClass();
        try {
            configuraServicio('BuscarFacturaElectronicaNomina');
            $formData = get_object_vars($formData);
            $sEmpleado  = $formData['idu_empleado'];
            $sFecNomina = $formData['fec_nomina'];
            $factura = new CBOBuscarFacturaElectronicaNomina();
            $response = $factura->buscarFactura($sEmpleado, $sFecNomina);
        }
        catch(exception $ex) {
            $response->estado = '1';
            $response->mensaje = 'Error al buscar factura';
            $response->xml = '';
            $response->qr = '';
        }
        return $response;
    }
    
    function CancelarFacturaElectronicaNomina($formData) {
        $response = new stdClass();
        try {
            configuraServicio('CancelarFacturaElectronicaNomina');
            $formData = get_object_vars($formData);
            $sUuid            = $formData['sUUID'];
            $sEmpleadoCancela = $formData['sEmpleadoCancelador'];
            $factura = new CBOCancelarFacturaElectronicaNomina();
            $response->return = $factura->cancelaFactura($sUuid, $sEmpleadoCancela);
        }
        catch(exception $ex) {
            throw new SoapFault('1', $ex->getMessage());
            /*$response->return = '<?xml version="1.0" encoding="UTF-8"?><respuesta><idu_empleado>' . $formdata['idu_empleado'] .
            '</idu_empleado><fec_nomina>' . $formdata['fec_nomina'] . '</fec_nomina><uuid></uuid><mensaje>' . 'Error al timbrar XML' . '</mensaje></respuesta>';*/
        }
        return $response;
    }
    
    function CancelarFacturaElectronicaNominaTimbre($formData) {
        $response = new stdClass();
        try {
            configuraServicio('CancelarFacturaElectronicaNomina');
            $formData = get_object_vars($formData);
            $sUuid            = $formData['sUUID'];
            $sEmpleadoCancela = $formData['sEmpleadoCancelador'];
            $sNumEmpresa      = $formData['num_empresa'];
            $sEmpleado        = $formData['idu_empleado'];
            $sRfcEmpleado     = $formData['rfc_empleado'];
            $sFecNomina       = $formData['fec_nomina'];
            $sNumSemana       = $formData['num_semana'];
            $sNumObra         = $formData['num_obra'];
            $sClvTipoTimbrado = $formData['clv_tipotimbrado'];
            $sNumControl      = $formData['num_control'];
            $sNumIdentKey     = $formData['num_ident_key'];
            $sConexionNomina  = $formData['des_conexion'];
            
            $factura = new CBOCancelarFacturaElectronicaNomina();
            $response->return = $factura->cancelaFacturaTimbre($sUuid, $sEmpleadoCancela, $sNumEmpresa, $sEmpleado, $sRfcEmpleado, $sFecNomina, $sNumSemana, $sNumObra, $sClvTipoTimbrado, $sNumControl, $sNumIdentKey, $sConexionNomina );
        }
        catch(exception $ex) {
            throw new SoapFault('1', $ex->getMessage());
            /*$response->return = '<?xml version="1.0" encoding="UTF-8"?><respuesta><idu_empleado>' . $formdata['idu_empleado'] .
            '</idu_empleado><fec_nomina>' . $formdata['fec_nomina'] . '</fec_nomina><uuid></uuid><mensaje>' . 'Error al timbrar XML' . '</mensaje></respuesta>';*/
        }
        return $response;
    }
    
    function CancelarFacturaElectronicaNominaConXML($formData) {
        $response = new stdClass();
        try {
            configuraServicio('CancelarFacturaElectronicaNomina');
            $formData = get_object_vars($formData);
            $sUuid            = $formData['des_uuid'];
            $sEmpleadoCancela = $formData['num_empleadocancela'];
            $sNumEmpresa      = $formData['num_empresa'];
            $sEmpleado        = $formData['idu_empleado'];
            $sRfcEmpleado     = $formData['rfc_empleado'];
            $sFecNomina       = $formData['fec_nomina'];
            $sNumSemana       = $formData['num_semana'];
            $sNumObra         = $formData['num_obra'];
            $sClvTipoTimbrado = $formData['clv_tipotimbrado'];
            $sNumControl      = $formData['num_control'];
            $sNumIdentKey     = $formData['num_ident_key'];
            $sConexionNomina  = $formData['des_conexion'];
            $sXml             = $formData['des_xml'];
            
            $factura = new CBOCancelarFacturaElectronicaNomina();
            $response->return = $factura->cancelaFacturaConXML( $sUuid, $sEmpleadoCancela, $sNumEmpresa, $sEmpleado, $sRfcEmpleado, $sFecNomina, $sNumSemana, $sNumObra, $sClvTipoTimbrado, $sNumControl, $sNumIdentKey, $sConexionNomina, $sXml );
        }
        catch(exception $ex) {
            throw new SoapFault('1', $ex->getMessage());
            /*$response->return = '<?xml version="1.0" encoding="UTF-8"?><respuesta><idu_empleado>' . $formdata['idu_empleado'] .
            '</idu_empleado><fec_nomina>' . $formdata['fec_nomina'] . '</fec_nomina><uuid></uuid><mensaje>' . 'Error al timbrar XML' . '</mensaje></respuesta>';*/
        }
        return $response;
    }
    
    function GenerarFacturaElectronicaNomina($formData) {
        $response = new stdClass();
        try {
            configuraServicio('GenerarFacturaElectronicaNomina');
            $formData = get_object_vars($formData);
            $sXml            = $formData['xml'];
            $sRfc            = $formData['rfc'];
            $sEmpleado       = $formData['idu_empleado'];
            $sFecNomina      = $formData['fec_nomina'];
            $sEmpleadoGenera = $formData['num_empleadogenera'];
            $factura = new CBOGenerarFacturaElectronicaNomina();
            $response->return = $factura->generaFactura($sXml, $sRfc, $sEmpleado, $sFecNomina, $sEmpleadoGenera);
        }
        catch(exception $ex) {
            throw new SoapFault('1', $ex->getMessage());
            /*$response->return = '<?xml version="1.0" encoding="UTF-8"?><respuesta><idu_empleado>' . $formdata['idu_empleado'] .
            '</idu_empleado><fec_nomina>' . $formdata['fec_nomina'] . '</fec_nomina><uuid></uuid><mensaje>' . 'Error al timbrar XML' . '</mensaje></respuesta>';*/
        }
        return $response;
    }

    function GenerarFacturaElectronicaNominaTimbre($formData) {
        $response = new stdClass();
        try {
            configuraServicio('GenerarFacturaElectronicaNomina');
            $formData = get_object_vars($formData);
            $sXml             = $formData['des_xml'];
            $sNumEmpresa      = $formData['num_empresa'];
            $sRfc             = $formData['rfc_empresa'];
            $sEmpleado        = $formData['idu_empleado'];
            $sRfcEmpleado     = $formData['rfc_empleado'];
            $sFecNomina       = $formData['fec_nomina'];
            $sNumSemana       = $formData['num_semana'];
            $sNumObra         = $formData['num_obra'];
            $sEmpleadoGenera  = $formData['num_empleadogenera'];
            $sClvTipoTimbrado = $formData['clv_tipotimbrado'];
            $sNumControl      = $formData['num_control'];
            $sNumIdentKey     = $formData['num_ident_key'];
            $sConexionNomina  = $formData['des_conexion'];
            $factura = new CBOGenerarFacturaElectronicaNomina();
            $response->return = $factura->generaFacturaTimbre($sXml, $sNumEmpresa, $sRfc, $sEmpleado, $sRfcEmpleado, $sFecNomina, $sNumSemana, $sNumObra, $sEmpleadoGenera, $sClvTipoTimbrado, $sNumControl, $sNumIdentKey, $sConexionNomina);
        }
        catch(exception $ex) {
            throw new SoapFault('1', $ex->getMessage());
        }
        return $response;
    }
?>
