<?php
    /********************************************
     * DEFINICIONES DE CONFIGURACION DE SERVICIO *
     ********************************************/

    date_default_timezone_set("America/Mazatlan");
    $GLOBALS['ODBC_CONNECTIONSTRING'] = array();
    $GLOBALS['PROJECTNAME'] = 'FacturacionElectronicaNomina';
    if(function_exists ('posix_getpid'))
        $GLOBALS['PROCPID'] = posix_getpid();
    else if(function_exists('rand'))
        $GLOBALS['PROCPID'] = rand(0, 999999);
    else
        $GLOBALS['PROCPID'] = 0;
    $GLOBALS['REALPATH'] = realpath('');
    if(strpos($GLOBALS['REALPATH'], '\\', 0))
        $GLOBALS['DIRSLASH'] = '\\';
    else
        $GLOBALS['DIRSLASH'] = '/';
    $GLOBALS['WS_LOGFILE'] = $GLOBALS['PROJECTNAME'];
    $GLOBALS['WS_LOGPATH'] = $GLOBALS['REALPATH'] . $GLOBALS['DIRSLASH'] . 'files' . $GLOBALS['DIRSLASH'] . 'log';
    $GLOBALS['WS_METHODS'] = array();
    $GLOBALS['WS_OP'] = $_SERVER['QUERY_STRING'];
    $GLOBALS['WS_URL'] = 'http://' . $_SERVER['HTTP_HOST'] . dirname($_SERVER['PHP_SELF']);
    if(strpos($GLOBALS['WS_URL'], '\\', 0))
        $GLOBALS['WS_URL'] = str_replace('\\', '/', $GLOBALS['WS_URL']);
    $GLOBALS['WS_TARGETNAMESPACE'] = 'http://facturacionelectronica.coppel.com';
    $GLOBALS['WS_LOCATION'] = $GLOBALS['WS_URL'] . '/' . $GLOBALS['PROJECTNAME'] . '.php';

    /****************************
     * DEFINICION DE METODOS WEB *
     ****************************/

        $GLOBALS['WS_METHODS'][] = array('MethodName' => 'BuscarFacturaElectronicaNomina',
            'MethodDoc' => 'Metodo para la cancelacion de facturas electronicas de nomina',
            'RequestParams' => array(
                array('Name' => 'idu_empleado'  , 'Type' => 'string'),
                array('Name' => 'fec_nomina'    , 'Type' => 'string')),
            'ResponseParams' => array(
                array('Name' => 'estado'    , 'Type' => 'string'), 
                array('Name' => 'mensaje'   , 'Type' => 'string'),
                array('Name' => 'xml'       , 'Type' => 'string'),
                array('Name' => 'qr'        , 'Type' => 'string')));

        $GLOBALS['WS_METHODS'][] = array('MethodName' => 'CancelarFacturaElectronicaNomina',
            'MethodDoc' => 'Metodo para la cancelacion de facturas electronicas de nomina',
            'RequestParams' => array(
                array('Name' => 'sUUID'              , 'Type' => 'string'),
                array('Name' => 'sEmpleadoCancelador', 'Type' => 'string')),
            'ResponseParams' => array(array('Name' => 'return', 'Type' => 'string'))); 

        $GLOBALS['WS_METHODS'][] = array('MethodName' => 'CancelarFacturaElectronicaNominaTimbre',
            'MethodDoc' => 'Metodo para la cancelacion de facturas electronicas de nomina y su guardado en la base de datos de la nomina',
            'RequestParams' => array(
                array('Name' => 'sUUID'              , 'Type' => 'string'),
                array('Name' => 'sEmpleadoCancelador', 'Type' => 'string'),
                array('Name' => 'num_empresa'        , 'Type' => 'string'),
                array('Name' => 'idu_empleado'       , 'Type' => 'string'),
                array('Name' => 'rfc_empleado'       , 'Type' => 'string'),
                array('Name' => 'fec_nomina'         , 'Type' => 'string'),
                array('Name' => 'num_semana'         , 'Type' => 'string'),
                array('Name' => 'num_obra'           , 'Type' => 'string'),
                array('Name' => 'clv_tipotimbrado'   , 'Type' => 'string'),
                array('Name' => 'num_control'        , 'Type' => 'string'),
                array('Name' => 'num_ident_key'      , 'Type' => 'string'),
                array('Name' => 'des_conexion'       , 'Type' => 'string')),
            'ResponseParams' => array(array('Name' => 'return', 'Type' => 'string'))); 

        $GLOBALS['WS_METHODS'][] = array('MethodName' => 'CancelarFacturaElectronicaNominaConXML',
            'MethodDoc' => 'Metodo para la cancelacion de facturas electronicas de nomina y su guardado en la base de datos de la nomina por medio de un XML.',
            'RequestParams' => array(
                array('Name' => 'des_uuid'           , 'Type' => 'string'),
                array('Name' => 'num_empleadocancela', 'Type' => 'string'),
                array('Name' => 'num_empresa'        , 'Type' => 'string'),
                array('Name' => 'idu_empleado'       , 'Type' => 'string'),
                array('Name' => 'rfc_empleado'       , 'Type' => 'string'),
                array('Name' => 'fec_nomina'         , 'Type' => 'string'),
                array('Name' => 'num_semana'         , 'Type' => 'string'),
                array('Name' => 'num_obra'           , 'Type' => 'string'),
                array('Name' => 'clv_tipotimbrado'   , 'Type' => 'string'),
                array('Name' => 'num_control'        , 'Type' => 'string'),
                array('Name' => 'num_ident_key'      , 'Type' => 'string'),
                array('Name' => 'des_conexion'       , 'Type' => 'string'),
                array('Name' => 'des_xml'            , 'Type' => 'string')),
            'ResponseParams' => array(array('Name' => 'return', 'Type' => 'string'))); 
        
        $GLOBALS['WS_METHODS'][] = array('MethodName' => 'GenerarFacturaElectronicaNomina',
            'MethodDoc' => 'Metodo para la generacion de facturas electronicas de nomina',
            'RequestParams' => array(
                array('Name' => 'xml'               , 'Type' => 'string'),
                array('Name' => 'rfc'               , 'Type' => 'string'),
                array('Name' => 'idu_empleado'      , 'Type' => 'string'),
                array('Name' => 'fec_nomina'        , 'Type' => 'string'),
                array('Name' => 'num_empleadogenera', 'Type' => 'string')),
            'ResponseParams' => array(array('Name' => 'return', 'Type' => 'string')));

        $GLOBALS['WS_METHODS'][] = array('MethodName' => 'GenerarFacturaElectronicaNominaTimbre',
            'MethodDoc' => 'Metodo para la generacion de facturas electronicas de nomina y su guardado en la base de datos de la nomina',
            'RequestParams' => array(
                array('Name' => 'des_xml'           , 'Type' => 'string'),
                array('Name' => 'num_empresa'       , 'Type' => 'string'),
                array('Name' => 'rfc_empresa'       , 'Type' => 'string'),
                array('Name' => 'idu_empleado'      , 'Type' => 'string'),
                array('Name' => 'rfc_empleado'      , 'Type' => 'string'),
                array('Name' => 'fec_nomina'        , 'Type' => 'string'),
                array('Name' => 'num_semana'        , 'Type' => 'string'),
                array('Name' => 'num_obra'          , 'Type' => 'string'),
                array('Name' => 'num_empleadogenera', 'Type' => 'string'),
                array('Name' => 'clv_tipotimbrado'  , 'Type' => 'string'),
                array('Name' => 'num_control'       , 'Type' => 'string'),
                array('Name' => 'num_ident_key'     , 'Type' => 'string'),
                array('Name' => 'des_conexion'      , 'Type' => 'string')),
            'ResponseParams' => array(array('Name' => 'return', 'Type' => 'string')));

    /*****************************************
     * DEFINICIONES AGREGADAS POR EL USUARIO *
     *****************************************/

    /******
     * Descomentar la variable a usar y comentar las otras dos, para obtener la conexion a la base de datos de la facturacion electronica.
     * En caso de usar otro servidor o credenciales de acceso es posible modificarlos (a excepcion de la cadena de produccion)
     */
    //produccion
        $GLOBALS['ODBC_CONNECTIONSTRING']['FACTURACIONELECTRONICA'] = 'DRIVER=PostgreSQL;SERVER=factelectronica.coppel.com;UID=sysfacturaelectronicaadmin;PWD=9c91e61f775f3564e08abb2bffa0dde7;DATABASE=facturacionelectronica';
    //desarrollo
        //$GLOBALS['ODBC_CONNECTIONSTRING']['FACTURACIONELECTRONICA'] = 'DRIVER=PostgreSQL;SERVER=10.44.15.127;UID=sysfacturaelectronicaadmin;PWD=9c91e61f775f3564e08abb2bffa0dde7;DATABASE=facturacionelectronica';
    //tester
        //$GLOBALS['ODBC_CONNECTIONSTRING']['FACTURACIONELECTRONICA'] = 'DRIVER=PostgreSQL;SERVER=10.44.172.23;UID=systesters;PWD=testers;DATABASE=facturacionelectronica';

    $GLOBALS['ODBC_CONNECTIONSTRING']['NOMINA'] = '';
    
    $GLOBALS['WS_XSLTPATH'] = $GLOBALS['REALPATH'] . $GLOBALS['DIRSLASH'] . 'files' . $GLOBALS['DIRSLASH'] . 'xslt';
    $GLOBALS['PAC_TIMBRADO_SOLUCIONFACTIBLE']   = 1;
    $GLOBALS['PAC_TIMBRADO_DIVERZA']            = 2;
    $GLOBALS['PAC_TIMBRADO_DETECNO']            = 3;
    $GLOBALS['PAC_TIMBRADO_SMARTERWEB']         = 4;

    /***** Valores $GLOBALS['OPC_SERVIDOR_DETECNO']:
     * 0 = Ambiente de produccion
     * 1 = Ambiente de pruebas o desarrollo
     */
    $GLOBALS['OPC_SERVIDOR_DETECNO']    = 0;
    
    /***** Valores $GLOBALS['OPC_GRABAR_DEBUG']:
     * 0 = No dejar el archivo con el debug de la ejecucion
     * 1 = Grabar el archivo de debug de la aplicacion
     */
    $GLOBALS['OPC_GRABAR_DEBUG']= '1';

    $GLOBALS['NUM_EMPLEADO']    = '';
    $GLOBALS['WS_DEBUGFILE']    = $GLOBALS['PROJECTNAME'];
    $GLOBALS['WS_DEBUGPATH']    = $GLOBALS['REALPATH']. $GLOBALS['DIRSLASH'] . 'files' . $GLOBALS['DIRSLASH'] . 'debug';
        
    $GLOBALS['URL_DETECNO_PRUEBAS']     = 'test.timbra.mx';
    $GLOBALS['URL_DETECNO_PRODUCCION']  = 'www.timbra.mx';
    
    $GLOBALS['URL_ENVELOPE_DETECNO_PRUEBAS']    = 'http://www.w3.org/2003/05/soap-envelope';
    $GLOBALS['URL_ENVELOPE_DETECNO_PRODUCCION'] = 'http://www.w3.org/2003/05/soap-envelope';
?>
