<?php
	require_once 'accesodatos/OdbcConnection.php';
	require_once 'accesodatos/CDAMovtoTimbrado.php';
	
	class CBOBuscarFacturaElectronicaNomina extends CGenerales {
		private $sEmpleado;
		private $sFecNomina;
	
		function __construct() {
			$this->sEmpleado = NULL;
			$this->sFecNomina = NULL;
		}
	
		function __destruct() {
			$this->sEmpleado = NULL;
			$this->sFecNomina = NULL;
		}
	
		function buscarFactura($sEmpleado, $sFecNomina) {
			$sMensajeRespuesta = 'OK';
			$sXmlTimbrado = '';
			$estado = '1';
			$sQr = '';
			$bInicia = FALSE;
			$response = new stdClass();
			try {
				$this->GrabaDebug("INICIA METODO WEB BUSCARFACTURAELECTRONICANOMINA");
				$bInicia = TRUE;
				$this->sEmpleado = $sEmpleado;
				$this->sFecNomina = $sFecNomina;
				$this->GrabaDebug("PARAMETROS RECIBIDOS");
				$this->GrabaDebug(sprintf("EMPLEADO.......... [ %s ]", $this->sEmpleado));
				$this->GrabaDebug(sprintf("FECHA NOMINA...... [ %s ]", $this->sFecNomina));
				if($this->esCadenaValida($this->sEmpleado) && $this->esCadenaValida($this->sFecNomina)) {
				  	$hMovtoTimbrado = new CDAMovtoTimbrado();
					$hDatosFactura = $hMovtoTimbrado->buscarMovtoEmpleado($this->sEmpleado, $this->sFecNomina);
					if($hDatosFactura == NULL) {
						$sMensajeRespuesta = 'No se encontro factura';
					}
					else {
						$estado = '0';
						$sXmlTimbrado = $hDatosFactura->xmlTimbrado;
						$sQr = $hDatosFactura->qr;
					}
				}
				else {
					$sMensajeRespuesta = "Uno o mas de los parametros recibidos es invalido";
				}
				$this->GrabaDebug(sprintf("BUSQUEDA DE FACTURA... [ %s - %s ] ... [ %s ]", $sEmpleado, $sFecNomina, $sMensajeRespuesta));
				$this->GrabaDebug("TERMINA METODO WEB BUSCARFACTURAELECTRONICANOMINA");
			}
			catch(exception $ex) {
				$sEstadoRespuesta = "1";
				$sMensajeRespuesta = $ex->getMessage();
				if($bInicia) {
					$this->GrabaLog(sprintf('ERROR EN buscarFactura... [ %s - %s ] ... [ %s ]', $sEmpleado, $sFecNomina, $sMensajeRespuesta));
					$this->GrabaDebug(sprintf('ERROR EN buscarFactura... [ %s - %s ] ... [ %s ]', $sEmpleado, $sFecNomina, $sMensajeRespuesta));
					$this->GrabaDebug("TERMINA METODO WEB BUSCARFACTURAELECTRONICANOMINA");
				}
			}
			$response->estado = $estado;
			$response->mensaje = $sMensajeRespuesta;
			$response->xml = $sXmlTimbrado;
			$response->qr = $sQr;
			return $response;
		}
	
		function validaXml($sXML) {
			$doc = DOMDocument();
			$doc->loadXML($sXML);
		}
	}
?>
