<?php
class CComprobanteDiverza extends CComprobante {
	function __construct() {
	}

	function __destruct() {
	}

	function cancelar($hConfWS, $sUuid) {
		$iEstado = 1;
		$sMensaje = 'Error interno del sistema.';
		//$this->GrabaLog('CONECTANDO prueba');
		
		//-------------
		include_once 'files/wsdl/diverza/Schemas/Cancelacion.php';
		//------------------------------
		$wsdl_location = "files/wsdl/diverza/Schemas/Cancelacion.wsdl";
		$cert_file = "files/wsdl/diverza/Auth_certificates/COP920428Q20.pem";
		$cert_pass = "COP920428Q20";
		
		
		$hResponse = new stdClass();
		try {
			$this->GrabaLog('CONECTANDO AL SERVICIO WEB DE CANCELACION');
			
			$hOptions = array();
			if($hConfWS->opc_proxy == '1') {
				$hOptions['proxy_host'] = $hConfWS->num_proxyhost;
				$hOptions['proxy_port'] = $hConfWS->num_port;
			}
			$this->GrabaLog(sprintf('URL [ %s ]', $hConfWS->nom_url));
			
			
			//------------------------------
			
			
			
			try {  
				$x = @new BuzonFiscalCorporativoWS($wsdl_location, array('trace' => 1, 'local_cert' => $cert_file, 'passphrase' => $cert_pass, 'encoding' => 'utf-8', 'proxy_host' => '10.33.128.80', 'proxy_port' => '8080' ));
			} catch (Exception $e) {  
				$this->GrabaLog("ERROR: ".$e->getMessage());
				//echo $e->getMessage(); 
			}
			
			//que regrese el rfc del receptor
			$xml_timbrado=$hConfWS->xml_timbrado;
			
			$posicion=0;
			$posicion=strpos($xml_timbrado,"cfdi:Receptor rfc=");
			
			$rfc_receptor=substr($xml_timbrado, $posicion+19, 13);
			//$uuid_mayuscula=strtoupper($sUuid);
			
			$cancelaResponse = new ResponseCancelaCFDiType;
			$cancelaRequest = new RequestCancelaCFDiType;
			
			/*
			$cancelaRequest->rfcEmisor =$hConfWS->rfc_emisor;
			$cancelaRequest->rfcReceptor = $rfc_receptor;
			$cancelaRequest->uuid = $sUuid;
			*/
			$cancelaRequest->rfcEmisor ="COP920428Q20";
			$cancelaRequest->rfcReceptor = "VADB700303GX3";
			$cancelaRequest->uuid = "c1345b9d-8d4b-4acf-be68-0f7da4d85b46";
			//$cancelaRequest->uuid = $uuid_mayuscula;
			
			
			//$this->GrabaLog(sprintf("XML TIMBRADO......... [ %s ]", $xml_timbrado));
			
			
			$this->GrabaLog(sprintf("UUID......... [ %s ]", $cancelaRequest->uuid));
			$this->GrabaLog(sprintf("RFC EMISOR......... [ %s ]", $cancelaRequest->rfcEmisor));
			$this->GrabaLog(sprintf("RFC RECEPTOR......... [ %s ]", $cancelaRequest->rfcReceptor));
			
			
			//echo "Cancelaci�n Inicio: ".toTimestamp(microtime(true) * 1000)."<br>";
			$this->GrabaLog('ENVIANDO SOLICITUD'); 
			// Aqu� sucede la magia DE LA CANCELACION
			try {
				//var_dump($cancelaRequest);
				$time_start = round(microtime(true) * 1000);
				$cancelaResponse = $x->cancelaCFDi($cancelaRequest);
				$time_end = round(microtime(true) * 1000);
			
			} catch (Exception $e){  
				$this->GrabaLog("ERROR: ".$e->getMessage());
				$sMensaje=$e->getMessage();
			}
			
			$this->GrabaLog(sprintf("getLastRequest [ %s ]", $x->__getLastRequest()));
			$this->GrabaLog(sprintf("getLastResponse......... [ %s ]", $x->__getLastResponse()));
			
			
			$time = $time_end - $time_start;
			
			/*
			$cliente = new SoapClient($hConfWS->nom_url, $hOptions);
			$time_start = round(microtime(true) * 1000);
			$this->GrabaLog('ENVIANDO SOLICITUD');
			$response = $cliente->cancelarBase64(array("usuario"=>$hConfWS->nom_usuario, "password"=>$hConfWS->nom_password, "uuids"=>$sUuid, "derCertCSDBase64"=>$hConfWS->arc_empresacert, "derKeyCSDBase64"=>$hConfWS->arc_empresakey, "contrasenaCSD"=>""));
			$time_end = round(microtime(true) * 1000);
			$time = $time_end - $time_start;
			*/
			
			$this->GrabaLog(sprintf("canceled......... [ %s ]", $cancelaResponse->canceled));
			$this->GrabaLog(sprintf("fecha......... [ %s ]", $cancelaResponse->fecha));
			$this->GrabaLog(sprintf("mensaje......... [ %s ]", $cancelaResponse->Result->Message->code));			
			
			
			
			$this->GrabaLog(sprintf("RESPUESTA MS......... [ %s ]", $time));
			$this->GrabaLog("DATOS OBTENIDOS DE PAC");
			$this->GrabaLog(sprintf("PAC STATUS......... [ %s ]", $cancelaResponse->return->status));
			$this->GrabaLog(sprintf("PAC MENSAJE........ [ %s ]", $cancelaResponse->return->mensaje));
			$this->GrabaLog(sprintf("CFDI STATUS........ [ %s ]", $cancelaResponse->return->resultados->status));
			$this->GrabaLog(sprintf("CFDI MENSAJE....... [ %s ]", $cancelaResponse->return->resultados->mensaje));
			$this->GrabaLog(sprintf("CFDI STATUS UUID... [ %s ]", $cancelaResponse->return->resultados->statusUUID));
			$this->GrabaLog(sprintf("CFDI UUID.......... [ %s ]", $cancelaResponse->return->resultados->uuid));
			if($cancelaResponse->return->status != 200)
				$sMensaje = $cancelaResponse->return->mensaje;
			else if($cancelaResponse->return->resultados->statusUUID != 201 && $cancelaResponse->return->resultados->statusUUID != 202) {
				$sMensaje = $cancelaResponse->return->resultados->mensaje;
			}
			else {
				$iEstado = 0;
				$sMensaje = 'OK';
				$hResponse->respuestaPac = $cancelaResponse->return->resultados->mensaje;
			}
		}
		catch(exception $ex) {
			$iEstado = 2;
			$sMensaje = $ex->getMessage();
		}
		$this->GrabaLog(sprintf("CONEXION WS CANCELACION [ %s ]", $sMensaje));
		if($iEstado == 2)
			$sMensaje = 'Error interno del sistema.';
		$hResponse->estado = $iEstado;
		$hResponse->mensaje = $sMensaje;
		return $hResponse;
	}

	function timbrar($hConfWS, $sXml) {		
		$sCadenaOriginal = '';
		$iEstado = 1;
		$sMensaje = 'Error interno del sistema.';
		$sSello = '';
		$hResponse = new stdClass();
		$hProcesa = NULL;
		
		
		try {
			
			$sXml = $this->complementaXMLDIVERZA($sXml, $hConfWS->arc_xmldomiciliofiscal, $hConfWS->fec_xml);
			$hProcesa = $this->procesaXmlComprobante($sXml);
			//$this->GrabaLog(sprintf("xml complemento....... [ %s ]", $sXml));
			if($hProcesa->estado != 0) {
				$sMensaje = $hProcesa->mensaje;
			}
			else {
				//$this->GrabaLog(sprintf("xml complemento2....... [ %s ]", $this->generaCadenaOriginal($sXml)));
				if(($sCadenaOriginal = $this->generaCadenaOriginal($sXml)) == NULL)
					$sMensaje = 'Error al generar cadena original.';
				else {
					//generaSelloDiverza
					//if(($sSello = $this->generaSello($hConfWS->arc_empresakey, $sCadenaOriginal,$hConfWS->nom_certificado)) == NULL) {
					if(($sSello = $this->generaSelloDiverza($hConfWS->arc_empresakey, $sCadenaOriginal,$hConfWS->nom_certificado)) == NULL) {
						$sMensaje = 'Error al generar sello.';
					}
					else {
						$sXml = $this->agregarcfdiNominaDIVERZA($sXml);
						$sXml = $this->AgregaURLFiscal($sXml);
						//$this->GrabaLog(sprintf("xml complemento6....... [ %s ]", $sXml));
					
						$sXml = $this->agregarCertificadoYSelloDIVERZA($sXml, $hConfWS->arc_empresacert, $sSello, $hConfWS->nom_certificado);
						//$this->GrabaLog(sprintf("xml complemento5....... [ %s ]", $sXml));
						
						
						
						$hDatosPac = $this->timbrarXML($hConfWS, $hProcesa->comprobante, $sXml);
						

						
						if($hDatosPac->estado != 0)
							$sMensaje = $hDatosPac->mensaje;
						else {
							$sXmlTimbreFiscal = '';
							$sXmlTimbreFiscal = $this->generaNodoTimbreFiscal($hDatosPac);
							if($sXmlTimbreFiscal == NULL)
								$sMensaje = 'Error al generar cadena original timbre fiscal.';
							else if(($hDatosPac->cadenaOriginal = $this->generaCadenaOriginaltimbreFiscal($sXmlTimbreFiscal)) == NULL)
								$sMensaje = 'Error al generar cadena original timbre fiscal.';
							else {
								$iEstado = 0;
								$sMensaje = 'OK';
								$hDatosPac->qr = '';
								$hDatosPac->xmlTimbrado = $this->complementaXMLtimbreFiscal($sXml, $sXmlTimbreFiscal);
								$hDatosPac->total = intval(floatval($hProcesa->comprobante->total) * 100);
								$hDatosPac->subtotal = intval(floatval($hProcesa->comprobante->subTotal) * 100);
								$hDatosPac->descuento = intval(floatval($hProcesa->comprobante->descuento) * 100) + intval(floatval($hProcesa->comprobante->Impuestos->Retenciones->Retencion->importe) * 100);
								$hResponse->datosPac = $hDatosPac;
							}
						}
					}
				}
			}
		}
		catch(exception $ex) {
			$iEstado = 2;
			$sMensaje = $ex->getMessage();
		}
				
		$this->GrabaLog(sprintf("TIMBRADO....... [ %s ]", $sMensaje));
		if($iEstado == 2)
			$sMensaje = 'Error interno del sistema.';
		$hResponse->estado = $iEstado;
		$hResponse->mensaje = $sMensaje;
		return $hResponse;
	}
	
	private function timbrarXML($hConfWS, $hComprobante, $sXml) {
		$iEstado = 1;
		$sMensaje = 'Error interno del sistema.';
		$hResponse = new stdClass();
		
		//-------------
		include_once 'files/wsdl/diverza/Schemas/TimbradoCFDI.php';
		
	
		//
		try {
			$this->GrabaLog('CONECTANDO AL SERVICIO WEB DE TIMBRADO');
			$hOptions = array();
			if($hConfWS->opc_proxy == '1') {
				$hOptions['proxy_host'] = $hConfWS->num_proxyhost;
				$hOptions['proxy_port'] = $hConfWS->num_port;
			}
			
			$RequestTimbradoCFD = new stdClass();
			$RequestTimbradoCFD->Documento = new stdClass();
			$RequestTimbradoCFD->InfoBasica = new stdClass();
			$RequestTimbradoCFD->Documento->NombreArchivo = 'xml';
			$RequestTimbradoCFD->Documento->Tipo = 'xml';
			$RequestTimbradoCFD->Documento->Version = '3.2';
			$RequestTimbradoCFD->InfoBasica->Serie = 'HDS';
			//esta abajo
			$RequestTimbradoCFD->InfoBasica->RfcEmisor = $hComprobante->Emisor->rfc;
			
			$this->GrabaLog($RequestTimbradoCFD->InfoBasica->RfcEmisor);
			//esta abajo
			$RequestTimbradoCFD->InfoBasica->RfcReceptor = $hComprobante->Receptor->rfc;
			$this->GrabaLog($RequestTimbradoCFD->InfoBasica->RfcReceptor);
			
			$this->GrabaLog(sprintf("XML ENVIO.............. [ %s ]", $sXml));
			
			//------------------------------
			$wsdl_location = "files/wsdl/diverza/Schemas/TimbradoCFDI.wsdl";
			$cert_file = "files/wsdl/diverza/Auth_certificates/COP920428Q20.pem";
			$cert_pass = "COP920428Q20";
			
						
			try {  
				$x = @new TimbradoCFDI($wsdl_location, array('trace' => 1, 'local_cert' => $cert_file, 'passphrase' => $cert_pass, 'encoding' => 'utf-8', 'proxy_host' => '10.33.128.80', 'proxy_port' => '8080' ));
			} catch (Exception $e) {  
				$this->GrabaLog("ERROR: ".$e->getMessage());
				//echo $e->getMessage(); 
			}
			
			// Crea el objeto que enviar� toda la informaci�n a timbrar            
			$temp_var = new RequestTimbradoCFDType;
			
			$temp_var->Documento->Archivo = $sXml;
			
			$temp_var->Documento->Tipo = "XML";
			$temp_var->Documento->version = "3.2";
			
			//Extrae el RFC del emisor y lo coloca en InfoBasica
			$temp_var->InfoBasica->RfcEmisor = $hComprobante->Emisor->rfc;
			
			//Extrae el RFC del Receptor y lo coloca en InfoBasica
			$temp_var->InfoBasica->RfcReceptor = $hComprobante->Receptor->rfc;
			
			$this->GrabaLog('ENVIANDO SOLICITUD');
			// Aqui sucede la magia del timbrado
			try {
				$time_start = round(microtime(true) * 1000);
				$response = $x->timbradoCFD ($temp_var);
				$time_end = round(microtime(true) * 1000);
			} catch (Exception $e){  
				$this->GrabaLog("ERROR: ".$e->getMessage());
				$sMensaje=$e->getMessage();
			}
			//-----------------------------------
			$time = $time_end - $time_start;
			
			$this->GrabaLog(sprintf("RESPUESTA MS......... [ %s ]", $time));
			$this->GrabaLog("DATOS OBTENIDOS DE PAC");
			$this->GrabaLog(sprintf("VERSION TFD....... [ %s ]", $response->version));
			$this->GrabaLog(sprintf("UUID.............. [ %s ]", $response->UUID));
			$this->GrabaLog(sprintf("FECHA TIMBRADO.... [ %s ]", $response->FechaTimbrado));
			$this->GrabaLog(sprintf("SELLO CFD......... [ %s ]", $response->selloCFD));
			$this->GrabaLog(sprintf("CERTIFICADO SAT... [ %s ]", $response->noCertificadoSAT));
			$this->GrabaLog(sprintf("SELLO SAT......... [ %s ]", $response->selloSAT));
			
			$iEstado = 0;
			$sMensaje = 'OK';
			$hResponse->certificadoSAT = $response->noCertificadoSAT;
			$hResponse->fechatimbrado = $response->FechaTimbrado;
			$hResponse->selloSAT = $response->selloSAT;
			$hResponse->uuid = $response->UUID;
			$hResponse->versionTFD = $response->version;
			$hResponse->selloCFD = $response->selloCFD;
			
			
		}
		catch(exception $ex) {
			$iEstado = 2;
			$sMensaje = $ex->getMessage();
		}
		$this->GrabaLog(sprintf("CONEXION WS TIMBRADO [ %s ]", $sMensaje));
		if($iEstado == 2)
			$sMensaje = 'Error interno del sistema.';
		$hResponse->estado = $iEstado;
		$hResponse->mensaje = $sMensaje;
		return $hResponse;
	}
}
?>
