CREATE OR REPLACE FUNCTION fun_timbradofacturaelectronicanominaresponse01(IN integer, IN integer, IN integer, IN integer, IN text, IN text, IN character varying, IN text, IN text, IN character varying, IN character varying, IN character varying, IN integer)
  RETURNS TABLE(idu_estado integer, des_mensaje character varying) AS
$BODY$
  DECLARE
    /*
        NOMBRE              : VICTOR VIZCARRA #97295493
        BD                  : facturacionelectronica POSGRESQL
        FECHA               : 08/01/2018
        SERVIDOR PRUEBAS    : 10.44.15.182
        SERVIDOR PRODUCCION : 10.44.1.130
        DESCRIPCION         : Almacena los comprobantes de cualquier movimiento que han sido timbrado con éxito. 
        MODULO              : FACTURACIONELECTRONICANOMINA.ZIP
        RUTA                : svn://10.44.15.239/sysx/administracion/PROYECTOS WEB/FacturacionElectronicaNomina/FacturacionElectronicaNomina/scripts
    */
  
    iFolioMovto     ALIAS FOR $1;
    iTotal          ALIAS FOR $2;
    iSubTotal       ALIAS FOR $3;
    iDescuento      ALIAS FOR $4;
    cCadenaOriginal ALIAS FOR $5;
    cCertificadoSAT ALIAS FOR $6;
    cXMLTimbrado    ALIAS FOR $7;
    cFecTimbrado    ALIAS FOR $8;
    cQrCode         ALIAS FOR $9;
    cSelloSAT       ALIAS FOR $10;
    cFolUuid        ALIAS FOR $11;
    cVersionTFD     ALIAS FOR $12;
    iTipoNomina     ALIAS FOR $13;
    cRFC                character varying(13);
    iNumEmpleado        integer;
    iNumEmpleadoGenera  integer;
    dtFecNomina         timestamp without time zone;
    cXMLNommina         text;
    iNumPacCfdi         smallint;
    iEstatusFactura     smallint;
    iEstado             integer;
    cMensaje            varchar(1024);
    iNumControl         bigint;
    iNumIdentKey        bigint;
    dtFechaMovto        timestamp without time zone;
BEGIN
    iEstado:= 1;
    cMensaje:= 'Error interno';
    dtFechaMovto:= now();

    SELECT clv_rfcempresa, num_empleado, num_empleadogenera, fec_nomina, arc_xmlnomina, num_paccfdi, num_control, num_ident_key
    INTO cRFC, iNumEmpleado, iNumEmpleadoGenera, dtFecNomina, cXMLNommina, iNumPacCfdi, iNumControl, iNumIdentKey
    FROM mov_facturasnominarequest 
    WHERE idu_foliomovto = iFolioMovto;
    
    IF FOUND THEN
        SELECT opc_estatus INTO iEstatusFactura FROM mov_facturasnomina 
        WHERE num_empleado = iNumEmpleado AND fec_nomina = dtFecNomina AND clv_rfcempresa = cRFC 
        AND clv_tiponomina = iTipoNomina AND num_control = iNumControl AND num_ident_key = iNumIdentKey;

        IF FOUND AND iEstatusFactura = 1 THEN 
            cMensaje:= 'Ya existe una factura activa para el empleado con la fecha de nomina ' || dtFecNomina::date;
        ELSE
            INSERT INTO mov_facturasnomina(idu_foliomovto, clv_rfcempresa, num_empleado, num_empleadogenera, fec_nomina, arc_xmlnomina,
                num_paccfdi, imp_total, imp_subtotal, imp_descuento, arc_cfdicadenaoriginal, arc_certificadosat, arc_xmltimbrado,
                fec_cfditimbrado, arc_qrcode, arc_sellosat, fol_uuid, clv_versiontfd, fec_movto, opc_estatus, clv_tiponomina, num_control, num_ident_key)
            SELECT iFolioMovto, cRFC, iNumEmpleado, iNumEmpleadoGenera, dtFecNomina, cXMLNommina, iNumPacCfdi, iTotal, iSubTotal, 
                iDescuento, cCadenaOriginal, cCertificadoSAT, cXMLTimbrado, cFecTimbrado, cQrCode, cSelloSAT, cFolUuid, cVersionTFD, 
                now(), 1, iTipoNomina, iNumControl, iNumIdentKey;

            iEstado:= 0;
            cMensaje:= 'Operacion exitosa';
        END IF;
    ELSE
        cMensaje:= 'No existe una solicitud previa de timbrado';
    END IF;

    RETURN QUERY SELECT iEstado, cMensaje;
END;
$BODY$
  LANGUAGE plpgsql VOLATILE SECURITY DEFINER;
 
GRANT EXECUTE ON FUNCTION fun_timbradofacturaelectronicanominaresponse01(integer, integer, integer, integer, text, text, character varying, text, text, character varying, character varying, character varying, integer) TO sysfacturaelectronicaadmin;

COMMENT ON FUNCTION fun_timbradofacturaelectronicanominaresponse01(integer, integer, integer, integer, text, text, character varying, text, text, character varying, character varying, character varying, integer) 
IS 'Almacena los comprobantes de cualquier movimiento que han sido timbrado con éxito..
  iFolioMovto = Folio interno de la factura,
  iTotal = Importe total de la facatura,
  iSubTotal = Corresponde al importe del subtotal de la factura,
  iDescuento = Descuento aplicado,
  cCadenaOriginal = Cadena original generada por el WS,
  cCertificadoSAT = Certificado expedido por el SAT,
  cXMLTimbrado = Contiene el XML timbrado,
  cFecTimbrado = Fecha de timbrado del movimiento,
  cQrCode = Código Qr,
  cSelloSAT = Sello Que retorna SAT una vez timbrado el XML ,
  cFolUuid = Folio único asignado una vez que se timbra con éxito,
  cVersionTFD = Corresponde a la versión del nodo TimbreFiscalDigital del XML,
  iTipoNomina = Tipo de nómina del colaborador,
  cRFC = RFC de la empresa';  