CREATE OR REPLACE FUNCTION fun_buscarfacturaelectronicanominaporempleado(IN integer, IN character varying)
  RETURNS TABLE(idu_estado integer, des_mensaje character varying, arc_xml text, arc_qr text) AS
$BODY$
  DECLARE
    iNumEmpleado ALIAS FOR $1;
    dtFecNomina ALIAS FOR $2;
    iEstado integer;
    cMensaje varchar(1024);
    cXmlTimbrado text;
    cQr text;
  BEGIN
    iEstado:= 0;
    cMensaje:= 'Operacion exitosa';
    cXmlTimbrado:= '';
    cQr:= '';
    SELECT arc_xmltimbrado, arc_qrcode INTO cXmlTimbrado, cQr FROM mov_facturasnomina WHERE num_empleado = iNumEmpleado AND fec_nomina = dtFecNomina::date;
    IF NOT FOUND THEN
      iEstado:= 1;
      cMensaje:= 'No existe la factura para el empleado con la fecha nomina recibida';
    END IF;
    RETURN QUERY SELECT iEstado, cMensaje, cXmlTimbrado, cQr;
  END;
$BODY$
  LANGUAGE plpgsql VOLATILE;
ALTER FUNCTION fun_buscarfacturaelectronicanominaporempleado(integer, character varying)
  OWNER TO sysfacturaelectronicaadmin;
