CREATE OR REPLACE FUNCTION fun_cancelafacturaelectronicanominarequest(IN character varying, IN integer)
  RETURNS TABLE(idu_estado integer, des_mensaje character varying, idu_folio integer, num_paccfdi integer, nom_url character varying, opc_proxy integer, num_proxyhost character varying, num_port integer, opc_credenciales integer, nom_usuario character varying, nom_password character varying, nom_certificado character varying, arc_empresacert text, arc_empresakey text, rfc_emisor character varying, xml_timbrado text) AS
$BODY$
  DECLARE
    cUuid ALIAS FOR $1;
    iNumEmpleadoCancela ALIAS FOR $2;
    iEstado integer;
    cMensaje varchar(1024);
    iFolioMovto integer;
    iEstatus smallint;
    cRFC varchar(13);
    iNumPacCfdi integer;
    cUrlWS varchar(512);
    iProxy integer;
    cIpProxy varchar(15);
    iPuerto integer;
    CNomCert varchar(64);
    cWSCert text;
    cWSKey text;
    iCredenciales integer;
    cUsuario varchar(128);
    cPassword varchar(256);
    dtFechaMovto timestamp without time zone;
    cXml_timbrado text;
  BEGIN
    iEstado:= 1;
    cMensaje:= 'Operacion exitosa';
    iFolioMovto:= 0;
    iEstatus:= 0;
    cRFC:= '';
    iNumPacCfdi:= 0;
    cUrlWS:= '';
    iProxy:= 0;
    cIpProxy:= '';
    iPuerto:= 0;
    CNomCert:= '';
    cWSCert:= '';
    cWSKey:= '';
    iCredenciales:= 0;
    cUsuario:= '';
    cPassword:= '';
    dtFechaMovto:= now();
    cXml_timbrado:='';
    SELECT a.idu_foliomovto, a.opc_estatus, a.clv_rfcempresa, a.num_paccfdi,a.arc_xmltimbrado INTO iFolioMovto, iEstatus, cRFC, iNumPacCfdi, cXml_timbrado FROM mov_facturasnomina a WHERE a.fol_uuid = cUuid;
    IF FOUND THEN
      IF iEstatus = 0 THEN
        iEstado:= 1;
        cMensaje:= 'La factura ya esta cancelada';
      ELSE
        SELECT b.nom_urlws, b.opc_requireproxy::integer, host(b.num_proxyhost), b.num_proxyport, b.opc_credenciales::integer, 
        b.nom_usuario, b.nom_password INTO cUrlWS, iProxy, cIpProxy, iPuerto, iCredenciales, cUsuario, cPassword
        FROM ctl_operacionesurlwspaccfdi a INNER JOIN cat_urlwspaccfdi b ON a.num_urlwspaccfdi = b.idu_urlwspaccfdi 
        WHERE a.num_paccfdi = iNumPacCfdi AND a.num_operacion = 2;
        IF FOUND THEN
          SELECT split_part(arc_cer, '.', 1), cve_llavepublica, cve_llaveprivada INTO CNomCert, cWSCert, cWSKey FROM cat_archivopem WHERE clv_rfcempresa = cRFC;
          IF FOUND THEN
            INSERT INTO mov_cancelacionfacturasnominarequest(idu_foliomovto, num_empleadocancela, fol_uuid, fec_movto)
            VALUES(iFolioMovto, iNumEmpleadoCancela, cUuid, dtFechaMovto);
            iEstado:= 0;
          ELSE
            cMensaje:= 'No esta registrado el certificado de la empresa';
          END IF;
        ELSE
          cMensaje:= 'El servicio web al que intenta conectarse no esta configurado';
        END IF;
      END IF;
    ELSE
      cMensaje:= 'El folio uuid no se encuentra registrado';
    END IF;
    IF iEstado <> 0 THEN
      iFolioMovto:= 0;
      iNumPacCfdi:= 0;
      cUrlWS:= '';
      iProxy:= 0;
      cIpProxy:= '';
      iPuerto:= 0;
      CNomCert:= '';
      cWSCert:= '';
      cWSKey:= '';
      iCredenciales:= 0;
      cUsuario:= '';
      cPassword:= '';
      cRFC:=0;
      cXml_timbrado:='';
    END IF;
    RETURN QUERY SELECT iEstado, cMensaje, iFolioMovto, iNumPacCfdi, cUrlWS, iProxy, cIpProxy, iPuerto, iCredenciales, cUsuario, cPassword, CNomCert, cWSCert, cWSKey,cRFC,cXml_timbrado;
  END;
$BODY$
  LANGUAGE plpgsql VOLATILE;
ALTER FUNCTION fun_cancelafacturaelectronicanominarequest(character varying, integer)
  OWNER TO sysfacturaelectronicaadmin;
