CREATE OR REPLACE FUNCTION fun_cancelafacturaelectronicanominaresponse(IN integer, IN text)
  RETURNS TABLE(idu_estado integer, des_mensaje character varying) AS
$BODY$
  DECLARE
    iFolioMovto ALIAS FOR $1;
    cRespuestaPac ALIAS FOR $2;
    iEstado integer;
    cMensaje varchar(1024);
    dtFechaMovto timestamp without time zone;
    iEmpleadoCancela integer;
    cUuid varchar(36);
    cRfc varchar(36);
    iTotal integer;
    iSubTotal integer;
    iDescuento integer;
    iEstatusFactura integer;
  BEGIN
    iEstado:= 1;
    cMensaje:= 'Error interno';
    dtFechaMovto:= now();
    SELECT num_empleadocancela, fol_uuid INTO iEmpleadoCancela, cUuid FROM mov_cancelacionfacturasnominarequest WHERE idu_foliomovto = iFolioMovto;
    IF FOUND THEN
      SELECT clv_rfcempresa, imp_total, imp_subtotal, imp_descuento, opc_estatus INTO cRfc, iTotal, iSubTotal, iDescuento, iEstatusFactura FROM mov_facturasnomina WHERE idu_foliomovto = iFolioMovto AND opc_estatus = 1;
      IF FOUND AND iEstatusFactura = 1 THEN 
        INSERT INTO mov_cancelacionfacturasnomina(idu_foliomovto, num_empleadocancela, clv_rfcempresa, fol_uuid, des_respuestapac, fec_movto, imp_total, imp_subtotal, imp_descuento)
        VALUES(iFolioMovto, iEmpleadoCancela, cRfc, cUuid, cRespuestaPac, dtFechaMovto, iTotal, iSubTotal, iDescuento);
        UPDATE mov_facturasnomina SET opc_estatus = 0 WHERE idu_foliomovto = iFolioMovto;
        iEstado:= 0;
        cMensaje:= 'Operacion exitosa';
      ELSE
        cMensaje:= 'La factura no existe o esta cancelada';
      END IF;
    ELSE
      cMensaje:= 'No existe una solicitud previa de cancelacion';
    END IF;
    RETURN QUERY SELECT iEstado, cMensaje;
  END;
$BODY$
  LANGUAGE plpgsql VOLATILE;
ALTER FUNCTION fun_cancelafacturaelectronicanominaresponse(integer, text)
  OWNER TO sysfacturaelectronicaadmin;
