CREATE OR REPLACE FUNCTION fun_timbradofacturaelectronicanominaresponse(IN integer, IN integer, IN integer, IN integer, IN text, IN text, IN character varying, IN text, IN text, IN character varying, IN character varying, IN character varying)
  RETURNS TABLE(idu_estado integer, des_mensaje character varying) AS
$BODY$
  DECLARE
    iFolioMovto ALIAS FOR $1;
    iTotal ALIAS FOR $2;
    iSubTotal ALIAS FOR $3;
    iDescuento ALIAS FOR $4;
    cCadenaOriginal ALIAS FOR $5;
    cCertificadoSAT ALIAS FOR $6;
    cXMLTimbrado ALIAS FOR $7;
    cFecTimbrado ALIAS FOR $8;
    cQrCode ALIAS FOR $9;
    cSelloSAT ALIAS FOR $10;
    cFolUuid ALIAS FOR $11;
    cVersionTFD ALIAS FOR $12;
    cRFC character varying(13);
    iNumEmpleado integer;
    iNumEmpleadoGenera integer;
    dtFecNomina timestamp without time zone;
    cXMLNommina text;
    iNumPacCfdi smallint;
    iEstatusFactura smallint;
    iEstado integer;
    cMensaje varchar(1024);
    dtFechaMovto timestamp without time zone;
  BEGIN
    iEstado:= 1;
    cMensaje:= 'Error interno';
    dtFechaMovto:= now();
    SELECT clv_rfcempresa, num_empleado, num_empleadogenera, fec_nomina, arc_xmlnomina, num_paccfdi 
    INTO cRFC, iNumEmpleado, iNumEmpleadoGenera, dtFecNomina, cXMLNommina, iNumPacCfdi FROM mov_facturasnominarequest WHERE idu_foliomovto = iFolioMovto;
    IF FOUND THEN
      SELECT opc_estatus INTO iEstatusFactura FROM mov_facturasnomina WHERE num_empleado = iNumEmpleado AND fec_nomina = dtFecNomina;
      IF FOUND AND iEstatusFactura = 1 THEN 
        cMensaje:= 'Ya existe una factura activa para el empleado con la fecha de nomina ' || dtFecNomina::date;
      ELSE
        INSERT INTO mov_facturasnomina
        SELECT iFolioMovto, cRFC, iNumEmpleado, iNumEmpleadoGenera, dtFecNomina, cXMLNommina, iNumPacCfdi, iTotal, iSubTotal, iDescuento, cCadenaOriginal, cCertificadoSAT, cXMLTimbrado, cFecTimbrado, cQrCode, cSelloSAT, cFolUuid, cVersionTFD, now(), 1;
        iEstado:= 0;
        cMensaje:= 'Operacion exitosa';
      END IF;
    ELSE
      cMensaje:= 'No existe una solicitud previa de timbrado';
    END IF;
    RETURN QUERY SELECT iEstado, cMensaje;
  END;
$BODY$
  LANGUAGE plpgsql VOLATILE;
ALTER FUNCTION fun_timbradofacturaelectronicanominaresponse(integer, integer, integer, integer, text, text, character varying, text, text, character varying, character varying, character varying)
  OWNER TO sysfacturaelectronicaadmin;
