CREATE TABLE mov_facturasnomina
(
  idu_foliomovto integer NOT NULL,
  clv_rfcempresa character varying(13) NOT NULL,
  num_empleado integer NOT NULL,
  num_empleadogenera integer NOT NULL,
  fec_nomina date NOT NULL,
  arc_xmlnomina text NOT NULL,
  num_paccfdi smallint NOT NULL,
  imp_total integer NOT NULL,
  imp_subtotal integer NOT NULL,
  imp_descuento integer NOT NULL,
  arc_cfdicadenaoriginal text NOT NULL,
  arc_certificadosat text NOT NULL,
  arc_xmltimbrado text NOT NULL,
  fec_cfditimbrado character varying(32) NOT NULL,
  arc_qrcode text NOT NULL,
  arc_sellosat text NOT NULL,
  fol_uuid character varying(36) NOT NULL,
  clv_versiontfd character varying(16) NOT NULL,
  fec_movto timestamp without time zone NOT NULL,
  opc_estatus smallint NOT NULL,
  CONSTRAINT pk_mov_facturasnomina_idu_foliomovto PRIMARY KEY (idu_foliomovto ),
  CONSTRAINT fk_mov_facturasnomina_clv_rfcempresa FOREIGN KEY (clv_rfcempresa)
      REFERENCES cat_empresasnomina (clv_rfc) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE NO ACTION,
  CONSTRAINT fk_mov_facturasnomina_idu_foliomovto FOREIGN KEY (idu_foliomovto)
      REFERENCES mov_facturasnominarequest (idu_foliomovto) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE NO ACTION,
  CONSTRAINT fk_mov_facturasnomina_num_paccfdi FOREIGN KEY (num_paccfdi)
      REFERENCES cat_paccfdi (idu_paccfdi) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE NO ACTION,
  CONSTRAINT uq_mov_facturasnomina_fol_uuid UNIQUE (fol_uuid ),
  CONSTRAINT chk_mov_facturasnomina_uuidvalido CHECK (btrim(fol_uuid::text) <> ''::text),
  CONSTRAINT chk_mov_facturasnomina_xmlvalido CHECK (btrim(arc_xmlnomina) <> ''::text AND btrim(arc_xmltimbrado) <> ''::text)
);
ALTER TABLE mov_facturasnomina
  OWNER TO sysfacturaelectronicaadmin;

CREATE INDEX ix_mov_facturasnomina_empleado_fecha
  ON mov_facturasnomina
  USING btree
  (num_empleado, fec_nomina);

CREATE INDEX ix_mov_facturasnomina_fecha
  ON mov_facturasnomina
  USING btree
  (fec_nomina);

CREATE INDEX ix_mov_facturasnomina_rfc_fecha
  ON mov_facturasnomina
  USING btree
  (clv_rfcempresa, fec_nomina);
