<?php
class CComprobanteDetecno extends CComprobante {
    function __construct() {
    }

    function __destruct() {
    }

    function timbrar($hConfWS, $sXml) {
        $sCadenaOriginal = '';
        $iEstado = 1;
        $sMensaje = 'Error interno del sistema.';
        $sSello = '';
        $hResponse = new stdClass();
        $hProcesa = NULL;
        
        try {
            $sXml = $this->complementaXMLDetecno($sXml, $hConfWS->arc_xmldomiciliofiscal, $hConfWS->fec_xml);
            $hProcesa = $this->procesaXmlComprobante($sXml);
            
            if($hProcesa->estado != 0) {
                $sMensaje = $hProcesa->mensaje;
            }
            else {
                if(($sCadenaOriginal = $this->generaCadenaOriginal($sXml)) == NULL) {
                    $sMensaje = 'Error al generar cadena original.';
                }
                else {
                    if(($sSello = $this->generaSelloDetecno($hConfWS->arc_empresakey, $sCadenaOriginal,$hConfWS->nom_certificado)) == NULL) {
                        $sMensaje = 'Error al generar sello.';
                    }
                    else {
                        $sXml = $this->agregarcfdiNominaDetecno($sXml);
                        $sXml = $this->AgregaURLFiscal($sXml);
                        $sXml = $this->agregarCertificadoYSelloDetecno($sXml, $hConfWS->arc_empresacert, $sSello, $hConfWS->nom_certificado);
                        $hDatosPac = $this->timbrarXML($hConfWS, $sXml);
                        
                        if($hDatosPac->estado != 0) {
                            $sMensaje = $hDatosPac->mensaje;
                        }
                        else {
                            $iEstado = 0;
                            $sMensaje = 'OK';
                            $hDatosPac->total = intval(floatval($hProcesa->comprobante->total) * 100);
                            $hDatosPac->subtotal = intval(floatval($hProcesa->comprobante->subTotal) * 100);
                            $hDatosPac->descuento = intval(floatval($hProcesa->comprobante->descuento) * 100) + intval(floatval($hProcesa->comprobante->Impuestos->Retenciones->Retencion->importe) * 100);
                            $hResponse->datosPac = $hDatosPac;
                        }
                    }
                }
            }
        }
        catch(exception $ex) {
            $iEstado = 2;
            $sMensaje = $ex->getMessage();
            $this->GrabaLog("ERROR EN timbrar: ".$e->getMessage()." XML ".$sXml);
            $this->GrabaDebug("ERROR EN timbrar: ".$e->getMessage()." XML ".$sXml);
        }
        
        $hResponse->estado = $iEstado;
        $hResponse->mensaje = $sMensaje;
        return $hResponse;
    }

    function timbrar33($hConfWS, $sXml, $sClvTipoTimbrado) {
        $sCadenaOriginal = '';
        $iEstado = 1;
        $sMensaje = 'Error interno del sistema.';
        $sSello = '';
        $hResponse = new stdClass();
        $hProcesa = NULL;

        try {
            $sXml = $this->complementaXMLDetecno33($sXml, $hConfWS->arc_xmldomiciliofiscal, $hConfWS->fec_xml, $hConfWS->nom_certificado);
            $hProcesa = $this->procesaXmlComprobante33($sXml, $sClvTipoTimbrado);
            
            if($hProcesa->estado != 0) {
                $sMensaje = $hProcesa->mensaje;
            }
            else {
                if(($sCadenaOriginal = $this->generaCadenaOriginal33($sXml)) == NULL) {
                    $sMensaje = 'Error al generar cadena original.';
                }
                else {
                    if(($sSello = $this->generaSelloDetecno33( $hConfWS->arc_empresakey, $sCadenaOriginal )) == NULL) {
                        $sMensaje = 'Error al generar sello.';
                    }
                    else {
                        $sXml = $this->agregarcfdiNominaDetecno($sXml);
                        $sXml = $this->AgregaURLFiscal($sXml);
                        $sXml = $this->agregarCertificadoYSelloDetecno33($sXml, $hConfWS->arc_empresacert, $sSello, $hConfWS->nom_certificado);
                        $hDatosPac = $this->timbrarXML33($hConfWS, $sXml);
                        
                        if($hDatosPac->estado != 0) {
                            $sMensaje = $hDatosPac->mensaje;
                        }
                        else {
                            $iEstado = 0;
                            $sMensaje = 'OK';
                            $hDatosPac->total = intval(floatval($hProcesa->comprobante->Total) * 100);
                            $hDatosPac->subtotal = intval(floatval($hProcesa->comprobante->SubTotal) * 100);
                            $hDatosPac->descuento = intval(floatval($hProcesa->comprobante->Descuento) * 100);
                            $hResponse->datosPac = $hDatosPac;
                        }
                    }
                }
            }
        }
        catch(exception $ex) {
            $iEstado = 2;
            $sMensaje = $ex->getMessage();
            $this->GrabaLog("ERROR EN timbrar: ".$e->getMessage()." XML ".$sXml);
            $this->GrabaDebug("ERROR EN timbrar: ".$e->getMessage()." XML ".$sXml);
        }

        $hResponse->estado = $iEstado;
        $hResponse->mensaje = $sMensaje;
        return $hResponse;
    }

    private function timbrarXML($hConfWS, $sXml) {
            $iEstado = 1;
            $sMensaje = 'Error interno del sistema [timbrarXML].';
            $hResponse = new stdClass();

            try
            {
                $urlPruebas = strpos($hConfWS->nom_url, $GLOBALS['URL_DETECNO_PRUEBAS']);

                //if($urlPruebas != FALSE) // PRUEBAS
                if( $GLOBALS['OPC_SERVIDOR_DETECNO'] == 1 )
                {
                    $urlEnvelope = $GLOBALS['URL_ENVELOPE_DETECNO_PRUEBAS'];

                    $soap_request = '<soapenv:Envelope xmlns:soapenv="'.$urlEnvelope.'" xmlns:tem="http://tempuri.org/">
                                        <soapenv:Header/>
                                        <soapenv:Body>
                                           <tem:TimbrarCfdi>
                                              <!--Optional:-->
                                              <tem:usuario>'.$hConfWS->nom_usuario.'</tem:usuario>
                                              <!--Optional:-->
                                              <tem:password>'.$hConfWS->nom_password.'</tem:password>
                                              <!--Optional:-->
                                              <tem:cfdi><![CDATA['.$sXml.']]></tem:cfdi>
                                           </tem:TimbrarCfdi>
                                        </soapenv:Body>
                                     </soapenv:Envelope>';

                    $headers = array(
                                        'Accept-Encoding: gzip,deflate',
                                        'Content-Type: text/xml;charset=UTF-8',
                                        'SOAPAction: "http://tempuri.org/IDetecnoPac/TimbrarCfdi"',
                                        'Host: '.$GLOBALS['URL_DETECNO_PRUEBAS'],
                                        'Content-Length:'.strlen($soap_request),
                                        'Proxy-Connection: Keep-Alive'
                                    );
                    $this->GrabaDebug(sprintf("headers........ [ %s ]", $headers[0]));
                    $this->GrabaDebug(sprintf("headers........ [ %s ]", $headers[1]));
                    $this->GrabaDebug(sprintf("headers........ [ %s ]", $headers[2]));
                    $this->GrabaDebug(sprintf("headers........ [ %s ]", $headers[3]));
                    $this->GrabaDebug(sprintf("headers........ [ %s ]", $headers[4]));
                    $this->GrabaDebug(sprintf("headers........ [ %s ]", $headers[5]));
                }
                else // PRODUCCION
                {
                    $urlEnvelope = $GLOBALS['URL_ENVELOPE_DETECNO_PRODUCCION'];

                    $soap_request = '<soap:Envelope xmlns:soap="'.$urlEnvelope.'" xmlns:tem="http://tempuri.org/">
                                        <soap:Header xmlns:wsa="http://www.w3.org/2005/08/addressing"><wsa:Action>http://tempuri.org/IDetecnoPac/TimbrarCfdi</wsa:Action><wsa:To>https://www.timbra.mx/WCFTimbrador/DetecnoPac.svc</wsa:To></soap:Header>
                                        <soap:Body>
                                           <tem:TimbrarCfdi>
                                              <tem:usuario>'.$hConfWS->nom_usuario.'</tem:usuario>
                                              <tem:password>'.$hConfWS->nom_password.'</tem:password>
                                              <tem:cfdi><![CDATA['.$sXml.']]></tem:cfdi>
                                           </tem:TimbrarCfdi>
                                        </soap:Body>
                                     </soap:Envelope>';

                    $headers = array(
                                        'Accept-Encoding: gzip,deflate',
                                        'Content-Type: application/soap+xml;charset=UTF-8;action="http://tempuri.org/IDetecnoPac/TimbrarCfdi"',
                                        'Content-Length:'.strlen($soap_request),
                                        'Host: '.$GLOBALS['URL_DETECNO_PRODUCCION'],
                                        'Connection: Keep-Alive'
                                    );
                    $this->GrabaDebug(sprintf("headers........ [ %s ]", $headers[0]));
                    $this->GrabaDebug(sprintf("headers........ [ %s ]", $headers[1]));
                    $this->GrabaDebug(sprintf("headers........ [ %s ]", $headers[2]));
                    $this->GrabaDebug(sprintf("headers........ [ %s ]", $headers[3]));
                    $this->GrabaDebug(sprintf("headers........ [ %s ]", $headers[4]));
                }

                $this->GrabaDebug(sprintf("nom_url........ [ %s ]", $hConfWS->nom_url));
                $this->GrabaDebug(sprintf("soap_request... [ %s ]", $soap_request));

                $ch = curl_init($hConfWS->nom_url);
                curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
                curl_setopt($ch, CURLOPT_POST, TRUE);
                curl_setopt($ch, CURLOPT_POSTFIELDS, $soap_request);
                curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
                curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 5); 
                curl_setopt($ch, CURLOPT_TIMEOUT, 20); 

                if($hConfWS->opc_proxy == '1') {
                    curl_setopt($ch, CURLOPT_PROXY, $hConfWS->num_proxyhost.':'.$hConfWS->num_port);
                }

                $result = curl_exec($ch);
                curl_close($ch);
                $rcXML = simplexml_load_string($result);

                $Success = $rcXML->children($urlEnvelope)->Body->children('http://tempuri.org/')->TimbrarCfdiResponse->TimbrarCfdiResult->children('http://schemas.datacontract.org/2004/07/Timbrador')->Success;

                if( trim(strtoupper($Success)) == 'FALSE' )
                {
                    $ErrCode = $rcXML->children($urlEnvelope)->Body->children('http://tempuri.org/')->TimbrarCfdiResponse->TimbrarCfdiResult->children('http://schemas.datacontract.org/2004/07/Timbrador')->ErrCode;
                    $ErrDesc = $rcXML->children($urlEnvelope)->Body->children('http://tempuri.org/')->TimbrarCfdiResponse->TimbrarCfdiResult->children('http://schemas.datacontract.org/2004/07/Timbrador')->ErrDesc;
                    $Msg = $rcXML->children($urlEnvelope)->Body->children('http://tempuri.org/')->TimbrarCfdiResponse->TimbrarCfdiResult->children('http://schemas.datacontract.org/2004/07/Timbrador')->Msg;
                    $sMensaje = $ErrDesc." | ".$Msg;

                    $this->GrabaLog("ERROR AL TIMBRAR DETECNO....!");
                    $this->GrabaLog(sprintf("XML ENVIO.............. [%s]", $sXml));
                    $this->GrabaLog(sprintf("ErrCode.............. [%s]", $ErrCode));
                    $this->GrabaLog(sprintf("ErrDesc.............. [%s]", $ErrDesc));
                    $this->GrabaLog(sprintf("Msg.................. [%s]", $Msg));                    

                    $this->GrabaDebug("ERROR AL TIMBRAR DETECNO....!");
                    $this->GrabaDebug(sprintf("XML ENVIO.............. [%s]", $sXml));
                    $this->GrabaDebug(sprintf("ErrCode.............. [%s]", $ErrCode));
                    $this->GrabaDebug(sprintf("ErrDesc.............. [%s]", $ErrDesc));
                    $this->GrabaDebug(sprintf("Msg.................. [%s]", $Msg));                    
                }
                else 
                {
                    // Obtener datos que regresa el proveedor
                    $CoTfd = $rcXML->children($urlEnvelope)->Body->children('http://tempuri.org/')->TimbrarCfdiResponse->TimbrarCfdiResult->children('http://schemas.datacontract.org/2004/07/Timbrador')->CoTfd.PHP_EOL;
                    $StrQr = $rcXML->children($urlEnvelope)->Body->children('http://tempuri.org/')->TimbrarCfdiResponse->TimbrarCfdiResult->children('http://schemas.datacontract.org/2004/07/Timbrador')->StrQr.PHP_EOL;
                    $XmlTfd = $rcXML->children($urlEnvelope)->Body->children('http://tempuri.org/')->TimbrarCfdiResponse->TimbrarCfdiResult->children('http://schemas.datacontract.org/2004/07/Timbrador')->XmlTfd.PHP_EOL;

                    // Obtener Valores de los Atributos del nodo XmlTfd
                    $TFDxml = simplexml_load_string($XmlTfd);
                    $certificadoSAT = $TFDxml->attributes()->noCertificadoSAT;
                    $selloSAT = $TFDxml->attributes()->selloSAT;
                    $uuid = $TFDxml->attributes()->UUID;
                    $versionTFD = $TFDxml->attributes()->version;
                    $fechaTimbrado = $TFDxml->attributes()->FechaTimbrado;

                    // Insertar nodo XmlTfd al XmlOrigen para  generar xmlTimbrado
                    $sXml1 = substr($sXml, 0, strpos ($sXml, '</cfdi:Complemento>'));
                    $sXml2 = substr($sXml, strpos ($sXml, '</cfdi:Complemento>'));                                 
                    $xmlTimbrado = $sXml1.$XmlTfd.$sXml2;

                    $iEstado = 0;
                    $sMensaje = 'OK';
                    $hResponse->cadenaOriginal = $CoTfd;
                    $hResponse->certificadoSAT = $certificadoSAT;
                    $hResponse->xmlTimbrado = $xmlTimbrado;
                    $hResponse->fechatimbrado = $fechaTimbrado;
                    $hResponse->qr = $StrQr;
                    $hResponse->selloSAT = $selloSAT;
                    $hResponse->uuid = $uuid;
                    $hResponse->versionTFD = $versionTFD;

                    $this->GrabaLog(sprintf("Se genero folio fiscal: [%s]", $uuid));
                    $this->GrabaDebug(sprintf("Se genero folio fiscal: [%s]", $uuid));
                }
            }
            catch(exception $ex) {
                $iEstado = 2;
                $sMensaje = $ex->getMessage();
                $this->GrabaLog(sprintf("ERROR EN timbrarXML DETECNO...! [ %s ]", $sMensaje." XML ".$sXml));
                $this->GrabaDebug(sprintf("ERROR EN timbrarXML DETECNO...! [ %s ]", $sMensaje." XML ".$sXml));
            }

            $hResponse->estado = $iEstado;
            $hResponse->mensaje = $sMensaje;

            return $hResponse;
    }

    private function timbrarXML33($hConfWS, $sXml) {
            $iEstado = 1;
            $sMensaje = 'Error interno del sistema [timbrarXML33].';
            $hResponse = new stdClass();

            try 
            {
                $urlPruebas = strpos($hConfWS->nom_url, $GLOBALS['URL_DETECNO_PRUEBAS']);

                //if($urlPruebas != FALSE) // PRUEBAS
                if( $GLOBALS['OPC_SERVIDOR_DETECNO'] == 1 )
                {
                    $urlEnvelope = $GLOBALS['URL_ENVELOPE_DETECNO_PRUEBAS'];

                    $soap_request = '<soap:Envelope xmlns:soap="'.$urlEnvelope.'" xmlns:tem="http://tempuri.org/">
                                        <soap:Header xmlns:wsa="http://www.w3.org/2005/08/addressing">
                                          <wsa:Action>http://tempuri.org/IDetecnoPac/TimbrarCfdi</wsa:Action>
                                          <wsa:To>https://test.timbra.mx/WCFtimbrador33/DetecnoPac.svc</wsa:To>
                                        </soap:Header>
                                        <soap:Body>
                                           <tem:TimbrarCfdi>
                                              <tem:usuario>'.$hConfWS->nom_usuario.'</tem:usuario>
                                              <tem:password>'.$hConfWS->nom_password.'</tem:password>
                                              <tem:cfdi><![CDATA['.$sXml.']]></tem:cfdi>
                                           </tem:TimbrarCfdi>
                                        </soap:Body>
                                     </soap:Envelope>';

                    $headers = array(
                                        'Accept-Encoding: gzip,deflate',
                                        'Content-Type: application/soap+xml;charset=UTF-8;action="http://tempuri.org/IDetecnoPac/TimbrarCfdi"',
                                        //'SOAPAction: "http://tempuri.org/IDetecnoPac/TimbrarCfdi"',
                                        'Host: '.$GLOBALS['URL_DETECNO_PRUEBAS'],
                                        'Content-Length:'.strlen($soap_request),
                                        'Proxy-Connection: Keep-Alive'
                                        ,'User-Agent: Apache-HttpClient/4.1.1 (java 1.5)'
                                    );
                    $this->GrabaDebug(sprintf("headers........ [ %s ]", $headers[0]));
                    $this->GrabaDebug(sprintf("headers........ [ %s ]", $headers[1]));
                    $this->GrabaDebug(sprintf("headers........ [ %s ]", $headers[2]));
                    $this->GrabaDebug(sprintf("headers........ [ %s ]", $headers[3]));
                    $this->GrabaDebug(sprintf("headers........ [ %s ]", $headers[4]));
                    $this->GrabaDebug(sprintf("headers........ [ %s ]", $headers[5]));
                }
                else // PRODUCCION
                {
                    $urlEnvelope = $GLOBALS['URL_ENVELOPE_DETECNO_PRODUCCION'];

                    $soap_request = '<soap:Envelope xmlns:soap="'.$urlEnvelope.'" xmlns:tem="http://tempuri.org/">
                                        <soap:Header xmlns:wsa="http://www.w3.org/2005/08/addressing"><wsa:Action>http://tempuri.org/IDetecnoPac/TimbrarCfdi</wsa:Action><wsa:To>https://www.timbra.mx/WCFTimbrador33/DetecnoPac.svc</wsa:To></soap:Header>
                                        <soap:Body>
                                           <tem:TimbrarCfdi>
                                              <tem:usuario>'.$hConfWS->nom_usuario.'</tem:usuario>
                                              <tem:password>'.$hConfWS->nom_password.'</tem:password>
                                              <tem:cfdi><![CDATA['.$sXml.']]></tem:cfdi>
                                           </tem:TimbrarCfdi>
                                        </soap:Body>
                                     </soap:Envelope>';

                    $headers = array(
                                        'Accept-Encoding: gzip,deflate',
                                        'Content-Type: application/soap+xml;charset=UTF-8;action="http://tempuri.org/IDetecnoPac/TimbrarCfdi"',
                                        'Content-Length:'.strlen($soap_request),
                                        'Host: '.$GLOBALS['URL_DETECNO_PRODUCCION'],
                                        'Connection: Keep-Alive'
                                    );
                    $this->GrabaDebug(sprintf("headers........ [ %s ]", $headers[0]));
                    $this->GrabaDebug(sprintf("headers........ [ %s ]", $headers[1]));
                    $this->GrabaDebug(sprintf("headers........ [ %s ]", $headers[2]));
                    $this->GrabaDebug(sprintf("headers........ [ %s ]", $headers[3]));
                    $this->GrabaDebug(sprintf("headers........ [ %s ]", $headers[4]));
                }

                $this->GrabaDebug(sprintf("nom_url........ [ %s ]", $hConfWS->nom_url));
                $this->GrabaDebug(sprintf("soap_request... [ %s ]", $soap_request));

                $ch = curl_init($hConfWS->nom_url);
                curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
                curl_setopt($ch, CURLOPT_POST, TRUE);
                curl_setopt($ch, CURLOPT_POSTFIELDS, $soap_request);
                curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
                curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 5); 
                curl_setopt($ch, CURLOPT_TIMEOUT, 20); 

                if($hConfWS->opc_proxy == '1') {
                    curl_setopt($ch, CURLOPT_PROXY, $hConfWS->num_proxyhost.':'.$hConfWS->num_port);
                }

                $result = curl_exec($ch);
                curl_close($ch);
                //$rcXML = simplexml_load_string($result);

                $dom = new DOMDocument;
                $dom->loadXML($result);
                $this->GrabaDebug(sprintf("result CURL.. [ %s ]", $result));

                //$Success = $rcXML->children($urlEnvelope)->Body->children('http://tempuri.org/')->TimbrarCfdiResponse->TimbrarCfdiResult->children('http://schemas.datacontract.org/2004/07/Timbrador')->Success;
                $books = $dom->getElementsByTagName('Success');
                
                foreach ($books as $book) {
                    if($book->nodeValue == "true") {
                        // Obtener datos que regresa el proveedor
                        $ElementCoTfd = $dom->getElementsByTagName('CoTfd');
                        foreach ($ElementCoTfd as $coTfds) {
                            $CoTfd = $coTfds->nodeValue;
                        }
                        
                        $ElementStrQr = $dom->getElementsByTagName('StrQr');
                        foreach ($ElementStrQr as $StrQrs) {
                            $StrQr = $StrQrs->nodeValue;
                        }
                        
                        $ElementXmlTfd = $dom->getElementsByTagName('XmlTfd');
                        foreach ($ElementXmlTfd as $XmlTfd_s) {
                            $XmlTfd = $XmlTfd_s->nodeValue;
                        }
                        
                        // Obtener Valores de los Atributos del nodo XmlTfd
                        $dom2 = new DOMDocument;
                        $dom2->loadXML($XmlTfd);

                        $ElementTimbre = $dom2->getElementsByTagName('TimbreFiscalDigital');
                        if($ElementTimbre->item(0)->hasAttribute('NoCertificadoSAT')) {
                            $certificadoSAT = trim($ElementTimbre->item(0)->getAttribute('NoCertificadoSAT'));
                        } else if($ElementTimbre->item(0)->hasAttribute('noCertificadoSAT')) {
                            $certificadoSAT = trim($ElementTimbre->item(0)->getAttribute('noCertificadoSAT'));
                        }

                        if($ElementTimbre->item(0)->hasAttribute('SelloSAT')) {
                            $selloSAT = trim($ElementTimbre->item(0)->getAttribute('SelloSAT'));
                        } else if($ElementTimbre->item(0)->hasAttribute('selloSAT')) {
                            $selloSAT = trim($ElementTimbre->item(0)->getAttribute('selloSAT'));
                        }

                        if($ElementTimbre->item(0)->hasAttribute('UUID')) {
                            $uuid = trim($ElementTimbre->item(0)->getAttribute('UUID'));
                        }

                        if($ElementTimbre->item(0)->hasAttribute('Version')) {
                            $versionTFD = trim($ElementTimbre->item(0)->getAttribute('Version'));
                        } else if($ElementTimbre->item(0)->hasAttribute('version')) {
                            $versionTFD = trim($ElementTimbre->item(0)->getAttribute('version'));
                        }

                        if($ElementTimbre->item(0)->hasAttribute('FechaTimbrado')) {
                            $fechaTimbrado = trim($ElementTimbre->item(0)->getAttribute('FechaTimbrado'));
                        }

                        // Insertar nodo XmlTfd al XmlOrigen para  generar xmlTimbrado
                        $sXml1 = substr($sXml, 0, strpos ($sXml, '</cfdi:Complemento>'));
                        $sXml2 = substr($sXml, strpos ($sXml, '</cfdi:Complemento>'));                                 
                        $xmlTimbrado = $sXml1.$XmlTfd.$sXml2;

                        $iEstado = 0;
                        $sMensaje = 'OK';
                        $hResponse->cadenaOriginal = $CoTfd;
                        $hResponse->certificadoSAT = $certificadoSAT;
                        $hResponse->xmlTimbrado = $xmlTimbrado;
                        $hResponse->fechatimbrado = $fechaTimbrado;
                        $hResponse->qr = $StrQr;
                        $hResponse->selloSAT = $selloSAT;
                        $hResponse->uuid = $uuid;
                        $hResponse->versionTFD = $versionTFD;

                        $this->GrabaLog(sprintf("Se genero folio fiscal: [%s]", $uuid));
                        $this->GrabaDebug(sprintf("Se genero folio fiscal: [%s]", $uuid));
                    }
                    else
                    { 
                        $ElementErrCode = $dom->getElementsByTagName('ErrCode');
                        foreach ($ElementErrCode as $sErrCode) {
                            $ErrCode = $sErrCode->nodeValue;
                        }
                        
                        $ElementErrDesc = $dom->getElementsByTagName('ErrDesc');
                        foreach ($ElementErrDesc as $sErrDesc) {
                            $ErrDesc = $sErrDesc->nodeValue;
                        }
                        
                        $ElementMsg = $dom->getElementsByTagName('Msg');
                        foreach ($ElementMsg as $sMsg) {
                            $Msg = $sMsg->nodeValue;
                        }
                        
                        $sMensaje = $ErrDesc." | ".$Msg;

                        $this->GrabaLog("ERROR AL TIMBRAR DETECNO....!");
                        $this->GrabaLog(sprintf("XML ENVIO.............. [%s]", $sXml));
                        $this->GrabaLog(sprintf("ErrCode.............. [%s]", $ErrCode));
                        $this->GrabaLog(sprintf("ErrDesc.............. [%s]", $ErrDesc));
                        $this->GrabaLog(sprintf("Msg.................. [%s]", $Msg));
                        
                        $this->GrabaDebug("ERROR AL TIMBRAR DETECNO....!");
                        $this->GrabaDebug(sprintf("XML ENVIO.............. [%s]", $sXml));
                        $this->GrabaDebug(sprintf("ErrCode.............. [%s]", $ErrCode));
                        $this->GrabaDebug(sprintf("ErrDesc.............. [%s]", $ErrDesc));
                        $this->GrabaDebug(sprintf("Msg.................. [%s]", $Msg));
                    }
                }
            }
            catch(exception $ex) {
                $iEstado = 2;
                $sMensaje = $ex->getMessage();
                $this->GrabaLog(sprintf("ERROR EN timbrarXML33 DETECNO....! [ %s ]", $sMensaje." XML ".$sXml));
                $this->GrabaDebug(sprintf("ERROR EN timbrarXML33 DETECNO....! [ %s ]", $sMensaje." XML ".$sXml));
            }

            $hResponse->estado = $iEstado;
            $hResponse->mensaje = $sMensaje;

            return $hResponse;
    }

    function cancelar($hConfWS, $sUuid) {
        $iEstado = 1;
        $sMensaje = 'Error interno del sistema.';
        $hResponse = new stdClass();
        try {
            $urlPruebas = strpos($hConfWS->nom_url, $GLOBALS['URL_DETECNO_PRUEBAS']);

            //if($urlPruebas != FALSE) // PRUEBAS
            if( $GLOBALS['OPC_SERVIDOR_DETECNO'] == 1 )
            {
                $urlEnvelope = $GLOBALS['URL_ENVELOPE_DETECNO_PRUEBAS'];
                
                $soap_request = 
                    '<soapenv:Envelope xmlns:soapenv="'.$urlEnvelope.'" xmlns:tem="http://tempuri.org/">
                        <soapenv:Header/>
                        <soapenv:Body>
                          <tem:CancelarCfdi>
                             <tem:usuario>'.$hConfWS->nom_usuario.'</tem:usuario>
                             <tem:password>'.$hConfWS->nom_password.'</tem:password>
                             <tem:rfcEmisor>'.$hConfWS->rfc_emisor.'</tem:rfcEmisor>
                             <tem:uuid>'.$sUuid.'</tem:uuid>
                          </tem:CancelarCfdi>
                        </soapenv:Body>
                    </soapenv:Envelope>';

                $headers = array(
                        'Accept-Encoding: gzip,deflate',
                        'Content-Type: text/xml;charset=UTF-8',
                        'SOAPAction: "http://tempuri.org/IDetecnoPac/CancelarCfdi"',
                        'Content-Length: '.strlen($soap_request),
                        'Host: '.$GLOBALS['URL_DETECNO_PRUEBAS'],
                        'Proxy-Connection: Keep-Alive'
                        );
                $this->GrabaDebug(sprintf("headers........ [ %s ]", $headers[0]));
                $this->GrabaDebug(sprintf("headers........ [ %s ]", $headers[1]));
                $this->GrabaDebug(sprintf("headers........ [ %s ]", $headers[2]));
                $this->GrabaDebug(sprintf("headers........ [ %s ]", $headers[3]));
                $this->GrabaDebug(sprintf("headers........ [ %s ]", $headers[4]));
                $this->GrabaDebug(sprintf("headers........ [ %s ]", $headers[5]));
            }
            else // PRODUCCION
            {
                $urlEnvelope = $GLOBALS['URL_ENVELOPE_DETECNO_PRODUCCION'];

                $soap_request =
                    '<soap:Envelope xmlns:soap="'.$urlEnvelope.'" xmlns:tem="http://tempuri.org/">
                       <soap:Header xmlns:wsa="http://www.w3.org/2005/08/addressing"><wsa:Action>http://tempuri.org/IDetecnoPac/CancelarCfdi</wsa:Action><wsa:To>https://www.timbra.mx/WCFTimbrador/DetecnoPac.svc</wsa:To></soap:Header>
                       <soap:Body>
                          <tem:CancelarCfdi>
                             <tem:usuario>'.$hConfWS->nom_usuario.'</tem:usuario>
                             <tem:password>'.$hConfWS->nom_password.'</tem:password>
                             <tem:rfcEmisor>'.$hConfWS->rfc_emisor.'</tem:rfcEmisor>
                             <tem:uuid>'.$sUuid.'</tem:uuid>
                          </tem:CancelarCfdi>
                       </soap:Body>
                    </soap:Envelope>';
                
                $headers = array(
                    'Accept-Encoding: gzip,deflate',
                    'Content-Type: application/soap+xml;charset=UTF-8;action="http://tempuri.org/IDetecnoPac/CancelarCfdi"',
                    'Content-Length: '.strlen($soap_request),
                    'Host: '.$GLOBALS['URL_DETECNO_PRODUCCION'],
                    'Connection: Keep-Alive'
                );
                $this->GrabaDebug(sprintf("headers........ [ %s ]", $headers[0]));
                $this->GrabaDebug(sprintf("headers........ [ %s ]", $headers[1]));
                $this->GrabaDebug(sprintf("headers........ [ %s ]", $headers[2]));
                $this->GrabaDebug(sprintf("headers........ [ %s ]", $headers[3]));
                $this->GrabaDebug(sprintf("headers........ [ %s ]", $headers[4]));
            }

            $this->GrabaDebug(sprintf("nom_url........ [ %s ]", $hConfWS->nom_url));
            $this->GrabaDebug(sprintf("soap_request... [ %s ]", $soap_request));

            $ch = curl_init($hConfWS->nom_url);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
            curl_setopt($ch, CURLOPT_POST, TRUE);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $soap_request);
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
            curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 5); 
            curl_setopt($ch, CURLOPT_TIMEOUT, 20); 
            
            if($hConfWS->opc_proxy == '1') {
                curl_setopt($ch, CURLOPT_PROXY, $hConfWS->num_proxyhost.':'.$hConfWS->num_port);                    
            }

            
            $result = curl_exec($ch);
            curl_close($ch);
            $rcXML = simplexml_load_string($result);
            
            $Success = $rcXML->children($urlEnvelope)->Body->children('http://tempuri.org/')->CancelarCfdiResponse->CancelarCfdiResult->children('http://schemas.datacontract.org/2004/07/Timbrador')->Success;
                  
            if( trim(strtoupper($Success)) == 'FALSE' ) {
                $ErrCode = $rcXML->children($urlEnvelope)->Body->children('http://tempuri.org/')->CancelarCfdiResponse->CancelarCfdiResult->children('http://schemas.datacontract.org/2004/07/Timbrador')->ErrCode;
                $ErrDesc = $rcXML->children($urlEnvelope)->Body->children('http://tempuri.org/')->CancelarCfdiResponse->CancelarCfdiResult->children('http://schemas.datacontract.org/2004/07/Timbrador')->ErrDesc;
                $Msg = $rcXML->children($urlEnvelope)->Body->children('http://tempuri.org/')->CancelarCfdiResponse->CancelarCfdiResult->children('http://schemas.datacontract.org/2004/07/Timbrador')->Msg;
                

                $this->GrabaLog("ERROR AL CANCELAR DETECNO....!");
                $this->GrabaLog(sprintf("UUID ENVIO.............. [%s]", $sUuid));
                $this->GrabaLog(sprintf("ErrCode.............. [%s]", $ErrCode));
                $this->GrabaLog(sprintf("ErrDesc.............. [%s]", $ErrDesc));
                $this->GrabaLog(sprintf("Msg.................. [%s]", $Msg));    

                $this->GrabaDebug("ERROR AL CANCELAR DETECNO....!");
                $this->GrabaDebug(sprintf("UUID ENVIO.............. [%s]", $sUuid));
                $this->GrabaDebug(sprintf("ErrCode.............. [%s]", $ErrCode));
                $this->GrabaDebug(sprintf("ErrDesc.............. [%s]", $ErrDesc));
                $this->GrabaDebug(sprintf("Msg.................. [%s]", $Msg));    

                if($ErrCode != 200)
                {
                    $sMensaje = $ErrDesc." | ".$Msg;
                    $iEstado = 2;
                }
                else if(ErrCode != 201 && ErrCode != 202) {
                    $sMensaje = $ErrDesc." | ".$Msg;
                    $iEstado = 2;
                }
                else {
                    $iEstado = 0;
                    $sMensaje = 'OK';
                    $hResponse->respuestaPac = $Msg;
                }
            }
            else 
            {
                // Obtener datos que regresa el proveedor
                $Msg = $rcXML->children($urlEnvelope)->Body->children('http://tempuri.org/')->CancelarCfdiResponse->CancelarCfdiResult->children('http://schemas.datacontract.org/2004/07/Timbrador')->Msg;
 
                $iEstado = 0;
                $sMensaje = 'OK';
                $hResponse->respuestaPac = $Msg;
            }
        }
        catch(exception $ex) {
            $iEstado = 2;
            $sMensaje = $ex->getMessage();                
            $this->GrabaLog(sprintf("ERROR EN CANCELAR DETECNO....! [ %s ]",  $sMensaje." UUID ".$sUuid));
            $this->GrabaDebug(sprintf("ERROR EN CANCELAR DETECNO....! [ %s ]",  $sMensaje." UUID ".$sUuid));
        }

            $hResponse->estado = $iEstado;
            $hResponse->mensaje = $sMensaje;

            return $hResponse;
    }

    function cancelarConXml($hConfWS, $sXml, $sUuid) {
        $iEstado = 1;
        $sMensaje = 'Error interno del sistema. - cancelarConXml';
        $hResponse = new stdClass();
        try {
            $sUrnUUID = strtolower( $sUuid );

            $urlPruebas = strpos($hConfWS->nom_url, $GLOBALS['URL_DETECNO_PRUEBAS']);

            //if($urlPruebas != FALSE) // PRUEBAS
            if( $GLOBALS['OPC_SERVIDOR_DETECNO'] == 1 )
            {
                $urlEnvelope = $GLOBALS['URL_ENVELOPE_DETECNO_PRUEBAS'];
                
                $soap_request = 
                            '<soapenv:Envelope xmlns:soapenv="'.$urlEnvelope.'" xmlns:wsa="http://www.w3.org/2005/08/addressing" xmlns:tem="http://tempuri.org/">
                                <soapenv:Header>
                                    <wsa:Action soapenv:mustUnderstand="1">http://tempuri.org/ICanceladorXML/CancelacionCfdiConXML</wsa:Action>
                                    <wsa:MessageID>urn:uuid:'.$sUrnUUID.'</wsa:MessageID>
                                    <wsa:ReplyTo>
                                        <wsa:Address>http://www.w3.org/2005/08/addressing/anonymous</wsa:Address>
                                    </wsa:ReplyTo>
                                    <wsa:To soapenv:mustUnderstand="1">https://test.timbra.mx/WCFCancelador/CancelacionXML.svc</wsa:To>
                                </soapenv:Header>
                                <soapenv:Body>
                                    <tem:CancelacionCfdiConXML>
                                        <tem:usuario>'.$hConfWS->nom_usuario.'</tem:usuario>
                                        <tem:password>'.$hConfWS->nom_password.'</tem:password>
                                        <tem:rfcEmisor>'.$hConfWS->rfc_emisor.'</tem:rfcEmisor>
                                        <tem:xmlCancelacion><![CDATA['.$sXml.']]></tem:xmlCancelacion>
                                    </tem:CancelacionCfdiConXML>
                                </soapenv:Body>
                            </soapenv:Envelope>';
                            
                $headers = array(
                                    'Accept-Encoding: gzip,deflate',
                                    'Content-Type: application/soap+xml;charset=UTF-8;action="http://tempuri.org/ICanceladorXML/CancelacionCfdiConXML"',
                                    'Content-Length: '.strlen($soap_request),
                                    'Host: '.$GLOBALS['URL_DETECNO_PRUEBAS'],
                                    'Proxy-Connection: Keep-Alive',
                                    'User-Agent: Apache-HttpClient/4.1.1 (java 1.5)'
                                );
                $this->GrabaDebug(sprintf("headers........ [ %s ]", $headers[0]));
                $this->GrabaDebug(sprintf("headers........ [ %s ]", $headers[1]));
                $this->GrabaDebug(sprintf("headers........ [ %s ]", $headers[2]));
                $this->GrabaDebug(sprintf("headers........ [ %s ]", $headers[3]));
                $this->GrabaDebug(sprintf("headers........ [ %s ]", $headers[4]));
                $this->GrabaDebug(sprintf("headers........ [ %s ]", $headers[5]));
            }
            else { // PRODUCCION
                $urlEnvelope = $GLOBALS['URL_ENVELOPE_DETECNO_PRODUCCION'];
               
                $soap_request = 
                            '<soapenv:Envelope xmlns:soapenv="'.$urlEnvelope.'" xmlns:wsa="http://www.w3.org/2005/08/addressing" xmlns:tem="http://tempuri.org/">
                                <soapenv:Header>
                                    <wsa:Action soapenv:mustUnderstand="1">http://tempuri.org/ICanceladorXML/CancelacionCfdiConXML</wsa:Action>
                                    <wsa:MessageID>urn:uuid:'.$sUrnUUID.'</wsa:MessageID>
                                    <wsa:ReplyTo>
                                        <wsa:Address>http://www.w3.org/2005/08/addressing/anonymous</wsa:Address>
                                    </wsa:ReplyTo>
                                    <wsa:To soapenv:mustUnderstand="1">https://www.timbra.mx/WCFCancelador/CancelacionXML.svc</wsa:To>
                                </soapenv:Header>
                                <soapenv:Body>
                                    <tem:CancelacionCfdiConXML>
                                        <tem:usuario>'.$hConfWS->nom_usuario.'</tem:usuario>
                                        <tem:password>'.$hConfWS->nom_password.'</tem:password>
                                        <tem:rfcEmisor>'.$hConfWS->rfc_emisor.'</tem:rfcEmisor>
                                        <tem:xmlCancelacion><![CDATA['.$sXml.']]></tem:xmlCancelacion>
                                    </tem:CancelacionCfdiConXML>
                                </soapenv:Body>
                            </soapenv:Envelope>';
                
                $headers = array(
                                    'Accept-Encoding: gzip,deflate',
                                    'Content-Type: application/soap+xml;charset=UTF-8;action="http://tempuri.org/ICanceladorXML/CancelacionCfdiConXML"',
                                    'Content-Length: '.strlen($soap_request),
                                    'Host: '.$GLOBALS['URL_DETECNO_PRODUCCION'],
                                    'Proxy-Connection: Keep-Alive',
                                    'User-Agent: Apache-HttpClient/4.1.1 (java 1.5)'
                               );
                $this->GrabaDebug(sprintf("headers........ [ %s ]", $headers[0]));
                $this->GrabaDebug(sprintf("headers........ [ %s ]", $headers[1]));
                $this->GrabaDebug(sprintf("headers........ [ %s ]", $headers[2]));
                $this->GrabaDebug(sprintf("headers........ [ %s ]", $headers[3]));
                $this->GrabaDebug(sprintf("headers........ [ %s ]", $headers[4]));
                $this->GrabaDebug(sprintf("headers........ [ %s ]", $headers[5]));

            }

            $this->GrabaDebug(sprintf("nom_url........ [ %s ]", $hConfWS->nom_url));
            $this->GrabaDebug(sprintf("soap_request... [ %s ]", $soap_request));

            $ch = curl_init($hConfWS->nom_url);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
            curl_setopt($ch, CURLOPT_POST, TRUE);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $soap_request);
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
            curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 5); 
            curl_setopt($ch, CURLOPT_TIMEOUT, 20); 

            if($hConfWS->opc_proxy == '1') {
                curl_setopt($ch, CURLOPT_PROXY, $hConfWS->num_proxyhost.':'.$hConfWS->num_port);                    
            }
            
            $result = curl_exec($ch);
            curl_close($ch);
            
            $dom = new DOMDocument;
            $dom->loadXML($result);
            
            $books = $dom->getElementsByTagName('Success');
            
            foreach ($books as $book) {
                if($book->nodeValue == "true") {
                    // Obtener datos que regresa el proveedor
                    $ElementMsg = $dom->getElementsByTagName('Msg');
                    foreach ($ElementMsg as $Msgs) {
                        $Msg = $Msgs->nodeValue;
                    }
                    
                    $ElementAcuseCanc = $dom->getElementsByTagName('AcuseCanc');
                    foreach ($ElementAcuseCanc as $XmlAcuseCanc_s) {
                        $XmlAcuseCanc = $XmlAcuseCanc_s->nodeValue;
                    }
                    
                    // Obtener Valores de los Atributos del nodo XmlAcuseCanc
                    $dom2 = new DOMDocument;
                    $dom2->loadXML($XmlAcuseCanc);

                    $ElementEstatusUUID = $dom2->getElementsByTagName('EstatusUUID');
                    foreach ($ElementEstatusUUID as $EstatusUUID_s) {
                        $EstatusUUID = $EstatusUUID_s->nodeValue;
                    }
                    
                    $this->GrabaDebug(sprintf("AcuseCanc: [%s]", $XmlAcuseCanc ));
                    
                    $iEstado = 0;
                    $sMensaje = 'OK';
                    $hResponse->EstatusUUID = $EstatusUUID;
                    $hResponse->AcuseCanc = $XmlAcuseCanc;		
                    $hResponse->respuestaPac = $Msg;

                    //$this->GrabaLog(sprintf("EstatusUUID [%s] del folio fiscal: [%s]", $EstatusUUID, $sUuid));
                    $this->GrabaLog(sprintf("Se cancelo el folio fiscal: [%s]", $sUuid));
                    $this->GrabaDebug(sprintf("EstatusUUID [%s] del folio fiscal: [%s]", $EstatusUUID, $sUuid));
                    $this->GrabaDebug(sprintf("Se cancelo el folio fiscal: [%s]", $sUuid));
                }
                else {
                    $ElementErrCode = $dom->getElementsByTagName('ErrCode');
                    foreach ($ElementErrCode as $sErrCode) {
                        $ErrCode = $sErrCode->nodeValue;
                    }
                    
                    $ElementErrDesc = $dom->getElementsByTagName('ErrDesc');
                    foreach ($ElementErrDesc as $sErrDesc) {
                        $ErrDesc = $sErrDesc->nodeValue;
                    }
                    
                    $ElementMsg = $dom->getElementsByTagName('Msg');
                    foreach ($ElementMsg as $sMsg) {
                        $Msg = $sMsg->nodeValue;
                    }

                    $this->GrabaLog("ERROR AL CANCELAR DETECNO....!");
                    $this->GrabaLog(sprintf("XML ENVIO............. [%s]", $sXml));
                    $this->GrabaLog(sprintf("UUID ENVIO............ [%s]", $sUuid));
                    $this->GrabaLog(sprintf("ErrCode............... [%s]", $ErrCode));
                    $this->GrabaLog(sprintf("ErrDesc............... [%s]", $ErrDesc));
                    $this->GrabaLog(sprintf("Msg................... [%s]", $Msg));

                    $this->GrabaDebug("ERROR AL CANCELAR DETECNO....!");
                    $this->GrabaDebug(sprintf("XML ENVIO............. [%s]", $sXml));
                    $this->GrabaDebug(sprintf("UUID ENVIO............ [%s]", $sUuid));
                    $this->GrabaDebug(sprintf("ErrCode............... [%s]", $ErrCode));
                    $this->GrabaDebug(sprintf("ErrDesc............... [%s]", $ErrDesc));
                    $this->GrabaDebug(sprintf("Msg................... [%s]", $Msg));
                    
                    if(ErrCode != 201 && ErrCode != 202 && ErrCode != 200) {
                        $sMensaje = $ErrCode." | ".$Msg." | ".$ErrDesc;
                        $iEstado = 2;
                    }
                    else {
                        $iEstado = 0;
                        $sMensaje = 'OK';
                        $hResponse->respuestaPac = $Msg;
                    }
                }
            }
        }
        catch(exception $ex) {
            $iEstado = 2;
            $sMensaje = $ex->getMessage();                
            $this->GrabaLog(sprintf("ERROR EN CANCELAR DETECNO_XML....! [ %s ]",  $sMensaje." UUID ".$sUuid));
            $this->GrabaDebug(sprintf("ERROR EN CANCELAR DETECNO_XML....! [ %s ]",  $sMensaje." UUID ".$sUuid));
        }

        $hResponse->estado = $iEstado;
        $hResponse->mensaje = $sMensaje;

        return $hResponse;
    }
}

?>